/* -----------------------------------------
   $Date: 1996/07/19 13:01:51 $
   $Revision: 1.2 $
   Multiple B/W windows library
   ----------------------------------------- */
#include "winLib.h"
/* -------------------------------------------
   -------- tools for X ----------------------
   ------------------------------------------- */
PlotBlackBoard(ID,buff,xLarge,yLarge)
	 int ID;
	 char *buff;
	 int xLarge, yLarge;
{
  int x,y,i,j;

  SwitchDisplay(ID);
  XFillRectangle(disp,win,gc_over,0,0,xLarge,yLarge); 
  draw_string(gc_font7x14,10,20,buff);
  XFlush(disp);
}

/* --
   Bou Graf
   -- */
PlotBoGraf(data,MaxSeq,dMax,dMin,xL,yL,xpos,ypos,comment)
	 double *data;
	 int MaxSeq; /* # of data */
	 double dMax,dMin; /* max/min of data */
	 int xL, yL, xpos, ypos; /* frame length and origni position of frame */
	 char *comment;
{
  int x,y,i,xsq;

  xsq=xL/MaxSeq;
  XDrawRectangle(disp,win,gc,xpos,ypos,xL,yL);
  for (i=0; i<MaxSeq; ++i) {
	x = xpos+xsq*i;
	y = ypos+yL-((data[i]-dMin)/(dMax-dMin))*yL;
	XFillRectangle(disp,win,gc,x,y,xsq,ypos+yL-y);
  }
  draw_string(gc_font8x16,xpos+20,ypos-10,comment);
  XFlush(disp);
}

/* --
   Plot square at the x-position corresponding to val along horizontal line.
   -- */
PlotBarH(val,dMax,dMin,xL,xpos,ypos)
	 double val,dMax,dMin;
	 int xL,xpos,ypos;
{
  int x;
  if (val>dMax) val=dMax;
  if (val<dMin) val=dMin;
  x = xpos+((val-dMin)/(dMax-dMin))*xL;
  XFillRectangle(disp,win,gc,x-2,ypos-2,4,4);
  XDrawLine(disp,win,gc,xpos,ypos,xpos+xL,ypos);
  XFlush(disp);
}
/* --
   All data: (x,y1,y2 ...yMaxItems-1) * MaxSeq are in data.
   But we use step for x.
   -- */
PlotOresenGraf(data,MaxItems,MaxSeq,yMax,yMin,xL,yL,xpos,ypos,
			   ticSteps,comment,now)
	 double *data;
	 int MaxItems, MaxSeq;
	 double yMax,yMin;
	 int xL, yL, xpos, ypos;
	 int ticSteps; /* interval steps for tic in x */
	 char *comment;
	 int now;
{
  int step, i;
  int x1,y1,x0,y0,xc;

  xc =  xpos+xL*(now)/(MaxSeq+1);
  for (step=1; step<MaxSeq; ++step) {
	x1 = xpos+xL*step/(MaxSeq+1);
	x0 = xpos+xL*(step-1)/(MaxSeq+1);
	
	XFillRectangle(disp,win,gc_over,x0+1,ypos,x1,ypos+yL);
	for (i=1; i<MaxItems; ++i) {
	  if (i==1) XSetForeground(disp,gc,BlackPixel(disp, 0));
	  else if (i==2) XSetForeground(disp,gc,red);
	  else if (i==3) XSetForeground(disp,gc,blue);
	  else if (i==4) XSetForeground(disp,gc,green);
	  else if (i==5) XSetForeground(disp,gc,purple);
	  else if (i==6) XSetForeground(disp,gc,gray3);
	  else if (i==7) XSetForeground(disp,gc,brc[20]);
	  else if (i==8) XSetForeground(disp,gc,brc[40]);
	  else if (i==9) XSetForeground(disp,gc,brc[60]);
	  else XSetForeground(disp,gc,gray1);
	  y1 = ypos+yL*(1.0-(data[step*MaxItems+i]-yMin)/(yMax-yMin));
	  y0 = ypos+yL*(1.0-(data[(step-1)*MaxItems+i]-yMin)/(yMax-yMin));
	  XDrawLine(disp,win,gc,x0,y0,x1,y1);  }
	XSetForeground(disp,gc,BlackPixel(disp, 0));
	if (step % ticSteps == 0)
	  XDrawLine(disp,win,gc,x1,ypos+yL,x1,ypos+yL-yL/20);
  }

  /*
    XDrawLine(disp,win,gc,xc,ypos,xc,ypos+yL); 
  */
  draw_string(gc_font8x16,xpos+20,ypos-8,comment);
  XDrawRectangle(disp,win,gc,xpos,ypos,xL,yL);
  XFlush(disp);
}

plotColorIndex(MaxItems,xpos,ypos)
	 int MaxItems,xpos,ypos;
{
  int x0,x1,y0,y1,i;
  
  for (i=1; i<MaxItems; ++i) {
	char str[256];
	if (i==1) XSetForeground(disp,gc,BlackPixel(disp, 0));
	else if (i==2) XSetForeground(disp,gc,red);
	else if (i==3) XSetForeground(disp,gc,blue);
	else if (i==4) XSetForeground(disp,gc,green);
	else if (i==5) XSetForeground(disp,gc,purple);
	else if (i==6) XSetForeground(disp,gc,gray3);
	else if (i==7) XSetForeground(disp,gc,brc[20]);
	else if (i==8) XSetForeground(disp,gc,brc[40]);
	else if (i==9) XSetForeground(disp,gc,brc[60]);
	else XSetForeground(disp,gc,gray1);
	x0 = xpos;
	x1 = x0+25;
	y0 = ypos+i*15;
	y1 = y0;
	XDrawLine(disp,win,gc,x0,y0,x1,y1);  
	sprintf(str,"%d",i-1);
	draw_string(gc_font8x16,x1+10,y1,str);
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XFlush(disp);
}


/* --
   Basic type: (No X data)
   All data: (y0,y1,y2 ...yMaxItems-1) * MaxSeq are in data.
   -- */

PlotOresenGraf0(data,MaxItems,MaxSeq,yMax,xL,yL,xpos,ypos,ticSteps,comment)
	 double *data;
	 int MaxItems, MaxSeq;
	 double yMax;
	 int xL, yL, xpos, ypos;
	 int ticSteps; /* interval steps for tic in x */
	 char *comment;
{
  int step, i;
  int x1,y1,x0,y0;

  for (step=1; step<MaxSeq; ++step) {
	x1 = xpos+xL*step/(MaxSeq+1);
	x0 = xpos+xL*(step-1)/(MaxSeq+1);
	
	XFillRectangle(disp,win,gc_over,x0+1,ypos,x1,ypos+yL);
	for (i=0; i<MaxItems; ++i) {
	  if (i==0) XSetForeground(disp,gc,BlackPixel(disp, 0));
	  else if (i==1) XSetForeground(disp,gc,red);
	  else if (i==2) XSetForeground(disp,gc,blue);
	  else if (i==3) XSetForeground(disp,gc,purple);
	  else if (i==4) XSetForeground(disp,gc,green);
	  else if (i==5) XSetForeground(disp,gc,gray1);
	  else if (i==6) XSetForeground(disp,gc,gray2);
	  else XSetForeground(disp,gc,gray3);
	  y1 = ypos+yL*(1.0-data[step*MaxItems+i]/yMax);
	  y0 = ypos+yL*(1.0-data[(step-1)*MaxItems+i]/yMax);
	  XDrawLine(disp,win,gc,x0,y0,x1,y1);  }
	XSetForeground(disp,gc,BlackPixel(disp, 0));
	if (step % ticSteps == 0)
	  XDrawLine(disp,win,gc,x1,ypos+yL,x1,ypos+yL-yL/20);
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos,ypos,xL,yL);
  draw_string(gc_font8x16,xpos+20,ypos-10,comment);
}

/* --
   plot Graf by dot and solid lines
   i0 solid 
   i1 solid wide
   i2 dash
   i3 dot
   i4 dash wide
   -- */
PlotOresenGrafDot(data,MaxItems,MaxSeq,yMax,dx,yL,xpos,ypos,ticSteps,comment)
	 double *data;
	 int MaxItems, MaxSeq;
	 double yMax;
	 int dx, yL, xpos, ypos;
	 int ticSteps; /* interval steps for tic in x */
	 char *comment;
{
  int step, i;
  int xL, x1,y1,x0,y0,interval;
  xL = dx*MaxSeq;
  interval = 4/dx; /* interval for dot */
  for (step=1; step<MaxSeq; ++step) { /* solid and wide solid dash and dot lines */
	x1 = xpos+dx*step;
	x0 = xpos+dx*(step-1);	
	XSetForeground(disp,gc,BlackPixel(disp, 0));
	for (i=0; i<MaxItems; ++i) {
	  y1 = ypos+yL*(1.0-data[step*MaxItems+i]/yMax);
	  y0 = ypos+yL*(1.0-data[(step-1)*MaxItems+i]/yMax);
	  
	  if (i==0) { 
		XSetLineAttributes(disp,gc,1,LineSolid,CapButt,JoinMiter);
		XDrawLine(disp,win,gc,x0,y0,x1,y1); }
	  else if (i==1){
		XSetLineAttributes(disp,gc,2,LineSolid,CapButt,JoinMiter);
		XDrawLine(disp,win,gc,x0,y0,x1,y1); }
	  else if (i==2) { 
		XSetLineAttributes(disp,gc,1,LineSolid,CapButt,JoinMiter);
		XDrawLine(disp,win,gc,x0,y0,(x0+x1)/2,(y0+y1)/2); }
	  else if (i==4){
		XSetLineAttributes(disp,gc,2,LineSolid,CapButt,JoinMiter);
		XDrawLine(disp,win,gc,x0,y0,(x0+x1)/2,(y0+y1)/2);}
	  else if (i==3) { 
		XDrawPoint(disp,win,gc,x0,y0);
		XDrawPoint(disp,win,gc,(x0+x1)/2,(y0+y1)/2); }
	  else;
	}
  }

  XSetLineAttributes(disp,gc,1,LineSolid,CapButt,JoinMiter);

  /* tic on time axis */
  for (step=0; step<MaxSeq; ++step) {
	if (step % ticSteps == 0) {
	  char string[256];
	  x1 = xpos+dx*(step);	
	  XDrawLine(disp,win,gc,x1,ypos+yL,x1,ypos+yL-yL/20);
	  sprintf(string,"%d",step); 
	  draw_string(gc_font8x16,x1-10,ypos+yL+15,string);
	}
	XSetForeground(disp,gc,BlackPixel(disp, 0));
  }

  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawLine(disp,win,gc,xpos,ypos+yL,xpos+xL,ypos+yL);
  draw_string(gc_font8x16, xpos+xL/2, ypos+yL+30, "step");
  XDrawLine(disp,win,gc,xpos,ypos+yL,xpos,ypos);
  XDrawLine(disp,win,gc,xpos,ypos,xpos+yL/20,ypos);
  draw_string(gc_font8x16,xpos-30,ypos+10,"1.0");
  XDrawLine(disp,win,gc,xpos,ypos+yL/2,xpos+yL/20,ypos+yL/2);
  draw_string(gc_font8x16,xpos-30,ypos+yL/2+10,"0.5");
  draw_string(gc_font8x16,xpos+20,ypos-10,comment);
  XFlush(disp);
}

/* --
   Centering X axis.
   Basic type: (No X data)
   All data: (y0,y1,y2 ...yMaxItems-1) * MaxSeq are in data.
   -- */
PlotOresenGrafC(data,MaxItems,MaxSeq,yMax,xL,yL,xpos,ypos,ticSteps,comment)
	 double *data;
	 int MaxItems, MaxSeq;
	 double yMax;
	 int xL, yL, xpos, ypos;
	 int ticSteps; /* interval steps for tic in x */
	 char *comment;
{
  int step, i;
  int x1,y1,x0,y0;

  for (step=1; step<MaxSeq; ++step) {
	x1 = xpos+xL*step/(MaxSeq+1);
	x0 = xpos+xL*(step-1)/(MaxSeq+1);
	
	XFillRectangle(disp,win,gc_over,x0+1,ypos,x1,ypos+yL);
	for (i=0; i<MaxItems; ++i) {
	  if (i==0) XSetForeground(disp,gc,BlackPixel(disp, 0));
	  else if (i==1) XSetForeground(disp,gc,red);
	  else if (i==2) XSetForeground(disp,gc,blue);
	  else if (i==3) XSetForeground(disp,gc,purple);
	  else if (i==4) XSetForeground(disp,gc,green);
	  else if (i==5) XSetForeground(disp,gc,gray1);
	  else if (i==6) XSetForeground(disp,gc,gray2);
	  else XSetForeground(disp,gc,gray3);
	  y1 = ypos+yL*(1.0-data[step*MaxItems+i]/yMax);
	  y0 = ypos+yL*(1.0-data[(step-1)*MaxItems+i]/yMax);
	  XDrawLine(disp,win,gc,x0,y0,x1,y1);  }
	XSetForeground(disp,gc,BlackPixel(disp, 0));
	if (step % ticSteps == 0)
	  XDrawLine(disp,win,gc,x1,ypos+yL,x1,ypos+yL/2-yL/20);
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawLine(disp,win,gc,xpos,ypos+yL/2,xpos+xL,ypos+yL/2);
  draw_string(gc_font8x16,xpos+20,ypos-10,comment);
}

/* --------------------------------------------------
   plot squares tool
   -------------------------------------------------- */
/* ------------------------
   black and white
   Vertical drawing
   ------------------------ */
PlotSquaresV(a,max,maxNum,yMax,sqsize,xpos,ypos)
	 double *a, max;
	 int maxNum, yMax, sqsize,xpos,ypos;
{
  int x, y, xi, yi, i, size, xMax;
  xi = 0;
  yi = 0;
  xMax = maxNum/yMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (yi == yMax){
	  yi = 0;
	  ++xi; }
	size = (int)fabs(*(a+i)/max*sqsize);
	if (size>sqsize) size = sqsize;
	if (*(a+i) > 0.0) flag = 1;
	else flag = 0;
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	/* XFillRectangle(disp,win,gc_over,x-sqsize/2,y-sqsize/2,sqsize,sqsize); */
	if (flag == 1) {
	  XSetForeground(disp,gc,blue);
	  XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);}
	else {
	  XSetForeground(disp,gc,red);
	  XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);}
	++yi;
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos-sqsize/2,ypos-sqsize/2,sqsize*xMax,sqsize*yMax);
  XFlush(disp);
}

/* ------------------------
   black and white
   a is from -1.0 to 1.0. 
   Horizontal drawing
   ------------------------ */
PlotSquaresH(a,max,maxNum,xMax,sqsize,xpos,ypos)
	 double *a, max;
	 int maxNum, xMax, sqsize,xpos,ypos;
{
  int x, y, xi, yi, i, size, yMax;
  xi = 0;
  yi = 0;
  yMax = maxNum/xMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	size = abs((int)(*(a+i)/max*sqsize));
	if (size>sqsize) size = sqsize;
	if (*(a+i) > 0.0) flag = 1;
	else flag = 0;
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	/* XFillRectangle(disp,win,gc_over,x-sqsize/2,y-sqsize/2,sqsize,sqsize); */
	if (flag == 1) {
	  XSetForeground(disp,gc,blue);
	  XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);}
	else {
	  XSetForeground(disp,gc,red);
	  XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);}
	++xi;
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos-sqsize/2,ypos-sqsize/2,sqsize*xMax,sqsize*yMax);
  XFlush(disp);
}

/* ------------------------
   gray level
   Plot squares Vertical drawing
   0.0 =< a < 1.0
   ------------------------ */
PlotBRSquaresH(a,maxNum,xMax,sqsize,xpos,ypos,string)
	 double *a;
	 int maxNum, xMax, sqsize,xpos,ypos;
	 char *string;
{
  int x, y, xi, yi, i, level, yMax;
  xi = 0;
  yi = 0;
  if (xMax==0) xMax=1;
    
  yMax = maxNum/xMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	level = (int)(*(a+i) * 64);
	if (level>63) {
	  level=63;
	}
	if (level<0) {
	  level=0;
	}
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XSetForeground(disp,gc,brc[level]);
	XFillRectangle(disp,win,gc,x,y,sqsize,sqsize);
	++xi;
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos,ypos,sqsize*xMax,sqsize*yMax);
  /* memori */
  for (i=0;i<xMax;++i) {
	if (i%5==0) {
	  XDrawLine(disp,win,gc,xpos+sqsize*i,ypos,xpos+sqsize*i,ypos-4);	    	}
	if (i%10==0) {
	  XDrawLine(disp,win,gc,xpos+sqsize*i,ypos,xpos+sqsize*i,ypos-6);	    	}
  }
  for (i=0;i<yMax;++i) {
	if (i%5==0) {
	  XDrawLine(disp,win,gc,xpos,ypos+sqsize*i,xpos-4,ypos+sqsize*i);	    	}
	if (i%10==0) {
	  XDrawLine(disp,win,gc,xpos,ypos+sqsize*i,xpos-6,ypos+sqsize*i);	    	}
  }
  draw_string(gc_font8x16,xpos+20,ypos-10,string);
  XFlush(disp);
}

/* -- unificated abs value is obtained by fabs(a)/maxA -- */
PlotBRSquaresH2(a,maxA,maxNum,xMax,sqsize,xpos,ypos,string)
	 double *a, maxA;
	 int maxNum, xMax, sqsize,xpos,ypos;
	 char *string;
{
  int x, y, xi, yi, i, level, yMax;
  double val;

  xi = 0;
  yi = 0;
  if (xMax==0) xMax=1;
    
  yMax = maxNum/xMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	val = fabs(*(a+i))/maxA;
	level = (int)(val * 64);
	if (level>63) {
	  level=63;
	}
	if (level<0) {
	  level=0;
	}
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XSetForeground(disp,gc,brc[level]);
	XFillRectangle(disp,win,gc,x,y,sqsize,sqsize);
	++xi;
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos,ypos,sqsize*xMax,sqsize*yMax);
  draw_string(gc_font8x16,xpos+20,ypos-10,string);
  XFlush(disp);
}


PlotBRSquaresV(a,maxNum,yMax,sqsize,xpos,ypos,string)
	 double *a;
	 int maxNum, yMax, sqsize,xpos,ypos;
	 char *string;
{
  int x, y, xi, yi, i, level, xMax;
  xi = 0;
  yi = 0;
  if (yMax==0) yMax=1;
    
  xMax = maxNum/yMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (yi == yMax){
	  yi = 0;
	  ++xi; }
	level = (int)(*(a+i) * 64);
	if (level>63) {
	  level=63;
	}
	if (level<0) {
	  level=0;
	}
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XSetForeground(disp,gc,brc[level]);
	XFillRectangle(disp,win,gc,x,y,sqsize,sqsize);
	++yi;
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos,ypos,sqsize*xMax,sqsize*yMax);
  /* memori */
  for (i=0;i<xMax;++i) {
	if (i%5==0) {
	  XDrawLine(disp,win,gc,xpos+sqsize*i,ypos,xpos+sqsize*i,ypos-4);	    	}
	if (i%10==0) {
	  XDrawLine(disp,win,gc,xpos+sqsize*i,ypos,xpos+sqsize*i,ypos-6);	    	}
  }
  for (i=0;i<yMax;++i) {
	if (i%5==0) {
	  XDrawLine(disp,win,gc,xpos,ypos+sqsize*i,xpos-4,ypos+sqsize*i);	    	}
	if (i%10==0) {
	  XDrawLine(disp,win,gc,xpos,ypos+sqsize*i,xpos-6,ypos+sqsize*i);	    	}
  }
  draw_string(gc_font8x16,xpos+20,ypos-10,string);
  XFlush(disp);
}



PlotSquare(x,y,sqx,sqy)
	 int x,y,sqx,sqy;
{
  XDrawRectangle(disp,win,gc,x,y,sqx,sqy);
}

/* grey level colored square */
PlotGRAYSquare(x,y,sqsize,amp)
	 int x,y,sqsize;
	 double amp;
{
  int level;
  level = (int)(amp * 64);
  if (level>63) {
	level=63;
  }
  if (level<0) {
	level=0;
  }
  XSetForeground(disp,gc,wbc[level]);
  XFillRectangle(disp,win,gc,x,y,sqsize,sqsize);
}

PlotGREYSquareS(iniX,iniY,sqsize,iMax,jMax,a)
	 int iniX,iniY,sqsize,iMax,jMax;
	 double *a;
{
  int i,j,x,y;
  for (j=0; j<jMax; ++j) {
	for (i=0; i<iMax; ++i) {
	  PlotGRAYSquare(iniX+sqsize*i,iniY+sqsize*j,sqsize,a[iMax*j+i]);
	}
  }
  XFlush(disp);
}







/* ------------------------
   black and white
   a is from -1.0 to 1.0. 
   Vertical drawing from bottom to up.
   ------------------------ */
PlotSquaresV2(a,maxNum,xMax,sqsize,xpos,ypos)
	 double *a;
	 int maxNum, xMax, sqsize,xpos,ypos;
{
  int x, y, xi, yi, i, size, yMax;
  xi = 0;
  yi = 0;
  yMax = maxNum/xMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	size = abs((int)(*(a+i)*sqsize));
	if (size>sqsize) size = sqsize;
	if (*(a+i) > 0.0) flag = 1;
	else flag = 0;
	x = xpos+xi*sqsize;
	y = ypos-yi*sqsize;
	/* XFillRectangle(disp,win,gc_over,x-sqsize/2,y-sqsize/2,sqsize,sqsize); */
	if (flag == 1)
	  XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);
	else XDrawRectangle(disp,win,gc,x-size/2,y-size/2,size,size);
	++xi;
  }
}


/* ------------------------
   black and white
   a is from -1.0 to 1.0. 
   Horizontal drawing
   ------------------------ */
PlotColumnH(a,maxNum,yMax,w0,h0,space,xpos,ypos)
	 double *a;
	 int maxNum,yMax,w0,h0,space,xpos,ypos;
{
  int x, y, xi, yi, i, sizex, sizey, xMax, xEnd, yEnd;
  xi = 0;
  yi = 0;
  xMax = maxNum/yMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (yi == yMax){
	  yi = 0;
	  ++xi; }
	sizex = (int)(*(a+i)*w0);
	if (sizex>w0) sizex = w0;
	if (sizex<0) sizex = 0;
	x = xpos+xi*(w0+space);
	y = ypos+yi*(h0+space);
	XFillRectangle(disp,win,gc_over,x,y,w0,h0); 
	XDrawRectangle(disp,win,gc,x,y,w0,h0);
	XFillRectangle(disp,win,gc,x,y,sizex,h0);
	++yi;
  }

  /* fill while color after columns */
  xEnd = xpos+(xi+1)*(w0+space);
  yEnd = ypos;
  XFlush(disp);
}

/* added by west for color version Wed May 29 20:32:12 JST 1996 */
PlotSquares2(a,maxNum,xMax,sqsize,xpos,ypos,color,bgcolor)
	 double *a;
	 int maxNum, xMax, sqsize,xpos,ypos,bgcolor;
	 unsigned long color;
{
  int x, y, xi, yi, i, size;
  xi = 0;
  yi = 0;
  for (i=0; i<maxNum; ++i) {
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	size = (int)(*(a+i)*sqsize);
	if (size < 0) size = 0;
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XSetForeground(disp, gc_over, bgcolor);
	XFillRectangle(disp,win,gc_over,x-sqsize/2,y-sqsize/2,sqsize,sqsize);
	XSetForeground(disp, gc_over, WhitePixel(disp, 0));
	XSetForeground(disp, gc, color);
	XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);
	++xi;
  }
  XSetForeground(disp, gc, BlackPixel(disp, 0));
}

PlotSquares3(a,maxNum,xMax,sqsize,xpos,ypos,color)
	 double *a;
	 int maxNum, xMax, sqsize,xpos,ypos;
	 unsigned long color;
{
  int x, y, xi, yi, i, size;
  xi = 0;
  yi = 0;
  XSetForeground(disp, gc, color);
  for (i=0; i<maxNum; ++i) {
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	size = (int)(*(a+i)*sqsize);
	if (size < 0) size = 0;
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);
	++xi;
  }
  XSetForeground(disp, gc, BlackPixel(disp, 0));
}

PlotSquares4(a,maxNum,xMax,sqsize,xpos,ypos,color)
	 double *a;
	 int maxNum, xMax, sqsize,xpos,ypos;
	 unsigned long color;
{
  int x, y, xi, yi, i, size, yMax;
  yMax = maxNum/xMax;
  xi = 0;
  yi = 0;
  XSetForeground(disp, gc, color);
  for (i=0; i<maxNum; ++i) {
	if (xi == xMax){
	  xi = 0;
	  ++yi; }
	size = (int)(*(a+i)*sqsize);
	if (size < 1) size = 1;
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XFillRectangle(disp,win,gc,x-size/2,y-size/2,size,size);
	++xi;
  }
  XDrawRectangle(disp,win,gc,xpos-sqsize/2,ypos-sqsize/2,sqsize*xMax,sqsize*yMax);
  XSetForeground(disp, gc, BlackPixel(disp, 0));
}

PlotInvariantSet(x,y,maxSteps,dispID)
	 double *x,*y;
	 int maxSteps;
	 int dispID;
{
  int step;
  int InitX = 10, InitY = 10;
  double scale = 1.3;
  double minX = 100.0, maxX = -100.0, minY = 100.0, maxY = -100.0;

  for (step=0; step<maxSteps; ++step) {
	if (x[step] < minX) minX = x[step];
	if (y[step] < minY) minY = y[step];
	if (x[step] > maxX) maxX = x[step];
	if (y[step] > maxY) maxY = y[step]; }

  SwitchDisplay(dispID);
  XFillRectangle(disp,win,gc_over,0,0,800,800); 
  MinX = minX; MinY=minY; MaxX=maxX; MaxY=maxY; /* for global value preservation */

  for (step=0; step<maxSteps; ++step) {
	int xi, yi;
	if (maxX-minX == 0.0)
	  xi = InitX+(int)((x[step]-minX)*100.0*scale);
	else
	  xi = InitX+(int)((x[step]-minX)/(maxX-minX)*100.0*scale);
	if (maxY-minY == 0.0)
	  yi = InitY+(int)((y[step]-minY)*100.0*scale);
	else
	  yi = InitY+(int)((y[step]-minY)/(maxY-minY)*100.0*scale);
	XDrawPoint(disp,win,gc,xi,yi); 
  }
  XDrawRectangle(disp,win,gc,InitX-5,InitY-5,(int)(100.0*scale)+10,
				 (int)(100.0*scale)+10);
  XFlush(disp);    
}

PlotInvariantSet2(x,y,maxSteps,dispID)
	 double *x,*y;
	 int maxSteps;
	 int dispID;
{
  int step;
  int InitX = 10, InitY = 10;
  double scale = 1.3;
  double minX = 100.0, maxX = -100.0, minY = 100.0, maxY = -100.0;

  SwitchDisplay(dispID);
  XFillRectangle(disp,win,gc_over,0,0,800,800); 
  minX = MinX; minY=MinY; maxX=MaxX; maxY=MaxY;
  for (step=0; step<maxSteps; ++step) {
	int xi, yi;
	if (maxX-minX == 0.0)
	  xi = InitX+(int)((x[step]-minX)*100.0*scale);
	else
	  xi = InitX+(int)((x[step]-minX)/(maxX-minX)*100.0*scale);
	if (maxY-minY == 0.0)
	  yi = InitY+(int)((y[step]-minY)*100.0*scale);
	else
	  yi = InitY+(int)((y[step]-minY)/(maxY-minY)*100.0*scale);
	XDrawPoint(disp,win,gc,xi,yi); 
  }
  XDrawRectangle(disp,win,gc,InitX-5,InitY-5,(int)(100.0*scale)+10,
				 (int)(100.0*scale)+10);
  XFlush(disp);    
}

/* --
   MinX, MinY comes from global which is set after PlotInvariantSet()
   -- */
PlotLines(x,y,maxSteps,dispID)
	 double *x,*y;
	 int maxSteps;
	 int dispID;
{
  int step, xi, yi, xp, yp;
  int InitX = 10, InitY = 10;
  double scale = 1.3;
  double minX = 100.0, maxX = -100.0, minY = 100.0, maxY = -100.0;

  minX = MinX; minY=MinY; maxX=MaxX; maxY=MaxY;

  SwitchDisplay(dispID);
  XFillRectangle(disp,win,gc_over,0,0,800,800); 

  for (step=0; step<maxSteps; ++step) {
	
	if (maxX-minX == 0.0)
	  xi = InitX+(int)((x[step]-minX)*100.0*scale);
	else
	  xi = InitX+(int)((x[step]-minX)/(maxX-minX)*100.0*scale);
	if (maxY-minY == 0.0)
	  yi = InitY+(int)((y[step]-minY)*100.0*scale);
	else
	  yi = InitY+(int)((y[step]-minY)/(maxY-minY)*100.0*scale);
	if (step>0) {
	  XDrawLine(disp,win,gc,xi,yi,xp,yp); 
	  fprintf(stderr,"(%d %d) ",xp,yp); }
	xp = xi; yp = yi;
  }
  XDrawRectangle(disp,win,gc,InitX,InitY,(int)(100.0*scale),
				 (int)(100.0*scale));
  XFlush(disp);    
}

/* --
   plot line
   -- */
PlotLine(x0,y0,x1,y1)
	 int x0,y0,x1,y1;
{
  XDrawLine(disp,win,gc,x0,y0,x1,y1);
}
/* --
   plot line
   -- */
plotLineColor(x0,y0,x1,y1,i)
	 int x0,y0,x1,y1,i;
{
  if (i==0) XSetForeground(disp,gc,BlackPixel(disp, 0));
  else if (i==1) XSetForeground(disp,gc,red);
  else if (i==2) XSetForeground(disp,gc,blue);
  else if (i==3) XSetForeground(disp,gc,green);
  else if (i==4) XSetForeground(disp,gc,purple);
  else if (i==5) XSetForeground(disp,gc,gray3);
  else if (i==6) XSetForeground(disp,gc,brc[20]);
  else if (i==7) XSetForeground(disp,gc,brc[40]);
  else if (i==8) XSetForeground(disp,gc,brc[60]);
  else XSetForeground(disp,gc,gray1);

  XDrawLine(disp,win,gc,x0,y0,x1,y1);
}

plotPoint(xi,yi)
	 int xi, yi;
{

  XDrawPoint(disp,win,gc,xi,yi); 
}

plotPointColor(xi,yi,i)
	 int xi, yi,i;
{
  if (i==0) XSetForeground(disp,gc,BlackPixel(disp, 0));
  else if (i==1) XSetForeground(disp,gc,red);
  else if (i==2) XSetForeground(disp,gc,blue);
  else if (i==3) XSetForeground(disp,gc,green);
  else if (i==4) XSetForeground(disp,gc,purple);
  else if (i==5) XSetForeground(disp,gc,gray3);
  else if (i==6) XSetForeground(disp,gc,brc[20]);
  else if (i==7) XSetForeground(disp,gc,brc[40]);
  else if (i==8) XSetForeground(disp,gc,brc[60]);
  else XSetForeground(disp,gc,gray1);
  XDrawPoint(disp,win,gc,xi,yi); 
}

/* ------------------------------------------------
   ------------------------------------------------
   Below this is for MultipleWin
   ------------------------------------------------
   ------------------------------------------------ */

/* ---------------------------------------------
   X-Windows Initialize
   --------------------------------------------- */
InitX(x,y,width,height,xName)
	 int x,y,width,height;
	 char *xName;
{
  XSetWindowAttributes attributes;
  XWMHints wmh;
  XSizeHints sizehint;
  char cn[8];
  int i;

  if (InitXFlag != 1) {
	disp = XOpenDisplay(NULL);
	InitXFlag=1;
  }
  parent = DefaultRootWindow(disp);
  /* for DEBUG */
  
  /* XSynchronize(disp, True); */
  
  win = XCreateSimpleWindow(disp, parent, x, y, width, height, 2,
							WhitePixel(disp, 0), WhitePixel(disp, 0));
  sizehint.flags = (USPosition | USSize);
  XSetWMNormalHints(disp, win, &sizehint);
  XStoreName(disp, win, xName);
  attributes.save_under = True;
  attributes.backing_store = Always;
  XChangeWindowAttributes(disp, win, CWBackingStore | CWSaveUnder,
						  &attributes);
  XMapWindow(disp, win);
  gc = XCreateGC(disp, win, 0,0);
  XSetForeground(disp, gc, BlackPixel(disp, 0));
  gc_over = XCreateGC(disp, win, 0,0);
  XSetForeground(disp, gc_over, WhitePixel(disp, 0));

  /* Color define added by west Wed May 29 20:32:12 JST 1996 */

  red = XWGetColorByName(disp, "red");
  green = XWGetColorByName(disp, "green");
  blue = XWGetColorByName(disp, "blue");
  purple = XWGetColorByName(disp, "purple");
  gray1 = XWGetColorByName(disp, "gray90");
  gray2 = XWGetColorByName(disp, "gray60");
  gray3 = XWGetColorByName(disp, "gray30");
  yellow = XWGetColorByName(disp, "yellow");
  steelblue1 = XWGetColorByName(disp, "steelblue1");

  /* -- Color defined by sugita 99/10  
	 brc[64] -- */

  for (i = 0; i < 10; i++) { 
	sprintf(cn, "#0000%02x", i*12+123);
	brc[i]= XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 11; i++) {
	sprintf(cn, "#00%02xff", i*25);
	brc[i+10] = XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 11; i++) {
	sprintf(cn, "#%02xffff", i*24);
	brc[i+21] = XWGetColorByName(disp, cn);
  }
  brc[32] = XWGetColorByName(disp, "#ffffff");
  for (i = 0; i < 11; i++) {
	sprintf(cn, "#ff%02x%02x", 0xff-i*12, 0xf4-i*24);
	brc[i+33] = XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 10; i++) {
	sprintf(cn, "#ff%02x00", 0x80-i*12);
	brc[i+44] = XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 10; i++) {
	sprintf(cn, "#%02x0000", 0xff-i*12);
	brc[i+54] = XWGetColorByName(disp, cn);
  }
	  
  /* set white->black color table
	 wbc[64] */
  for (i = 0; i < 64; i++) {
	// sprintf(cn, "#%02x%02x%02x", 256-i*4, 256-i*4, 256-i*4); //white->black
	sprintf(cn, "#%02x%02x%02x", i*4, i*4, i*4); // black->white
	wbc[i] = XWGetColorByName(disp, cn);
  }

  /* Font define */
  gc_font7x14 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font7x14, BlackPixel(disp, 0));
  f7x14 = XLoadFont(disp,"7x14");
  XSetFont (disp,gc_font7x14,f7x14);

  gc_font8x16 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font8x16, BlackPixel(disp, 0));
  f8x16 = XLoadFont(disp,"8x16");
  XSetFont (disp,gc_font8x16,f8x16);

  gc_font10x20 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font10x20, BlackPixel(disp, 0));
  f10x20 = XLoadFont(disp,"10x20");
  XSetFont (disp,gc_font10x20,f10x20);

  gc_font12x24 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font12x24, BlackPixel(disp, 0));
  f12x24 = XLoadFont(disp,"12x24");
  XSetFont (disp,gc_font12x24,f12x24);

  gc_fontwest1 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_fontwest1, BlackPixel(disp, 0));
  fwest1 = XLoadFont(disp,"-adobe-*-*-i-*-*-25-*-*-*-*-*-*-*");
  XSetFont (disp,gc_fontwest1,fwest1);

  gc_fontwest2 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_fontwest2, BlackPixel(disp, 0));
  fwest2 = XLoadFont(disp,"-bitstream-*-*-i-*-*-30-*-*-*-*-*-*-*");
  XSetFont (disp,gc_fontwest2,fwest2);

  XFillRectangle(disp,win,gc_over,0,0,10,10);
  XFlush(disp);
      
}

/* --
   when using grey leveled 
   -- */
InitXGray(x,y,width,height,xName)
	 int x,y,width,height;
	 char *xName;
{
  XSetWindowAttributes attributes;
  XWMHints wmh;
  XSizeHints sizehint;

  if (InitXFlag != 1) {
	disp = XOpenDisplay(NULL);
	InitXFlag=1;
  }
  parent = DefaultRootWindow(disp);
  /* for DEBUG */
  /*
	XSynchronize(disp, True); 
  */
  win = XCreateSimpleWindow(disp, parent, x, y, width, height, 2,
							WhitePixel(disp, 0), WhitePixel(disp, 0));
  sizehint.flags = (USPosition | USSize);
  XSetWMNormalHints(disp, win, &sizehint);
  XStoreName(disp, win, xName);
  attributes.save_under = True;
  attributes.backing_store = Always;
  XChangeWindowAttributes(disp, win, CWBackingStore | CWSaveUnder,
						  &attributes);
  XMapWindow(disp, win);
  gc = XCreateGC(disp, win, 0,0);
  XSetForeground(disp, gc, BlackPixel(disp, 0));
  gc_over = XCreateGC(disp, win, 0,0);
  XSetForeground(disp, gc_over, WhitePixel(disp, 0));

  /* Color define added by west Wed May 29 20:32:12 JST 1996 */

  grayc[0] = XWGetColorByName(disp, "gray95");
  grayc[1] = XWGetColorByName(disp, "gray90");
  grayc[2] = XWGetColorByName(disp, "gray80");
  grayc[3] = XWGetColorByName(disp, "gray70");
  grayc[4] = XWGetColorByName(disp, "gray60");
  grayc[5] = XWGetColorByName(disp, "gray50");
  grayc[6] = XWGetColorByName(disp, "gray40");
  grayc[7] = XWGetColorByName(disp, "gray30");
  grayc[8] = XWGetColorByName(disp, "gray20");
  grayc[9] = XWGetColorByName(disp, "gray10");

  /* Font define */
  gc_font7x14 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font7x14, BlackPixel(disp, 0));
  f7x14 = XLoadFont(disp,"7x14");
  XSetFont (disp,gc_font7x14,f7x14);

  gc_font8x16 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font8x16, BlackPixel(disp, 0));
  f8x16 = XLoadFont(disp,"8x16");
  XSetFont (disp,gc_font8x16,f8x16);

  gc_font10x20 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font10x20, BlackPixel(disp, 0));
  f10x20 = XLoadFont(disp,"10x20");
  XSetFont (disp,gc_font10x20,f10x20);

  gc_font12x24 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font12x24, BlackPixel(disp, 0));
  f12x24 = XLoadFont(disp,"12x24");
  XSetFont (disp,gc_font12x24,f12x24);

  gc_fontwest1 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_fontwest1, BlackPixel(disp, 0));
  fwest1 = XLoadFont(disp,"-adobe-*-*-i-*-*-25-*-*-*-*-*-*-*");
  XSetFont (disp,gc_fontwest1,fwest1);

  gc_fontwest2 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_fontwest2, BlackPixel(disp, 0));
  fwest2 = XLoadFont(disp,"-bitstream-*-*-i-*-*-30-*-*-*-*-*-*-*");
  XSetFont (disp,gc_fontwest2,fwest2);

  XFillRectangle(disp,win,gc_over,0,0,10,10);
  XFlush(disp);
      
}

/* --
   when using grey leveled Blue->Red
   -- */
InitXBR(x,y,width,height,xName)
	 int x,y,width,height;
	 char *xName;
{
  int i;
  XSetWindowAttributes attributes;
  XWMHints wmh;
  XSizeHints sizehint;
  char cn[8];

  disp = XOpenDisplay(NULL);
  parent = DefaultRootWindow(disp);
  /* for DEBUG */
  /*
	XSynchronize(disp, True); 
  */
  win = XCreateSimpleWindow(disp, parent, x, y, width, height, 2,
							WhitePixel(disp, 0), WhitePixel(disp, 0));
  sizehint.flags = (USPosition | USSize);
  XSetWMNormalHints(disp, win, &sizehint);
  XStoreName(disp, win, xName);
  attributes.save_under = True;
  attributes.backing_store = Always;
  XChangeWindowAttributes(disp, win, CWBackingStore | CWSaveUnder,
						  &attributes);
  XMapWindow(disp, win);
  gc = XCreateGC(disp, win, 0,0);
  XSetForeground(disp, gc, BlackPixel(disp, 0));
  gc_over = XCreateGC(disp, win, 0,0);
  XSetForeground(disp, gc_over, WhitePixel(disp, 0));

  /* -- Color defined by sugita 99/10  
	 brc[64] -- */

  for (i = 0; i < 10; i++) { 
	sprintf(cn, "#0000%02x", i*12+123);
	brc[i]= XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 11; i++) {
	sprintf(cn, "#00%02xff", i*25);
	brc[i+10] = XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 11; i++) {
	sprintf(cn, "#%02xffff", i*24);
	brc[i+21] = XWGetColorByName(disp, cn);
  }
  brc[32] = XWGetColorByName(disp, "#ffffff");
  for (i = 0; i < 11; i++) {
	sprintf(cn, "#ff%02x%02x", 0xff-i*12, 0xf4-i*24);
	brc[i+33] = XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 10; i++) {
	sprintf(cn, "#ff%02x00", 0x80-i*12);
	brc[i+44] = XWGetColorByName(disp, cn);
  }
  for (i = 0; i < 10; i++) {
	sprintf(cn, "#%02x0000", 0xff-i*12);
	brc[i+54] = XWGetColorByName(disp, cn);
  }

  /* Font define */
  gc_font7x14 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font7x14, BlackPixel(disp, 0));
  f7x14 = XLoadFont(disp,"7x14");
  XSetFont (disp,gc_font7x14,f7x14);

  gc_font8x16 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font8x16, BlackPixel(disp, 0));
  f8x16 = XLoadFont(disp,"8x16");
  XSetFont (disp,gc_font8x16,f8x16);

  gc_font10x20 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font10x20, BlackPixel(disp, 0));
  f10x20 = XLoadFont(disp,"10x20");
  XSetFont (disp,gc_font10x20,f10x20);

  gc_font12x24 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_font12x24, BlackPixel(disp, 0));
  f12x24 = XLoadFont(disp,"12x24");
  XSetFont (disp,gc_font12x24,f12x24);

  gc_fontwest1 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_fontwest1, BlackPixel(disp, 0));
  fwest1 = XLoadFont(disp,"-adobe-*-*-i-*-*-25-*-*-*-*-*-*-*");
  XSetFont (disp,gc_fontwest1,fwest1);

  gc_fontwest2 = XCreateGC(disp,win,0,0);
  XSetForeground(disp,gc_fontwest2, BlackPixel(disp, 0));
  fwest2 = XLoadFont(disp,"-bitstream-*-*-i-*-*-30-*-*-*-*-*-*-*");
  XSetFont (disp,gc_fontwest2,fwest2);

  XFillRectangle(disp,win,gc_over,0,0,10,10);
  XFlush(disp);
      
}

/* -----------------------------------------
   set display for multiple windows for initial
   ----------------------------------------- */
SetDisplay(id)
	 int id;
{	
  disp_[id] = disp;
  win_[id] = win;
  gc_[id] = gc;
  gc_over_[id] = gc_over;
  gc_font7x14_[id] = gc_font7x14;
  gc_font8x16_[id] = gc_font8x16;
  gc_font10x20_[id] = gc_font10x20;
  gc_font12x24_[id] = gc_font12x24;
    
}


/* -----------------------------------------
   switch display
   ----------------------------------------- */
SwitchDisplay(id)
	 int id;
{	
  disp = disp_[id];
  win = win_[id];
  gc = gc_[id];
  gc_over = gc_over_[id];
  gc_font7x14 = gc_font7x14_[id];
  gc_font8x16 = gc_font8x16_[id];
  gc_font10x20 = gc_font10x20_[id];
  gc_font12x24 = gc_font12x24_[id];
}

    
/* -----------------------------------------
    draw_string
   ----------------------------------------- */

drawString(x,y,buffer1)
	 int x,y;
	 char *buffer1;
{ 
  draw_string(gc_font8x16,x,y,buffer1);
}


draw_string(gc_font,x,y,buffer1)
	 GC gc_font;
	 int x,y;
	 char *buffer1;
{ 
  int i,num;
  for (i=0; i<100; ++i)
    { if (buffer1[i] == '\0') 
	  { num = i;
	  i=100; }
    }

  /* sprintf(buffer1,"type something"); */
  /* XFillRectangle(disp,win,gc_over,20,530,500,20); */
  XDrawString (disp,win,gc_font,x,y,buffer1,num+1);
  /* fprintf(stderr,"d_s "); */
  /* XFlush(disp); */
}

XFlushDisp()
{
  XFlush(disp);
}


XFillBlank(id)
	 int id;
{
  SwitchDisplay(id);
  XFillRectangle(disp,win,gc_over,0,0,2000,2000);
}

XFillBlankSize(id,x,y)
	 int id,x,y;
{
  SwitchDisplay(id);
  XFillRectangle(disp,win,gc_over,0,0,x,y);
}

/* --
   Color Handling utilities from wxutil.c
   -- */
unsigned long XWGetColorByName(Display *disp, char *name)
{
  Colormap cmap;
  XColor c0, c1;
  cmap = DefaultColormap(disp, 0);
  XAllocNamedColor(disp, cmap, name, &c1, &c0);
  return(c1.pixel);
}

unsigned long *XWGetGrayscaleCells(Display *disp, int max)
{
  XColor color;
  Colormap cmap;
  unsigned long *pixels, plane_mask[1];
  int i;

  cmap = DefaultColormap(disp, 0);
  pixels = (unsigned long *)malloc(sizeof(unsigned long)*max);

  color.flags = DoRed | DoGreen | DoBlue;
  XAllocColorCells(disp, cmap, False, plane_mask, 0, pixels, max);
  for(i = 0; i < max; i++){
	color.pixel = pixels[i];
	color.red  =  65536/max*i;
	color.green  = 65536/max*i;
	color.blue  = 65536/max*i;
	XStoreColor(disp, cmap, &color);
  }
  return pixels;
}

void XWDefineWMSettings(Display *disp, Window win,
						int basewidth, int baseheight, int minwidth, int minheight,
						int maxwidth, int maxheight, Bool iconflag, char *iconbmfile,
						char *iconbmmaskfile, Bool iconify)
{
  XSizeHints sizehint;
  XWMHints wmh;
  Pixmap bmap, bmapmask;
  int xh, yh;
  unsigned int width, height;

  sizehint.flags = (USPosition | USSize | PBaseSize |PMinSize | PMaxSize);
  if(basewidth != 0){
	sizehint.base_width = basewidth;
  }
  if(baseheight != 0){
	sizehint.base_height = baseheight;
  }
  if(minwidth != 0){
	sizehint.min_width = minwidth;
  }
  if(minheight != 0){
	sizehint.min_height = minheight;
  }
  if(maxwidth != 0){
	sizehint.max_width = maxwidth;
  }
  if(maxheight != 0){
	sizehint.max_height = maxheight;
  }
  XSetWMNormalHints(disp, win, &sizehint);

  if(True == iconflag){
	XReadBitmapFile(disp, win, iconbmfile, &width, &height, &bmap,
					&xh, &yh);
	wmh.flags = IconPixmapHint | StateHint;
	wmh.icon_pixmap = bmap;
	if(iconbmmaskfile != NULL){
	  XReadBitmapFile(disp, win, iconbmmaskfile, &width, &height,
					  &bmapmask, &xh, &yh);
	  wmh.icon_mask = bmapmask;
	}
  }
  if(True == iconify){
	wmh.initial_state = IconicState;
  }else{
	wmh.initial_state = NormalState;
  }
  XSetWMHints(disp, win, &wmh);
}


PlotGRAYSquaresV(a,maxNum,yMax,sqsize,xpos,ypos,string)
	 double *a;
	 int maxNum, yMax, sqsize,xpos,ypos;
	 char *string;
{
  int x, y, xi, yi, i, level, xMax;
  xi = 0;
  yi = 0;
  if (yMax==0) yMax=1;
    
  xMax = maxNum/yMax;

  for (i=0; i<maxNum; ++i) {
	int flag;
	if (yi == yMax){
	  yi = 0;
	  ++xi; }
	level = (int)(*(a+i) * 64);
	if (level>63) {
	  level=63;
	}
	if (level<0) {
	  level=0;
	}
	x = xpos+xi*sqsize;
	y = ypos+yi*sqsize;
	XSetForeground(disp,gc,wbc[level]);
	XFillRectangle(disp,win,gc,x,y,sqsize,sqsize);
	++yi;
  }
  XSetForeground(disp,gc,BlackPixel(disp, 0));
  XDrawRectangle(disp,win,gc,xpos,ypos,sqsize*xMax,sqsize*yMax);
  /* memori */
  for (i=0;i<xMax;++i) {
	if (i%5==0) {
	  XDrawLine(disp,win,gc,xpos+sqsize*i,ypos,xpos+sqsize*i,ypos-4);	    	}
	if (i%10==0) {
	  XDrawLine(disp,win,gc,xpos+sqsize*i,ypos,xpos+sqsize*i,ypos-6);	    	}
  }
  for (i=0;i<yMax;++i) {
	if (i%5==0) {
	  XDrawLine(disp,win,gc,xpos,ypos+sqsize*i,xpos-4,ypos+sqsize*i);	    	}
	if (i%10==0) {
	  XDrawLine(disp,win,gc,xpos,ypos+sqsize*i,xpos-6,ypos+sqsize*i);	    	}
  }
  draw_string(gc_font8x16,xpos+20,ypos-10,string);
  XFlush(disp);
}
