/* -------------------
   Tani's library
   ------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
/*
#include <X11/Xlib.h>
#include <X11/Xutil.h>
*/
#include "taniLib.h"

int i, j, k;

/* ---------------------------
   ---------------------------
   I/O
   ---------------------------
   --------------------------- */

/* --
   print double vector of a[n]
   -- */
PrintVectorF(a,n,string)
double *a;
int n;
char *string;
{
    fprintf(stderr,"\n%s ",string);
    for (i=0; i<n; ++i) {
	fprintf(stderr,"%f ",a[i]);
    }
}

/* --
   print array out of matrics specified as y=yc.
   -- */
PrintYokoFile(a,n,maxY,yc,string,file)
double *a; /* matrics */
int n,maxY,yc; /* n: maxNum, yc: specified y */
char *string;
FILE *file;
{
    int maxX, x, y;
    maxX = n/maxY;
    fprintf(file,"\n%s ",string);
    for (x=0; x<maxX; ++x) fprintf(file,"%f ",a[maxY*x+yc]);
}

ReadVectorF(a,n)
double *a;
int n;
{
    for (i=0; i<n; ++i) {
	scanf("%lf",a+i);
    }
}

putSpaces(spaces,n)
char *spaces;
int n;
{
    int i=0,ii=0;
    for (i=0; i<n; ++i) {
	spaces[ii]= '-';
	++ii;
	spaces[ii]= ' ';
	++ii; }
    spaces[ii] = '\0';
}

cpVectorI(a,b,n)
	 int *a, *b, n;
{
  int i;
  for (i=0; i<n; ++i) b[i] = a[i];
}

/* -------------------------------------
   -------------------------------------
   NUMERICAL
   -------------------------------------
   ------------------------------------- */
/* --------------------------------------------------------
   logistic
   -------------------------------------------------------- */
double logistic(x)
double x;
{
    return (1.0 / (1.0 + exp(-x)));
}

double logisticInv(y)
double y;
{


    if (y>0.999) {
	  fprintf(stderr,"WARNING: logisticInv%f ",y);
	  y=0.999;
	}
    if (y<0.001) {
	  fprintf(stderr,"WARNING: logisticInv%f ",y);
	  y=0.001;
	}

    return (log(y/(1.0-y)));
}

/* --
   obtain winL time ave upto cstep and put into values into out
   -- */
aveSequence(data,out,n,cstep,winL)
	 double *data, *out;
	 int n, cstep, winL;
{
  int i,step,sstep,estep,l;

  estep=cstep+1;
  sstep = estep-winL;
  l=estep-sstep;
  if (sstep<0) sstep=0;

  for (i=0; i<n; ++i) out[i]=0.0;

  for (i=0; i<n; ++i) {
	for (step=sstep; step<estep; ++step) {
	  out[i] += data[step*n+i];
	}
	out[i] = out[i]/(l);
  }
}

smoothSequence(data,n,initStep,endStep,winL)
	 double *data;
	 int n, initStep, endStep,winL;
{
  int step;
  double *tmp;

  tmp=(double *)calloc(n*(endStep-initStep),sizeof(double));
  for (step=initStep; step<endStep; ++step) {
	int sstep,estep,istep,i,length;
	sstep=step-winL/2;
	if (sstep<initStep) sstep=initStep;
	estep = step+winL/2+1;
	if (estep>endStep) estep=endStep;
	length = estep-sstep;
	for (istep=sstep;istep<estep;++istep) {
	  for (i=0; i<n; ++i) {
		tmp[n*step+i] += data[n*istep+i]; }
	}
	for (i=0; i<n; ++i) {
	  data[n*step+i] = tmp[n*step+i]/length;
	}
  }
  free(tmp);
}


shishagonyu(x)
double x;
{
    int ans;
    if (x-(double)((int)x)>0.5) ans = (int)x + 1;
    else ans = (int)x;
    return ans;
}

double deltaScale(a, a_p, scale)
double a, a_p, scale;
{
    double delta;
    delta = (a - a_p)/scale + 0.5;
    if (delta>1.0) delta=1.0;
    if (delta<0.0) delta=0.0;
    return (delta);
}

double deltaScaleInv(delta, a_p, scale)
double delta, a_p, scale;
{
    double a;
    a = (delta-0.5)*scale + a_p;
    if (a>1.0) a=1.0;
    if (a<0.0) a=0.0;
    return (a);
}


/* --
   copy double vector from a[n] to b[n]
   -- */
CopyVectorF(a,b,n)
double *a, *b;
int n;
{
    for (i=0; i<n; ++i) {
	b[i] = a[i];
    }
}

CopyVectorI(a,b,n)
int *a, *b;
int n;
{
    for (i=0; i<n; ++i) {
	b[i] = a[i];
    }
}

/* --
   given data[length] and return res[num]
   which includes indexs of sort results by largeness.
   -- */
int *sortLarge(data, length, num)
double *data;
int length; 
int num;
{
    int *res;
    int i, j, ans, *flag;

    res = (int *)malloc(sizeof(double)*num);
    flag = (int *)calloc(length, sizeof(int));

    for(i = 0; i < num; i++){
	for(ans = 0; ans < length; ans++){
	    if(0 == *(flag+ans)) break;
	}
	for(j = ans; j < length; j++){
	    if(0 != *(flag+j)) continue;
	    if(*(data+ans) < *(data+j)){
		ans = j;
	    }
	}
	*(res+i) = ans;
	*(flag+ans) = 1;
    }
    return res;
}

rangeLimit(a,min,max)
double *a, min, max;
{
    if (*a > max) *a=max;
    else if (*a < min) *a=min;
    else;
}

sortLargeNew(data, length, num, res)
double *data;
int length; 
int num;
int *res;
{
    int i, j, ans, *flag;

    flag = (int *)calloc(length, sizeof(int));

    for(i = 0; i < num; i++){
	for(ans = 0; ans < length; ans++){
	    if(0 == *(flag+ans)) break;
	}
	for(j = ans; j < length; j++){
	    if(0 != *(flag+j)) continue;
	    if (j>length-1) fprintf(stderr,"sortE0 ");
	    if (ans>length-1) fprintf(stderr,"sortE1 ");
	    if(*(data+ans) < *(data+j)){
		ans = j;
	    }
	}
	if (i>num-1) fprintf(stderr,"sortE2 ");
	*(res+i) = ans;
	if (ans>length-1) fprintf(stderr,"sortE3 ");
	*(flag+ans) = 1;
    }
    free(flag);
}


int FindLargest(data,n)
double *data;
int n;
{
    int i,max_i;
    double max= -100000000000.0;
    for (i=0; i<n; ++i) {
	if (data[i]>max) {
	    max_i = i;
	    max = data[i];}
    }
    return(max_i);
}

int FindSmallest(data,n)
double *data;
int n;
{
    int i,min_i;
    double min= +100000000000.0;
    for (i=0; i<n; ++i) {
	if (data[i]<min) {
	    min_i = i;
	    min = data[i];}
    }
    return(min_i);
}

unitVector(in,out,leng,N)
double *in, *out, *leng;
int N;
{
    int i;
    double sum=0.0;
    for (i=0; i<N; ++i) {
	sum+=in[i]*in[i];
    }
    
    if (sum==0.0) sum=1.0;
    *leng = sqrt(sum);
    for (i=0; i<N; ++i) {
	out[i] = in[i]/(*leng);
    }
}

/* --
   return unit variance gaus distribution deviation of means as 0.0
   -- */
double gasdec()
{
    int iset=0;
    double gset;
    double fac,rsq,v1,v2;

    if (iset==0) {
	do {
	    v1 = SetRandom(1.0);
	    v2 = SetRandom(1.0);
	    rsq = v1*v1+v2*v2;
	} while (rsq >= 1.0 || rsq==0.0);
	fac = sqrt(-2.0*log(rsq)/rsq);
	gset = v1*fac;
	iset = 1;
	return v2*fac;
    }
    else {
	iset = 0;
	return gset;
    }
}

/* --------------------------------------
   random number: return  -range to range
   -------------------------------------- */
double SetRandom(range)
      double range;
{
      return (((double)rand() / RAND_MAX * 2.0 - 1.0) * range);
}

/* --
   randomly select n numbers from 0 to less than m,
   and put into out[n]
   -- */
selectN(n,m,out)
int n, m, *out;
{
    int i, j, num=0;
    int *st;
    st = (int *)calloc(m,sizeof(int));
    while (num<n) {
	i = shuffle(m);
	if (st[i]==0) {
	    out[num] = i;
	    st[i]=1; /* occupied */ 
	    ++num;}
    }
    free(st);
}

/* --
   chose a number from 0 to less than n.
   -- */
int shuffle(n)
int n;
{
    return (int)(fabs(SetRandom(1.0)*n));
}

/* --
   data of "a" with DIM dimension with maxSteps are filtered in temporal direction
   with fSize filter
   -- */
filterTmpoArray(a,DIM,maxSteps,fSize)
     double *a;
     int DIM, maxSteps, fSize;
{
    double *b;
    int step,i,sStepF,eStepF,stepF;
    b = (double *)calloc(DIM*maxSteps,sizeof(double));    
    for (step=0; step<maxSteps; ++step) {
	sStepF = step-fSize+1;
	eStepF = step;
	if (sStepF<0) sStepF=0;
	for (i=0; i<DIM; ++i) {
	    double sum=0.0;
	    for (stepF=sStepF; stepF<=eStepF; ++stepF) {
		sum += a[stepF*DIM+i]; }
	    b[DIM*step+i] = sum/(eStepF-sStepF+1); }
    }
    for (i=0; i<maxSteps*DIM; ++i) {
	a[i] = b[i];
    }
    free(b);
}

/* --------------------------
   --------------------------
   Geometric Compt
   -------------------------
   ------------------------- */

/* --
   Caluc norm distance from point(x,y) to line (x1,y1,x2,y2) into
   &distance. &xc, &yc containes the cross position.
   -- */
normDistancePointToLine(x1,y1,x2,y2,x,y,xc,yc,distance)
     double x1, y1, x2, y2, x, y, *xc, *yc, *distance;     
{ 
  double a1, b1, a2, b2, a1_inv, a_diff;

  if (x2!=x1)  /* Not vertical line of #2*/
    { 
      fprintf(stderr,"\nx2 %f x1 %f ",x2,x1);
      a2 = (y2 - y1)/ (x2 - x1) ;
      if (fabs(a2)<0.0001) {
	  a2 = 0.0001;	  
      }
      b2 = y2 - a2*x2;
      a1 = -1.0/a2;      
      b1 = y - a1*x;	
      a_diff = a1 - a2;
      fprintf(stderr,"\na_diff %f a1 %f a2 %f ",a_diff,a1,a2);
      if (a_diff < 0.0001 && a_diff >= 0.0)
	a_diff = 0.0001;
      else if (a_diff < 0.0 && a_diff > -0.0001)
	a_diff = -0.0001;
      else ; 
      *xc = (b2-b1)/a_diff;         /* find cross point */
      *yc = a1*(*xc) + b1;  }
  else         /* Vertical of #2 line */
    { *xc = x2;
      *yc = a1*(*xc)+b1;}
  
  /* not cross */
  if (((x1 - *xc)*(x2 - *xc) >= 0.0)&&((y1 - *yc)*(y2 - *yc) >= 0.0)) {
      *distance = -1;      
  }
  else {
      *distance = sqrt((*xc-x)*(*xc-x)+(*yc-y)*(*yc-y));  
  }
}
