/* --
   02/9/05
   in[2] = in[0]*in[1] for Hirata no context units
   Open loop learning.
   99/11/14
   1. inputRation control using TssExp.
      For not use TssExp control, Fact() is modified for inputRatio.
   2. TrainMode is either MAP or DIFF (outTch as delivertive)
   3. Plot by sqS
   -- */


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "rnn99.h"
#include "winLib.h"
#include "taniLib.h"

#define DEBUG 1
#define MAX_SEQ_LENGTH 1000
#define TRAIN 0
#define ACT 0
#define TssPlotMax 0.02

struct NET *Net;
char Pfilename[128];
char DataDir[256];
FILE *fileptr, *sFileptr, *wFileptr;
struct SequenceRecord Gseq[100];

/* may not be used */
double *pointOutput();
double *pointOutputTeach(), *pointInputTeach(), *pointContIn();
double AbsWeight(), ReadFT_sub();
char Title[256];
double ParaIn[2];
int sqS=5;
double tss0=0.001;


/* --
   Init Mix for Leer and higher levels respectively.
   -- */
InitNet()
{
  char string[256];
  int step,iseq;
  pscale=1.0; /* pattern teaching amplitude scale for ReadPattern() */
  momentum=0.9; epsi = 0.005; RandRange = 0.5; 
  errorDecayRate = 0.9;

  ms=0.1; ms1=5.0, mp=0.05; mr=100.0; mr1=1.0; mn0=0.34; mnk=1.0;
  epsiM=0.1; momentumM=0.9; Tplan=0.05;
  decayR = 0.9;
  nepochs = 30; showtime = 100; epoch=0;
  EFlag0=0; EFlag1=0;

  // InitX(10,10,400,800,"plot net"); 
  // SetDisplay(NET_X);
  InitX(300,10,500,500,"TestGene"); 
  SetDisplay(TG);
  InitX(300,310,900,300,"Out"); 
  SetDisplay(OUT_X);

  Net = (struct NET *)calloc(1,sizeof(struct NET));
  Net->SenseNS = SenseNG;
  Net->ActNS = ActNG;
  Net->FS_NS = FS_NG;
  Net->HiddenNS = HiddenNG;
  Net->ContNS = ContNG;
  Net->InNS = DataDimG;
  Net->OutNS = DataDimG;
  AllocRnn(Net);			
  Net->MaxTrainSeqS = 40;
  MaxTrainSeq = Net->MaxTrainSeqS;
  Net->trainSeqS = (struct SequenceRecord *)calloc(MaxTrainSeq,
												   sizeof(struct SequenceRecord));
  TrainSeq = Net->trainSeqS;
  fprintf(stderr,"TrainSeq+0 %d TrainSeq+1 %d ",TrainSeq,TrainSeq+1);
  InputDefort = (double *)calloc(InN,sizeof(double));
}

Train()
{
  int startStep, endStep, iseq, showtime=100 ,i,step;    
  struct SequenceRecord *seq;
  FILE *filestr;
  char dir[64], filename[128], str[128];

  printf("\nnepochs? ");
  scanf("%d",&nepochs);
  setNetGlobal(Net);    

  for (TimeL=0; TimeL<nepochs; ++TimeL) {
	Net->errorS = 0.0;
	for (iseq=0; iseq<MaxTrainSeq; ++iseq) {
	  int sstep, estep;
	  seq = Net->trainSeqS+iseq;
	  estep = seq->steps;
	  sstep = 0;

	  // epsi = epsi0/(pow(1.5,(TimeL*8.0/nepochs)));
	  epsi = epsi0;
	  inputRatio = inputRatioK;
	  /*
	  inputRatio = 1.0/(pow(1.5,(TimeL*8.0/nepochs)));
	  if (TimeL == nepochs-1) inputRatio = 0.0;
	  */

	  ClosedMultipleFact(Net,seq,sstep,estep,Train);
	  ClosedMultipleBP(Net,seq,sstep,estep,sstep,estep); 

	  //fprintf(stderr,"\nsstep%d estep%d ",sstep,estep);
	  updateInitCont(seq,0); /* update ContIn at sstep+1 */
	  updateFS(seq); /* update PB vector for each seq */
	  if (TimeL%100==0) {
		plotOutTch(seq,sstep,estep,iseq);
	  }
	}
	UpdateWeightBias(wRange);	
	if (TimeL%showtime==0) {
	  fprintf(stderr,"\ntime=%d tss %f inputRatio%f epsi%f \niniCiU\n PB ",
			  TimeL,(Net->errorS)/(AllTrainSteps*OutN),inputRatio,epsi);
	  for (iseq=0; iseq<MaxTrainSeq; ++iseq) {
		seq = Net->trainSeqS+iseq;
		fprintf(stderr,"PB[seq%d} ",iseq);
		for (i=0; i<FS_N; ++i) fprintf(stderr,"%5.2f ",*(seq->Para+i));
	  }
	}
  }
}


Gene()
{
  int step,i,j,iseq=0;
  int hoge=1;

  while(hoge) {
	testGene(iseq);
	fprintf(stderr,"\ncontinue:1 ");
	scanf("%d",&hoge);
	++iseq;
  }
  MaxTrainSeq = iseq;
  SaveData();
}

Robo()
{
  int step,i,j,iseq=0;
  int hoge=1;

  while(hoge) {
	RobotGene(iseq);
	fprintf(stderr,"\ncontinue:1 ");
	scanf("%d",&hoge);
	++iseq;
  }
  MaxTrainSeq = iseq;
  SaveData();
  SaveTchPattern();
}

SaveTchPattern()
{
  int i,j,step,iseq;
  FILE *filestr;
  char filename[256];
  struct SequenceRecord *seq;

  sprintf(filename, "data/%s/%s.pat",DataDir,DataDir);
  filestr = fopen(filename, "w");
  fprintf(filestr,"%d %d\n",InN,OutN);

  for (iseq=0;iseq<MaxTrainSeq;++iseq) {
	seq = TrainSeq+iseq;
	for (step=0; step<seq->steps-1; ++step) {
	  fprintf(filestr,"\n%d ",step);
	  for (i=0;i<InN;++i) 
		fprintf(filestr,"%f ",*(seq->InputTeach+InN*step+i));
	  for (i=0;i<InN;++i) 
		fprintf(filestr,"%f ",*(seq->InputTeach+InN*(step+1)+i));
	}
	fprintf(filestr,"\n%d\n",-(iseq+1));
  }
  fclose(filestr);
}




plotTrajInCont(seq,sstep,estep,iseq)
	 struct SequenceRecord *seq;
	 int sstep,estep,iseq;
{
  int step,i,j;
  for (step=sstep; step < estep - 1; ++step) {
	int x0,y0,x1,y1;
	x0 = *(seq->Input+InN*step)*200+50;
	y0 = *(seq->ContIn+ContN*step)*200+50;
	x1 = *(seq->Input+InN*(step+1))*200+50;
	y1 = *(seq->ContIn+ContN*(step+1))*200+50;
	plotLineColor(x0,y0,x1,y1,iseq);
	//plotPointColor(x0,y0,iseq);
	fprintf(stderr,"\n%f %f ",*(seq->Input+InN*step),*(seq->ContIn+ContN*step));
  }
  XFlush(disp);
}

/* --
   Closed-loop sequence generation with given initial input and PB vector
   -- */

testGene(iseq)
	 int iseq;
{
  int i,j,step;
  int scale=100,tsteps;

  fprintf(stderr,"\nTestMaxSteps? (should be less than 1000!!) ");
  scanf("%d",&TestMaxSteps);
  AllocSequence(TrainSeq,TestMaxSteps,iseq,Net);
  fprintf(stderr,"\n alloc seq[%d] ",iseq);
  SwitchDisplay(TG);	
  XFillBlank(TG);
  fprintf(stderr,"\nbug0 ");
  /* set initial condition of seq to be generated */
  for (i=0; i<ContN; ++i) 
	*((TrainSeq+iseq)->ContIn+i) = 0.5;
  fprintf(stderr,"\nbug1 ");
  fprintf(stderr,"\n input initial input vector of %d dimension \n",InN);
  for (i=0; i<InN; ++i)
	scanf("%lf",((TrainSeq+iseq)->InputTeach+i));

  /* set PB vector which is constant for a seq */
  fprintf(stderr,"\n input the PB vector of %d dimension \n",FS_N);
  for (i=0; i<FS_N; ++i)
	scanf("%lf",((TrainSeq+iseq)->Para+i));
  for (step=1;step<TestMaxSteps;++step) {
	for (i=0; i<FS_N; ++i) {
	  *((TrainSeq+iseq)->Para+step*FS_N+i) = 
		*((TrainSeq+iseq)->Para+(step-1)*FS_N+i);
	}
  }

  inputRatio = 0.0; /* closed-loop generation: the current input is feedback
					   from the previous prediction in the output */

  ClosedMultipleFact(Net,TrainSeq+iseq,0,TestMaxSteps,TestGene);
  for (step=0; step<TestMaxSteps; ++step) {
	if (InN>1) {
	  plotPoint((int)(scale**((TrainSeq+iseq)->Input+InN*step+0))+30,
				(int)(scale**((TrainSeq+iseq)->Input+InN*step+1))+30);}
	if (ContN>1) {
	  plotPoint((int)(scale**((TrainSeq+iseq)->ContIn+ContN*step+0))+60+scale,
			  (int)(scale**((TrainSeq+iseq)->ContIn+ContN*step+1))+30);
	}
  }
  plotOut(TrainSeq+iseq,0,TestMaxSteps/2);
  plotIn(TrainSeq+iseq,0,TestMaxSteps/2);
  XFlushDisp();
}

/* --
   Sequence is generated with the robot by open-loop mode
   -- */
RobotGene(iseq)
	 int iseq;
{
  int i,j,step;
  int scale=100,tsteps;

  fprintf(stderr,"\nTestMaxSteps? (should be less than 1000!!) ");
  scanf("%d",&TestMaxSteps);
  AllocSequence(TrainSeq,TestMaxSteps,iseq,Net);
  SwitchDisplay(TG);	
  XFillBlank(TG);
  
  /* set initial condition of seq to be generated */
  for (i=0; i<ContN; ++i) 
	*((TrainSeq+iseq)->ContIn+i) = 0.5;

  /* Input PB vector which is constant for a seq */
  fprintf(stderr,"\n Input the PB vector of %d dimension \n",FS_N);
  for (i=0; i<FS_N; ++i)
	scanf("%lf",((TrainSeq+iseq)->Para+i));
  for (step=1;step<TestMaxSteps;++step) {
	for (i=0; i<FS_N; ++i) {
	  *((TrainSeq+iseq)->Para+step*FS_N+i) = *((TrainSeq+iseq)->Para+(step-1)*FS_N+i);
	}
  }

  inputRatio = 1.0; /* closed-loop generation */

  ClosedMultipleFact(Net,(TrainSeq+iseq),0,TestMaxSteps,RoboGene);
  for (step=0; step<TestMaxSteps; ++step) {
	if (InN>1) {
	  plotPoint((int)(scale**((TrainSeq+iseq)->Input+InN*step+0))+30,
				(int)(scale**((TrainSeq+iseq)->Input+InN*step+1))+30);}
	if (ContN>1) {
	  plotPoint((int)(scale**((TrainSeq+iseq)->ContIn+ContN*step+0))+60+scale,
			  (int)(scale**((TrainSeq+iseq)->ContIn+ContN*step+1))+30);
	}
  }
  plotOut((TrainSeq+iseq),0,TestMaxSteps/2);
  plotIn((TrainSeq+iseq),0,TestMaxSteps/2);
  XFlushDisp();
}

plotPhase(seq,maxSteps)
	 struct SequenceRecord *seq;
	 int maxSteps;
{
  int i,j,step;
  int scale=100;

  SwitchDisplay(TG);	
  XFillBlank(TG);

  for (step=0; step<maxSteps; ++step) {
	if (InN>1) {
	  plotPoint((int)(scale**(seq->Input+InN*step+0))+30,
				(int)(scale**(seq->Input+InN*step+1))+30);}
	if (ContN>0) {
	  plotPoint((int)(scale**(seq->Input+InN*step+0))+60+scale,
				(int)(scale**(seq->ContIn+ContN*step+0))+30);}
  }
  XFlushDisp();
}


copyState(seqA, seqB, stepA, stepB)
	 struct SequenceRecord *seqA, *seqB;
	 int stepA, stepB;
{
  int i;
  for (i=0; i<ContN; ++i) {
	*(seqB->ContIn+stepB*ContN+i) = *(seqA->ContIn+stepA*ContN+i);}
  for (i=0; i<InN; ++i) {
	*(seqB->Input+stepB*InN+i) = *(seqA->Input+stepA*InN+i);}
  for (i=0; i<InN; ++i) {
	*(seqB->InputTeach+stepB*InN+i) = *(seqA->Input+stepA*InN+i);}
}


plotOutTch(seq,sstep,estep,iseq)
	 struct SequenceRecord *seq;
	 int sstep,estep,iseq;
{
  int step,i,ir,ig,height;
  char string[256];
  double out[10000],outTch[10000];
  // fprintf(stderr,"sstep%d estep%d ",sstep,estep);
  for (step=sstep; step<estep; ++step) {
	out[(OutN+1)*(step-sstep)] = step*1.0;
	outTch[(OutN+1)*(step-sstep)] = step*1.0;
	for (i=0; i<OutN; ++i) {
	  out[(OutN+1)*(step-sstep)+i+1] = *(seq->Output+OutN*step+i);
	  // fprintf(stderr,"%f ",out[(OutN+1)*step+i+1]);
	  outTch[(OutN+1)*(step-sstep)+i+1] = *(seq->OutputTeach+OutN*step+i);
	}
  }
  SwitchDisplay(OUT_X);	
  if (iseq==0) XFillBlank(OUT_X);  
  if (FS_N==0)
	sprintf(string,"No PB");
  if (FS_N==1)
	sprintf(string,"(%5.2f) ",*(seq->Para));
  if (FS_N==2)
	sprintf(string,"(%5.2f, %5.2f)",*(seq->Para),*(seq->Para+1));
  if (FS_N>=3)
	sprintf(string,"(%5.2f, %5.2f, %5.2f)",*(seq->Para),*(seq->Para+1),*(seq->Para+2));
  ir = iseq % 10;
  ig = iseq / 10;
  height = 25*3+sqS*30;
  PlotOresenGraf(outTch,OutN+1,estep-sstep,1.0,0.0,sqS*(estep-sstep),sqS*10,25+sqS*30*ir,25+height*ig,10,"outTch",0);
  PlotOresenGraf(out,OutN+1,estep-sstep,1.0,0.0,sqS*(estep-sstep),sqS*10,25+sqS*30*ir,25*2+sqS*10+height*ig,10,"out",0);
  drawString(25+sqS*30*ir,25*3+sqS*30+height*ig,string);
  XFlushDisp();
}

plotOut(seq,sstep,estep)
	 struct SequenceRecord *seq;
	 int sstep,estep;
{
  int step,i;
  double out[10000];
  // fprintf(stderr,"sstep%d estep%d ",sstep,estep);
  for (step=sstep; step<estep; ++step) {
	out[(OutN+1)*(step-sstep)] = step*1.0;
	for (i=0; i<OutN; ++i) {
	  out[(OutN+1)*(step-sstep)+i+1] = *(seq->Output+OutN*step+i);
	}
  }

  PlotOresenGraf(out,OutN+1,estep-sstep,1.0,0.0,sqS*(estep-sstep),sqS*10,25,100+25*2,10,
				 "out",0);
}

plotIn(seq,sstep,estep)
	 struct SequenceRecord *seq;
	 int sstep,estep;
{
  int step,i;
  double in[10000];
  // fprintf(stderr,"sstep%d estep%d ",sstep,estep);
  for (step=sstep; step<estep; ++step) {
	in[(InN+1)*(step-sstep)] = step*1.0;
	for (i=0; i<InN; ++i) {
	  in[(InN+1)*(step-sstep)+i+1] = *(seq->Input+InN*step+i);
	}
  }

  PlotOresenGraf(in,InN+1,estep-sstep,1.0,0.0,sqS*(estep-sstep),sqS*10,25,100+sqS*10+25*3,10,
				 "in",0);
}

SaveData()
{
  FILE *filestr;
  char *dir, filename[128], str[128];
  int iseq;

  dir = DataDir;
  /* save data for training seqs */
  fprintf(stderr,"\ndirectory ? => ");
  scanf("%s",dir);
  strcpy(Title,dir);
  sprintf(str,"mkdir data/%s",dir);
  fprintf(stderr,"\n%s ",str);
  system(str);
  for (iseq=0; iseq<MaxTrainSeq; ++iseq) {
	sprintf(filename, "data/%s/l%d%s.seq", dir, iseq, dir);
	filestr = fopen(filename, "w");
	SaveSeqFS(Net->trainSeqS+iseq, filestr);
	fclose(filestr); 
  }
  sprintf(filename,"data/%s/%s.wt",dir,dir);
  filestr = fopen(filename,"w");
  SaveWeight(filestr, Net);
  fclose(filestr);
  filestr = fopen("tmp/tmp.wt","w");
  SaveWeight(filestr, Net);
  fclose(filestr);

  sprintf(str,"cp tmp/train.ft data/%s/%s.ft",dir,dir);
  system(str);

  sprintf(str,"cp tmp/train.pat data/%s/%s.pat",dir,dir);
  system(str);

  sprintf(str,"cp rnn99.h data/%s/.",dir);
  system(str);
}


/* --
   save trainSeq (could be multiple seq) / actSeq (one seq)
   -- */
SaveSeqFS(seq, filestr)	 
	 struct SequenceRecord *seq;
	 FILE *filestr;
{
  int epoch, inet,i, j, step, maxNets, maxOut, maxIn, maxCont;
  int maxOutL, maxInL, maxContL, flag = 1, MaxSeq, maxSteps;
  maxSteps = seq->steps;    

  fprintf(filestr,"step ");
  for (j=0; j<OutN; ++j)
	fprintf(filestr,"outTch%d ",j);
  for (j=0; j<OutN; ++j)
	fprintf(filestr,"out%d ",j);
  for (j=0; j<InN; ++j)
	fprintf(filestr,"in%d ",j);
  for (j=0; j<InN; ++j)
	fprintf(filestr,"inAve%d ",j);
  for (j=0; j<ContN; ++j)
	fprintf(filestr,"ci%d ",j);
  for (j=0; j<ContN; ++j)
	fprintf(filestr,"ciAve%d ",j);
  for (j=0; j<OutN; ++j)
	fprintf(filestr,"outEr%d ",j);
  for (j=0; j<ContN; ++j)
	fprintf(filestr,"coD%d ",j);
  for (j=0; j<ContN; ++j)
	fprintf(filestr,"ciE%d ",j);
  fprintf(filestr,"\n");

  for(step=0; step<maxSteps; ++step) {
	fprintf(filestr,"%d ",step);	
	for (i=0;i<OutN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->OutputTeach+OutN*step+i));}
	for (i=0;i<OutN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->Output+OutN*step+i));}
	for (i=0;i<InN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->Input+InN*step+i));}
	for (i=0;i<InN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->InputAve+InN*step+i));}
	for (i=0;i<ContN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->ContIn+ContN*step+i));}
	for (i=0;i<ContN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->ContInAve+ContN*step+i));}
	for (i=0;i<OutN;++i) {
	  fprintf(filestr,"%5.3f ",*(seq->OutEr+OutN*step+i));}
	for (i=0;i<ContN;++i) {
	  fprintf(filestr,"%f ",*(seq->ContOutDel+ContN*step+i));}
	for (i=0;i<ContN;++i) {
	  fprintf(filestr,"%f ",*(seq->ContInEr+ContN*step+i));}
	fprintf(filestr,"\n");	
  }    
}

ReadTmpPD()
{
  int iseq,i,step;
  FILE *fileptr;
  fileptr = fopen("tmp/train.pat","r");

  ReadPattern(fileptr,Net);			    
  fclose(fileptr);
  for (iseq=0; iseq<MaxTrainSeq; ++iseq) {
	difOutTch(TrainSeq+iseq,DSCALE);
	/*
	for (step=0; step<(TrainSeq+iseq)->steps; ++step) {
	  fprintf(stderr,"\n%d ",step);
	  for (i=0;i<OutN;++i) {
		fprintf(stderr,"%5.2f ",*((TrainSeq+iseq)->OutputTeach+OutN*step+i));
	  }
	}
	*/
  }
  TrainMode = DIFF;
}

/* The last OutputTeach is fed with time averaged values of inputs */
smoothLastOutTch(winL)
	 int winL;
{
  int iseq,i,step,maxSteps;
  double data0[10000],data1[10000];

  for (iseq=0; iseq<MaxTrainSeq; ++iseq) {
	struct SequenceRecord *seq;
	seq = TrainSeq+iseq;
	maxSteps = seq->steps;
	for (step=0; step<maxSteps; ++step) {
	  data0[step]=0.0;
	  for (i=0; i<InN; ++i) {
		data0[step] += *(seq->InputTeach+InN*step+i); }
	  data0[step] = data0[step]/InN;
	}
	for (step=0; step<maxSteps; ++step) {
	  double ans[1];
	  aveSequence(data0,ans,1,step,winL);
	  *(seq->OutputTeach+OutN*step+OutN-1) = *ans;
	}

  }
}

/* --
   Read and save Hirata Training pattern
   -- */
readHirata() {
  FILE *rfile,*sfile;
  char filename[256];
  int i,j,iseq= -1;
  double val[100];
  int maxSeqs,step,maxSteps=8;
  int ct;

  fprintf(stderr,"\nfilename to read? ");
  scanf("%s",filename);
  rfile = fopen(filename,"r");
  sfile = fopen("tmp/test.pat","w");

  fprintf(sfile,"1 1 ");
  while (fscanf(rfile, "%d", &ct) != EOF) {
	for (step=0; step<maxSteps; ++step) fscanf(rfile,"%lf",val+step); 
	for (step=1; step<maxSteps; ++step) {
	  fprintf(sfile,"\n%d %f %f ",step,val[step-1],val[step]);}
	fprintf(sfile,"\n%d\n",iseq);
	iseq -= 1;
  }
  fclose(rfile); fclose(sfile);
}
	  
/* --------------------------------------------------------------------------------
   Main
   -------------------------------------------------------------------------------- */
main(int argc, char **argv)
{
  char word[20],filename[64];
  FILE *fileptr, *sFileptr, *wFileptr;
  int i,j,step,i_net;
  double energyHist[50000],pData[50000], hoge; /* for plot */
  int histStep = 0;
  int plth=0;

  /*
    pvm_init(argc, argv);
  */
  srand(time(&now));         /* seed for rand() */
  printf(" /* ------------------------------------------ \n");
  printf("      The open loop learnig of RNN 2002 summer\n");
  printf("                Jun Tani a \n");
  printf("    ------------------------------------------ */\n");

  InitNet(); /* parameter set */
  setNetGlobal(Net);    
  TrainMode = MAP;

  /* trainSeq is allocated for 100 seqs as default */
  MaxTrainSeq = 100; 
  Net->trainSeqS = (struct SequenceRecord *)calloc(MaxTrainSeq,
												   sizeof(struct SequenceRecord));
  TrainSeq = Net->trainSeqS;

  printf("\n train gene robo \n");
  scanf("%s",word);
  while (strcmp(word,"quit") != 0)
	{
	  
	  if (strcmp(word,"rand") == 0) {
		RandomWeight(1.0,Net);		
		InitCont(Net); }
	  if (strcmp(word,"train") == 0) {
		ReadFT("tmp/train.ft");		/* read param file */
		TrainMode=MAP;
		fileptr = fopen("tmp/train.pat","r"); /* read train pattern seqs */
		ReadPattern(fileptr,Net); 
		fclose(fileptr);

		/* The last OutputTeach is fed with time averaged values of inputs */
		//smoothLastOutTch(SmoothLength);

		printf("\nLeNet: InN%d OutN%d maxSteps%d ",InN,OutN,Net->trainSeqS->steps);
		RandomWeight2(0.2,2.0,Net);	/* initialize weights as random */

		{ /* if read the previously generated weights */
		  int hoge;
		  FILE *fileptr;
		  printf("\nReadWeight? 1,0 ");
		  scanf("%d",&hoge);
		  if (hoge) {
			fileptr = fopen("tmp/tmp.wt","r");
			ReadWeight(fileptr,Net);
			fclose(fileptr);
		  }
		}

		InitCont(Net); /* set init context activation as neutral (0.5) */

		Train();
		SaveData(); }
	  if (strcmp(word,"gene") == 0) {
		char dir[256];
		int opFlag;
		FILE *fileptr;
		ReadFT("tmp/train.ft");
		TrainMode=MAP;
		fprintf(stderr,"\ndirectory to read weights ? => ");
		scanf("%s",dir);
		sprintf(filename,"data/%s/%s.wt",dir,dir);
		fileptr = fopen(filename,"r");
		ReadWeight(fileptr,Net);
		fclose(fileptr);
		fprintf(stderr,"\n Read weight from %s ",filename);
		InitX(10,10,300,300,"gene"); 
		SetDisplay(GENE_X);
		Gene();
	  }
	  if (strcmp(word,"robo") == 0) {
		char dir[256];
		int opFlag;
		FILE *fileptr;
		ReadFT("tmp/train.ft");
		TrainMode=MAP;
		fprintf(stderr,"\ndirectory to read weights ? => ");
		scanf("%s",dir);
		sprintf(filename,"data/%s/%s.wt",dir,dir);
		fileptr = fopen(filename,"r");
		ReadWeight(fileptr,Net);
		fclose(fileptr);
		fprintf(stderr,"\n Read weight from %s ",filename);
		InitX(10,10,300,300,"gene"); 
		SetDisplay(GENE_X);
		Robo();
	  }
	  printf("\n train gene robo \n");
	  scanf("%s",word);
	}
}


double ReadFT_sub(fp)
     FILE *fp;
{
  static char buf[256];
  char *ptr;

  ptr = buf;

  if (fgets(buf, 255, fp) == (char *)NULL) {
    fprintf(stderr, "No more data in the file\n");
    exit(-1);
  }
  while ((*ptr == ' ') || (*ptr == '\t'))
    ptr++;
  while ((*ptr != ' ') && (*ptr != '\t'))
    ptr++;
  while ((*ptr == ' ') || (*ptr == '\t'))
    ptr++;
  return atof(ptr);
}

int
ReadFT(filename) 
     char *filename;     
{
  FILE *fp;

  if ((fp = fopen(filename, "r")) == (FILE *)NULL) {
    perror("get_param");
    exit(-1);
  }
  
  epsi0 = ReadFT_sub(fp);
  momentum = ReadFT_sub(fp);
  epsi_fs = ReadFT_sub(fp);
  momentum_fs = ReadFT_sub(fp);
  epsi_plan = ReadFT_sub(fp);
  momentum_plan = ReadFT_sub(fp);
  epsi_u = ReadFT_sub(fp);
  wRange = ReadFT_sub(fp);
  inputRatioK = ReadFT_sub(fp);
  fs_R = ReadFT_sub(fp);
  MaxFSdelta = ReadFT_sub(fp); /* max FS change rate */
  tss0 = ReadFT_sub(fp); /* max FS change rate */
  epsiCont = ReadFT_sub(fp);
  noiseRate = ReadFT_sub(fp);
  decay = ReadFT_sub(fp);

  fclose(fp);
}

