/* ---------------------------
   Two layerd 99/4/25
   Para nodes in input layer 99/1
   Reinforcement Learn 98/12
   Module RNNs.
   --------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "rnn99.h"
#include "taniLib.h"

int transBitsInv();

/* --
   setNetGlobal()/
   local to Global
   -- */

setNetGlobal(net)
     struct NET *net;
{
  MaxTrainSeq = net->MaxTrainSeqS;
  InType = net->InTypeS;
  InN = net->InNS;
  ContN = net->ContNS;
  HiddenN = net->HiddenNS;
  OutN = net->OutNS;
  SenseN = net->SenseNS;
  ActN = net->ActNS;
  FS_N = net->FS_NS;

  w21 = net->w21S;
  w32 = net->w32S;
  fs32 = net->fs32S;
  b3 = net->b3S;
  b2 = net->b2S;

  dw21 = net->dw21S;
  dw32 = net->dw32S;
  db3 = net->db3S;
  db2 = net->db2S;

  dlw21 = net->dlw21S;
  dlw32 = net->dlw32S;
  dlb3 = net->dlb3S;
  dlb2 = net->dlb2S;

  Error = net->errorS;
  TrainSeq = net->trainSeqS;
  ActSeq = net->actSeqS;
}

/* --
   setNetLocal()/
   Global to local 
   -- */
setNetLocal(net)
	 struct NET *net;
{
  net->MaxTrainSeqS = MaxTrainSeq;
  net->InTypeS = InType;
  net->InNS = InN;
  net->ContNS = ContN;
  net->HiddenNS = HiddenN;
  net->OutNS = OutN;
  net->SenseNS = SenseN;
  net->ActNS = ActN;
  net->FS_NS = FS_N;

  net->w21S = w21;
  net->w32S = w32;
  net->fs32S = fs32;
  net->b3S = b3;
  net->b2S = b2;

  net->dw21S = dw21;
  net->dw32S = dw32;
  net->db3S = db3;
  net->db2S = db2;

  net->dlw21S = dlw21;
  net->dlw32S = dlw32;
  net->dlb3S = dlb3;
  net->dlb2S = dlb2;

  net->errorS = Error;
  net->trainSeqS = TrainSeq;
  net->trainSeqS = ActSeq;
}

/* ---------------------------------------------------------------------------------
   SingleBp with fs nodes in the input layer.
   if (wFlag) weight modification.
   if (fsFlag) fs modification.
   One cycle of BP for a three-layerd net.
   delayedReward is used for training action output units.
   Return tss (square error sum for each step)
   --------------------------------------------------------------------------------- */
double SingleBp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,outE,coE,
				outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)
     double *in,*ci,*hid,*out,*co,*inD,*ciD,*hidD,*outD,*coD,
  *inE,*ciE,*hidE,*outE,*coE,*outTeach;
     int step;
     double *gate, *dr, *para, *paraD, *paraE;
     int wFlag, fsFlag; /* flag for weight/FS modification */
{
  int i,j;
  double *weight, *dw, *db, hid_sum=0.0, error=0.0;
 
  /* Initialize error as 0.0 for each node */   
  error = 0.0;
  for (i=0; i<InN; ++i)
	*(inE+i) = 0.0;
  for (i=0; i<FS_N; ++i)
	*(paraE+i) = 0.0;
  for (i=0; i<ContN; ++i)
	{
	  *(ciE+i) = 0.0;
	  *(coE+i) = 0.0;      }

  for (i=0; i<HiddenN; ++i)
	*(hidE+i) = 0.0;

  for (i=0; i<OutN; ++i)
	*(outE+i) = 0.0;
    
  /* Back prop context out to hidden layer */
  weight = w32 + HiddenN*(ContN+OutN); /* point the end of w32 */    
  dw = dw32 + HiddenN*(ContN+OutN);
  db = db3 + OutN + ContN;
    
  /*E printf("--   BP     --\n");*/
  /* delta for context out has been computed in coD */
  for (i=ContN-1; i>=0; --i)
	{
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;		
		  /* gating also for context BP */
		  *(hidE+j) += *(coD+i) * (*weight);
		  if (wFlag) *dw += *(coD+i) * (*(hid+j));
	    }
	  --db;	  
	  if (wFlag) *db += *(coD+i);	  
	  /*E printf("%lf\n",*(coD+i));*/
	}
  /* Back prop from output to hidden layer */
  for (i=OutN-1; i>=0; --i)
	{
	  *(outE+i) = (*(outTeach+i) - *(out+i));
	  error += (*(outE+i)) * (*(outE+i));
	  *(outD+i) = *(outE+i) * (*(out+i)) * (1.0 - *(out+i)); 
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;
		  *(hidE+j) += *(outD+i) * (*weight); 
		  *dw += *(outD+i) * (*(hid+j));
	    }	  
	  --db;	  
	  *db += *(outD+i);	  
	}
  /* Back prop from hidden to input layer */
  weight = w21 + HiddenN*(ContN+FS_N+InN); /* point the end of w32 */    
  dw = dw21 + HiddenN*(ContN+FS_N+InN);
  db = db2 + HiddenN;

  for (i=HiddenN-1; i>=0; --i)
	{
	  *(hidD+i) = *(hidE+i) * (*(hid+i)) * (1.0 - *(hid+i));
	  for (j=ContN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(ciE+j) += *(hidD+i) * (*weight);
		  if (wFlag) *dw += *(hidD+i) * (*(ci+j));
	    }
	  for (j=FS_N-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(paraE+j) += *(hidD+i) * (*weight);
		  if (wFlag) *dw += *(hidD+i) * (*(para+j));
	    }
	  for (j=InN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(inE+j) += *(hidD+i) * (*weight);
		  if (wFlag) *dw += *(hidD+i) * (*(in+j));
	    }
	  --db;	  
	  if (wFlag) *db += *(hidD+i);	  
	}
  /* delta computation for input layer */
  for (i=ContN-1; i>=0; --i)
	*(ciD+i) = *(ciE+i) * (*(ci+i)) * (1.0 - *(ci+i));  
  for (i=FS_N-1; i>=0; --i) {
	if (fsFlag) *(paraD+i) = *(paraE+i) * (*(para+i)) * (1.0 - *(para+i));
  }
  for (i=InN-1; i>=0; --i)
	*(inD+i) = *(inE+i) * (*(in+i)) * (1.0 - *(in+i));  
  return(error);
}

double Single3Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,outE,coE,
				outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)
     double *in,*ci,*hid,*out,*co,*inD,*ciD,*hidD,*outD,*coD,
  *inE,*ciE,*hidE,*outE,*coE,*outTeach;
     int step;
     double *gate, *dr, *para, *paraD, *paraE;
     int wFlag, fsFlag; /* flag for weight/FS modification */
{
  int i,j;
  double *weight, *dw, *db, hid_sum=0.0, error=0.0;
 
  /* Initialize error as 0.0 for each node */   
  error = 0.0;
  for (i=0; i<OutN; ++i)
	*(outE+i) = 0.0;
    

  /* Back prop from output to hidden layer */
  for (i=OutN-1; i>=0; --i)
	{
	  *(outE+i) = (*(outTeach+i) - *(out+i));
	  error += (*(outE+i)) * (*(outE+i));
	}
  return(error);
}

Single4Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,outE,coE,
				outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)
     double *in,*ci,*hid,*out,*co,*inD,*ciD,*hidD,*outD,*coD,
  *inE,*ciE,*hidE,*outE,*coE,*outTeach;
     int step;
     double *gate, *dr, *para, *paraD, *paraE;
     int wFlag, fsFlag; /* flag for weight/FS modification */
{
  int i,j;
  double *weight, *dw, *db, hid_sum=0.0, error=0.0;
 
  /* Initialize error as 0.0 for each node */   
  for (i=0; i<InN; ++i)
	*(inE+i) = 0.0;
  for (i=0; i<FS_N; ++i)
	*(paraE+i) = 0.0;
  for (i=0; i<ContN; ++i)
	{
	  *(ciE+i) = 0.0;
	  *(coE+i) = 0.0;      }

  for (i=0; i<HiddenN; ++i)
	*(hidE+i) = 0.0;
    
  /* Back prop context out to hidden layer */
  weight = w32 + HiddenN*(ContN+OutN); /* point the end of w32 */    
  dw = dw32 + HiddenN*(ContN+OutN);
  db = db3 + OutN + ContN;
    
  /*E printf("--   BP     --\n");*/
  /* delta for context out has been computed in coD */
  for (i=ContN-1; i>=0; --i)
	{
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;		
		  /* gating also for context BP */
		  *(hidE+j) += *(coD+i) * (*weight);
		  if (wFlag) *dw += *(coD+i) * (*(hid+j));
	    }
	  --db;	  
	  if (wFlag) *db += *(coD+i);	  
	  /*E printf("%lf\n",*(coD+i));*/
	}
  /* Back prop from output to hidden layer */
  for (i=OutN-1; i>=0; --i)
	{
	  *(outD+i) = *(outE+i) * (*(out+i)) * (1.0 - *(out+i)); 
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;
		  *(hidE+j) += *(outD+i) * (*weight); 
		  *dw += *(outD+i) * (*(hid+j));
	    }	  
	  --db;	  
	  *db += *(outD+i);	  
	}
  /* Back prop from hidden to input layer */
  weight = w21 + HiddenN*(ContN+FS_N+InN); /* point the end of w32 */    
  dw = dw21 + HiddenN*(ContN+FS_N+InN);
  db = db2 + HiddenN;

  for (i=HiddenN-1; i>=0; --i)
	{
	  *(hidD+i) = *(hidE+i) * (*(hid+i)) * (1.0 - *(hid+i));
	  for (j=ContN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(ciE+j) += *(hidD+i) * (*weight);
		  if (wFlag) *dw += *(hidD+i) * (*(ci+j));
	    }
	  for (j=FS_N-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(paraE+j) += *(hidD+i) * (*weight);
		  if (wFlag) *dw += *(hidD+i) * (*(para+j));
	    }
	  for (j=InN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(inE+j) += *(hidD+i) * (*weight);
		  if (wFlag) *dw += *(hidD+i) * (*(in+j));
	    }
	  --db;	  
	  if (wFlag) *db += *(hidD+i);	  
	}
  /* delta computation for input layer */
  for (i=ContN-1; i>=0; --i)
	*(ciD+i) = *(ciE+i) * (*(ci+i)) * (1.0 - *(ci+i));  
  for (i=FS_N-1; i>=0; --i) {
	if (fsFlag) *(paraD+i) = *(paraE+i) * (*(para+i)) * (1.0 - *(para+i));
  }
  for (i=InN-1; i>=0; --i)
	*(inD+i) = *(inE+i) * (*(in+i)) * (1.0 - *(in+i));  
}


double Single1Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,outE,coE,
				outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)
     double *in,*ci,*hid,*out,*co,*inD,*ciD,*hidD,*outD,*coD,
  *inE,*ciE,*hidE,*outE,*coE,*outTeach;
     int step;
     double *gate, *dr, *para, *paraD, *paraE;
     int wFlag, fsFlag; /* flag for weight/FS modification */
{
  int i,j;
  double *weight, *dw, *db, hid_sum=0.0, error=0.0;
 
  /* Initialize error as 0.0 for each node */   
  error = 0.0;
  for (i=0; i<InN; ++i)
	*(inE+i) = 0.0;
  for (i=0; i<FS_N; ++i)
	*(paraE+i) = 0.0;
  for (i=0; i<ContN; ++i)
	{
	  *(ciE+i) = 0.0;
	  *(coE+i) = 0.0;      }

  for (i=0; i<HiddenN; ++i)
	*(hidE+i) = 0.0;

  for (i=0; i<OutN; ++i)
	*(outE+i) = 0.0;
    
  /* Back prop context out to hidden layer */
  weight = w32 + HiddenN*(ContN+OutN); /* point the end of w32 */    
  dw = dw32 + HiddenN*(ContN+OutN);
  db = db3 + OutN + ContN;
    
  /*E printf("--   BP     --\n");*/
  /* delta for context out has been computed in coD */
  for (i=ContN-1; i>=0; --i)
	{
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;		
		  /* gating also for context BP */
		  *(hidE+j) += *(coD+i) * (*weight);		  
	    }
	  --db;	  
	}
  /* Back prop from output to hidden layer */
  for (i=OutN-1; i>=0; --i)
	{
	  *(outE+i) = (*(outTeach+i) - *(out+i));
	  error += (*(outE+i)) * (*(outE+i));
	  *(outD+i) = *(outE+i) * (*(out+i)) * (1.0 - *(out+i)); 
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;
		  *(hidE+j) += *(outD+i) * (*weight); 
	    }	  
	  --db;	  
	}
  /* Back prop from hidden to input layer */
  weight = w21 + HiddenN*(ContN+FS_N+InN); /* point the end of w32 */    
  dw = dw21 + HiddenN*(ContN+FS_N+InN);
  db = db2 + HiddenN;

  for (i=HiddenN-1; i>=0; --i)
	{
	  *(hidD+i) = *(hidE+i) * (*(hid+i)) * (1.0 - *(hid+i));
	  for (j=ContN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(ciE+j) += *(hidD+i) * (*weight);
	    }
	  for (j=FS_N-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(paraE+j) += *(hidD+i) * (*weight);
	    }
	  for (j=InN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(inE+j) += *(hidD+i) * (*weight);
	    }
	  --db;	  
	}
  /* delta computation for input layer */
  for (i=ContN-1; i>=0; --i)
	*(ciD+i) = *(ciE+i) * (*(ci+i)) * (1.0 - *(ci+i));  
  for (i=FS_N-1; i>=0; --i) {
	if (fsFlag) *(paraD+i) = *(paraE+i) * (*(para+i)) * (1.0 - *(para+i));
  }
  for (i=InN-1; i>=0; --i)
	*(inD+i) = *(inE+i) * (*(in+i)) * (1.0 - *(in+i));  
  return(error);
}

Single2Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,outE,coE,
				outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)
     double *in,*ci,*hid,*out,*co,*inD,*ciD,*hidD,*outD,*coD,
  *inE,*ciE,*hidE,*outE,*coE,*outTeach;
     int step;
     double *gate, *dr, *para, *paraD, *paraE;
     int wFlag, fsFlag; /* flag for weight/FS modification */
{
  int i,j;
  double *weight, *dw, *db, hid_sum=0.0, error=0.0;
 
  /* Back prop context out to hidden layer */
  weight = w32 + HiddenN*(ContN+OutN); /* point the end of w32 */    
  dw = dw32 + HiddenN*(ContN+OutN);
  db = db3 + OutN + ContN;
    
  /*E printf("--   BP     --\n");*/
  /* delta for context out has been computed in coD */
  for (i=ContN-1; i>=0; --i)
	{
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;		
		  if (wFlag) *dw += *(coD+i) * (*(hid+j));
	    }
	  --db;	  
	  if (wFlag) *db += *(coD+i);	  
	  /*E printf("%lf\n",*(coD+i));*/
	}
  /* Back prop from output to hidden layer */
  for (i=OutN-1; i>=0; --i)
	{

	  for (j=HiddenN-1; j>=0; --j)
	    {
		  int fs_i, iw;
		  --weight;
		  --dw;
		  *dw += *(outD+i) * (*(hid+j));
	    }	  
	  --db;	  
	  *db += *(outD+i);	  
	}
  /* Back prop from hidden to input layer */
  weight = w21 + HiddenN*(ContN+FS_N+InN); /* point the end of w32 */    
  dw = dw21 + HiddenN*(ContN+FS_N+InN);
  db = db2 + HiddenN;

  for (i=HiddenN-1; i>=0; --i)
	{
	  for (j=ContN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  if (wFlag) *dw += *(hidD+i) * (*(ci+j));
	    }
	  for (j=FS_N-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  if (wFlag) *dw += *(hidD+i) * (*(para+j));
	    }
	  for (j=InN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  if (wFlag) *dw += *(hidD+i) * (*(in+j));
	    }
	  --db;	  
	  if (wFlag) *db += *(hidD+i);	  
	}
}

/* -----------------------------------
   Single Forward Activation
   ----------------------------------- */
SingleForwardAct(in,ci,hid,out,outU,co,para,fs)
     double *in, *ci, *hid, *out, *outU, *co, *para, *fs;
{	
  double *w, *b, sumExp=0.0;
  int i,j,k,l;

  /* hidden activation */
  w = w21;
  b = b2;
  for (i=0; i<HiddenN; ++i)
	{
	  double sum;
	  sum = *b;
	  for (j=0; j<InN; ++j)
	    {
		  sum += (*w) * (*(in+j));
		  ++w;

	    }
	  for (j=0; j<FS_N; ++j)
	    {
		  sum += (*w) * (*(para+j));
		  ++w;

	    }
	  for (j=0; j<ContN; ++j)
	    {
		  sum += (*w)*(*(ci+j));
		  ++w;
	    }

	  *(hid+i) = logistic(sum);
	  ++b;	  
	}

  /* output activation */
  w = w32;
  b = b3;
  for (i=0; i<OutN; ++i)
	{
	  double sum;
	  sum = *b;
	  for (j=0; j<HiddenN; ++j)
	    {
		  sum += (*w)*(*(hid + j));
		  ++w;
	    }
	  *(outU+i) = sum;
	  *(out+i) = logistic(sum);
	  ++b;
	  
	}
  for (i=0; i<ContN; ++i)
	{
	  double sum;
	  sum = *b;
	  for (j=0; j<HiddenN; ++j)
	    {
		  sum += (*w)*(*(hid+j));
		  ++w;
	    }
	  *(co+i) = logistic(sum);
	  ++b;
	  
	}
}    

/* --
   time averaged input into specific hidden units
   -- */
SingleForwardAct2(in,ci,hid,out,outU,co,para,fs,ciAve,inAve)
     double *in, *ci, *hid, *out, *outU, *co, *para, *fs, *ciAve, *inAve;
{	
  double *w, *b, sumExp=0.0;
  int i, j, k, l;

  /* hidden activation */
  w = w21;
  b = b2;
  for (i=0; i<HiddenN; ++i)
	{
	  double sum;
	  sum = *b;
	  for (j=0; j<InN; ++j)
	    {
		  if (i<SmoothN) sum += (*w) * (*(inAve+j));
		  else sum += (*w) * (*(in+j));
		  ++w;

	    }
	  for (j=0; j<FS_N; ++j)
	    {
		  sum += (*w) * (*(para+j));
		  ++w;

	    }
	  for (j=0; j<ContN; ++j)
	    {
		  if (i<SmoothN) sum += (*w)*(*(ciAve+j));
		  else sum += (*w) * (*(ci+j));
		  ++w;
	    }

	  *(hid+i) = logistic(sum);
	  ++b;	  
	}

  /* output activation */
  w = w32;
  b = b3;
  for (i=0; i<OutN; ++i)
	{
	  double sum;
	  sum = *b;
	  for (j=0; j<HiddenN; ++j)
	    {
		  sum += (*w)*(*(hid + j));
		  ++w;
	    }
	  *(outU+i) = sum;
	  *(out+i) = logistic(sum);
	  ++b;
	  
	}
  for (i=0; i<ContN; ++i)
	{
	  double sum;
	  sum = *b;
	  for (j=0; j<HiddenN; ++j)
	    {
		  sum += (*w)*(*(hid+j));
		  ++w;
	    }
	  *(co+i) = logistic(sum);
	  ++b;
	  
	}
}    


/* ----------------------------------------
   Closed sensory loop multiple forward act
   for a single sequence.
   step >= cStep, input feedback from the output prediction.
   ContIn at initStep is set as ContOut in the previous step.
   Fast synaptic modulation.
   ---------------------------------------- */
ClosedMultipleFact(net,seq,initStep,endStep,mode)
     struct NET *net;
     struct SequenceRecord *seq;
     int initStep,endStep,mode;
{
  int step,i,j,maxSteps;
  double *in,*inTeach,*ci,*hid,*out,*outU,*co,*outTeach,*para,*fs;
  double *tssExp;
  double noise[100];

  tssExp = seq -> TssExp + initStep;
  in = seq -> Input + initStep*InN;
  inTeach = seq ->InputTeach + initStep*InN;
  ci = seq -> ContIn + initStep*ContN;
  hid = seq -> Hidden + initStep*HiddenN;
  out = seq -> Output + initStep*OutN;
  outU = seq -> OutputU + initStep*OutN;
  outTeach = seq -> OutputTeach + initStep*OutN;
  co = seq-> ContOut + initStep*ContN;
  para = seq-> Para + initStep*FS_N;
  fs = seq-> FS + initStep*FS_N;

  /* set initial input from teach pattern */
  if (mode != RoboGene) {
	for (i=0; i<InN; ++i)
	  *(in+i) = *(inTeach+i);
  }

  /* multiple steps of Fact */
  for (step=initStep; step < endStep; ++step) {
	if (mode==RoboGene) {
	  /* This part has to be made in Verona!! 
		 The current sensor state and motor state
		 has to be put into in[InN] in the folowing function */
	  //GetCurrentSensorMotorState(in,InN); 
	  for (i=0; i<InN; ++i) *(inTeach+i) = *(in+i);
	}
	SingleForwardAct(in,ci,hid,out,outU,co,para,fs);
	if (mode==RoboGene) {
	  /* The predicted out vector should be sent to robot 
		 as next motor command */
	//SendNextSensorMotorState(out,OutN); 
	}
	
	if (step<endStep-1) {
	  /* input layer update */
	  in += InN;
	  inTeach += InN;
	  ci += ContN;


	  for (i=0; i<InN; ++i) {
		*(in+i) = *(inTeach+i)*inputRatio + *(out+i)*(1.0-inputRatio);
		rangeLimit(in+i,0.0,1.0);
	  }
	
	  for (i=0; i<ContN; ++i)    /* context loop */
		*(ci+i) = *(co+i);

	  /* hidden and out layer update */
	  hid += HiddenN;
	  co += ContN;
	  out += OutN;
	  outU += OutN;
	  outTeach += OutN;
	  para += FS_N;
	  fs += FS_N;
	  tssExp += 1;	    
	}
  }
}


/* -- 
  time averaged input into specific hidden units
   -- */
ClosedMultipleFact2(net,seq,initStep,endStep)
     struct NET *net;
     struct SequenceRecord *seq;
     int initStep,endStep;
{
  int step,i,j,maxSteps;
  double *in,*inTeach,*ci,*hid,*out,*outU,*co,*outTeach,*para,*fs;
  double *tssExp;
  double *inAve, *ciAve;
  double noise[100];

  tssExp = seq -> TssExp + initStep;
  in = seq -> Input + initStep*InN;
  inTeach = seq ->InputTeach + initStep*InN;
  ci = seq -> ContIn + initStep*ContN;
  hid = seq -> Hidden + initStep*HiddenN;
  out = seq -> Output + initStep*OutN;
  outU = seq -> OutputU + initStep*OutN;
  outTeach = seq -> OutputTeach + initStep*OutN;
  co = seq-> ContOut + initStep*ContN;
  para = seq-> Para + initStep*FS_N;
  fs = seq-> FS + initStep*FS_N;
  inAve = seq ->InputAve + initStep*InN;
  ciAve = seq-> ContInAve + initStep*ContN;

  /* set initial input from teach pattern */
  for (i=0; i<InN; ++i)
	*(in+i) = *(inTeach+i);
  /* context in set */
  if (initStep == 0) { /* very initial step */
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(ci+i); /* 0.5*/}
  else {
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(co-ContN+i); }

  /* multiple steps of Fact */
  for (step=initStep; step < endStep; ++step) {
	int noiseFlag;
	aveSequence(seq->ContIn,ciAve,ContN,step,SmoothLength);
	aveSequence(seq->Input,inAve,InN,step,SmoothLength);
	SingleForwardAct2(in,ci,hid,out,outU,co,para,fs,ciAve,inAve); /* time averaged input into specific hidden units */

	if (step<endStep-1) {
	  /* input layer update */
	  in += InN;
	  inAve += InN;
	  inTeach += InN;
	  ci += ContN;
	  ciAve += ContN;

	  if (fabs(SetRandom(1.0)) > 0.95) {
		noiseFlag=1;
		randomNormVector(noise,InN); /* unit noise compt */ }
	  else noiseFlag=0;
	  if (TrainMode == MAP) {
		for (i=0; i<InN; ++i) {
		  if (i<SenseN) /* sense inputs gets mix of out and inTch */ {
			*(in+i) = (*(inTeach+i)+ noise[i]*noiseRate*noiseFlag)*inputRatio + *(out+i)*(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);
		  }
		  else { /* act inputs gets from inTch */
			*(in+i) = *(inTeach+i); 
			/* step */ 
		  }		
		}
	  }
	  else if (TrainMode == DIFF) { /* */
		for (i=0; i<InN; ++i) {
		  if (i<SenseN) /* sense inputs gets mix of out and inTch */ {
			*(in+i) = *(inTeach+i)*inputRatio + 
			  deltaScaleInv(*(out+i),*(in+i-InN),DSCALE) *(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);
		  }
		  else { /* act inputs gets from inTch */
			*(in+i) = *(inTeach+i)*inputRatio + 
			  *(in)* *(in+1) *(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);
			/* step */ 
		  }		
		}
	  }
	  else;
	
	  for (i=0; i<ContN; ++i)    /* context loop */
		*(ci+i) = *(co+i);

	  /* hidden and out layer update */
	  hid += HiddenN;
	  co += ContN;
	  out += OutN;
	  outU += OutN;
	  outTeach += OutN;
	  para += FS_N;
	  fs += FS_N;
	  tssExp += 1;	    
	}
  }
}

randomNormVector(a,N)
	 double *a;
	 int N;
{
  int i;
  double sqR=0.0;
  for (i=0; i<N; ++i) {
	a[i] = SetRandom(1.0);
	sqR += a[i]*a[i];
  }
  sqR = sqrt(sqR);
  for (i=0; i<N; ++i) {
	a[i] = a[i]/sqR;
  }
}

/* 
   closed loop only for last ClosedL steps 
*/
OpenClosedMultipleFact(net,seq,initStep,endStep)
     struct NET *net;
     struct SequenceRecord *seq;
     int initStep,endStep;
{
  int step,i,j,maxSteps;
  double *in,*inTeach,*ci,*hid,*out,*outU,*co,*outTeach,*para,*fs;
  double *tssExp;

  tssExp = seq -> TssExp + initStep;
  in = seq -> Input + initStep*InN;
  inTeach = seq ->InputTeach + initStep*InN;
  ci = seq -> ContIn + initStep*ContN;
  hid = seq -> Hidden + initStep*HiddenN;
  out = seq -> Output + initStep*OutN;
  outU = seq -> OutputU + initStep*OutN;
  outTeach = seq -> OutputTeach + initStep*OutN;
  co = seq-> ContOut + initStep*ContN;
  para = seq-> Para + initStep*FS_N;
  fs = seq-> FS + initStep*FS_N;

  /* set initial input from teach pattern */
  for (i=0; i<InN; ++i)
	*(in+i) = *(inTeach+i);
  /* context in set */
  if (initStep == 0) { /* very initial step */
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(ci+i); /* 0.5*/}
  else {
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(co-ContN+i); }

  /* multiple steps of Fact */
  //fprintf(stderr,"\ninitStep%d endStep%d -- ",initStep,endStep);
  for (step=initStep; step < endStep; ++step) {
	SingleForwardAct(in,ci,hid,out,outU,co,para,fs);

	if (step<endStep-1) {
	  /* input layer update */
	  in += InN;
	  inTeach += InN;
	  ci += ContN;
	  /* inputRatio control for closed loop Fact */
	  if (step<endStep-ClosedL) /* closed loop for last ClosedL steps */
		inputRatio = 1.0;
	  else inputRatio = 0.0;
	  //fprintf(stderr,"%d %5.2f ",step,inputRatio);
	  if (TrainMode == MAP) {
		for (i=0; i<InN; ++i) {
		  if (i<SenseN) /* sense inputs gets mix of out and inTch */ {
			*(in+i) = *(inTeach+i)*inputRatio + *(out+i)*(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);
		  }
		  else { /* act inputs gets from inTch */
			*(in+i) = *(inTeach+i); 
			/* step */ 
		  }		
		}
	  }
	  else if (TrainMode == DIFF) { /* */
		for (i=0; i<InN; ++i) {
		  if (i<SenseN) /* sense inputs gets mix of out and inTch */ {
			*(in+i) = *(inTeach+i)*inputRatio + 
			  deltaScaleInv(*(out+i),*(in+i-InN),DSCALE) *(1.0-inputRatio)
			  +noiseRate*SetRandom(1.0);
			rangeLimit(in+i,0.0,1.0);
			if (i==0 && TimeL%50==0)
			  fprintf(stderr,"\n%d inPre%5.3f in%5.3f out%5.2f DSCALE%f ",
					  step,*(in+i-InN),*(in+i),*(out+i),DSCALE);			
		  }
		  else { /* act inputs gets from inTch */
			*(in+i) = *(inTeach+i)*inputRatio + 
			  *(in)* *(in+1) *(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);
			/* step */ 
		  }	
		}
	  }
	  else;
	
	  for (i=0; i<ContN; ++i)    /* context loop */
		*(ci+i) = *(co+i);

	  /* hidden and out layer update */
	  hid += HiddenN;
	  co += ContN;
	  out += OutN;
	  outU += OutN;
	  outTeach += OutN;
	  para += FS_N;
	  fs += FS_N;

	  tssExp += 1;	    
	}
  }
}

ForwardLinearSum(net,seq,initStep,endStep)
     struct NET *net;
     struct SequenceRecord *seq;
     int initStep,endStep;
{
  int step,i,j,maxSteps;
  double *in,*inTeach,*ci,*hid,*out,*outU,*co,*outTeach,*para,*fs;
  double *tssExp;
  double out0[40], out1[40], co0[40], co1[40];


  tssExp = seq -> TssExp + initStep;
  in = seq -> Input + initStep*InN;
  inTeach = seq ->InputTeach + initStep*InN;
  ci = seq -> ContIn + initStep*ContN;
  hid = seq -> Hidden + initStep*HiddenN;
  out = seq -> Output + initStep*OutN;
  outU = seq -> OutputU + initStep*OutN;
  outTeach = seq -> OutputTeach + initStep*OutN;
  co = seq-> ContOut + initStep*ContN;
  para = seq-> Para + initStep*FS_N;
  fs = seq-> FS + initStep*FS_N;

  /* set initial input from teach pattern */
  for (i=0; i<InN; ++i)
	*(in+i) = *(inTeach+i);
  /* context in set */
  if (initStep == 0) { /* very initial step */
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(ci+i); /* 0.5*/}
  else {
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(co-ContN+i); }

  /* multiple steps of Fact */
  for (step=initStep; step < endStep; ++step) {
	w21=w21_0; w32=w32_0; b2=b2_0; b3=b3_0;
	SingleForwardAct(in,ci,hid,out0,outU,co0,para,fs);
	//fprintf(stderr,"w21_0%f ",*w21);
	w21=w21_1; w32=w32_1; b2=b2_1; b3=b3_1;
	SingleForwardAct(in,ci,hid,out1,outU,co1,para,fs);
	//fprintf(stderr,"w21_1%f ",*w21);
	for (i=0; i<OutN; ++i) {
	  out[i] = linearK*out0[i]+(1.0-linearK)*out1[i]; }

	for (i=0; i<ContN; ++i) {
	  co[i] = linearK*co0[i]+(1.0-linearK)*co1[i]; }

	if (step<endStep-1) {
	  /* input layer update */
	  in += InN;
	  inTeach += InN;
	  ci += ContN;

	  inputRatio = 0.0; /* closed loop */
	  if (TrainMode == MAP) {
		for (i=0; i<InN; ++i) {
		  if (i<SenseN) /* sense inputs gets mix of out and inTch */ {
			*(in+i) = *(inTeach+i)*inputRatio + *(out+i)*(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);
		  }
		  else { /* act inputs gets from inTch */
			*(in+i) = *(inTeach+i); 
			/* step */ 
		  }		
		}
	  }
	  else if (TrainMode == DIFF) { /* */
		
		for (i=0; i<InN; ++i) {
		  if (i<SenseN) /* sense inputs gets mix of out and inTch */ {
			*(in+i) = *(inTeach+i)*inputRatio + 
			  deltaScaleInv(*(out+i),*(in+i-InN),DSCALE) *(1.0-inputRatio);
			rangeLimit(in+i,0.0,1.0);		   
			if (i==0)
			  fprintf(stderr,"\n%dinP%5.3f in%5.3f out%5.2f DSCALE%5.2f ",
					  step,*(in+i-InN),*(in+i),*(out+i),DSCALE);			
		  }
		  else { /* act inputs gets from inTch */
			*(in+i) = *(inTeach+i); 
			/* step */ 
		  }		
		}
	  }
	  else;
	
	  for (i=0; i<ContN; ++i)    /* context loop */
		*(ci+i) = *(co+i);

	  /* hidden and out layer update */
	  hid += HiddenN;
	  co += ContN;
	  out += OutN;
	  outU += OutN;
	  outTeach += OutN;
	  para += FS_N;
	  fs += FS_N;

	  tssExp += 1;	    
	}
  }
}

/* --
   update PB as for constant value in the same sequence
   -- */
updateFS(seq)
	 struct SequenceRecord *seq;
{
  int step,i,j,maxSteps;
  double dsum[100];

  maxSteps = seq->steps;

  for (i=0; i<FS_N; ++i) {
	dsum[i]=0.0;
	for (step=0; step<maxSteps; ++step) {
	  dsum[i] += *(seq->ParaDel+FS_N*step+i); }
	*(seq->FS+i) += epsi_fs*dsum[i];
	*(seq->Para+i) = logistic(*(seq->FS+i));
	for (step=0; step<maxSteps; ++step) {
	  *(seq->FS+FS_N*step+i) = *(seq->FS+i);
	  *(seq->Para+FS_N*step+i) = *(seq->Para+i);
	}
  }
}
	


/* --
   update context at stepInit
   -- */
updateInitCont(seq,stepI)
struct SequenceRecord *seq;
int stepI;
{
  int step, i;
  double *ci, *ciD, *ciU;

  ciD = seq -> ContInDel + stepI*ContN;
  ci = seq -> ContIn + stepI*ContN;
  ciU = seq -> ContInU + stepI*ContN;
  for (i=0; i<ContN; ++i) {
	ciU[i] += epsiCont*ciD[i];
	ci[i] = logistic(ciU[i]);
  }
}


/* --
   closed loop forward activation with fixed fs for all steps
   -- */
ClosedLoopFact(net,seq,initStep,endStep)
     struct NET *net;
     struct SequenceRecord *seq;
     int initStep,endStep;
{
  int step,i,j,maxSteps;
  double *in,*inTeach,*ci,*hid,*out,*co,*outTeach,*para,*fs;

  in = seq -> Input + initStep*InN;
  inTeach = seq ->InputTeach + initStep*InN;
  ci = seq -> ContIn + initStep*ContN;
  hid = seq -> Hidden + initStep*HiddenN;
  out = seq -> Output + initStep*OutN;
  outTeach = seq -> OutputTeach + initStep*OutN;
  co = seq-> ContOut + initStep*ContN;
  para = seq-> Para + initStep*FS_N;
  fs = seq-> FS + initStep*FS_N;

  printf("\n%d fs? ",FS_N);
  for (i=0; i<FS_N; ++i) 
	scanf("%lf",fs+i);
  /* set initial input from teach pattern */
  for (i=0; i<InN; ++i)
	*(in+i) = (SetRandom(1.0)+1.0)*0.5;
  /* context in set */
  if (initStep == 0) { /* very initial step */
	for (i=0; i<ContN; ++i)
	  *(ci+i) = (SetRandom(1.0)+1.0)*0.5; }
  else {
	for (i=0; i<ContN; ++i)
	  *(ci+i) = *(co-ContN+i); }

  /* multiple steps of Fact */
  for (step=initStep; step < endStep; ++step) {
	SingleForwardAct(in,ci,hid,out,co,para,fs);
	/* input layer update */
	in += InN;
	inTeach += InN;
	ci += ContN;
	printf("\n");
	for (i=0; i<InN; ++i) {
	  *(in+i) = *(out+i); /* self-feedback from out if future */
	  printf("%5.2f ",*(out+i)); }
	for (i=0; i<ContN; ++i)    /* context loop */
	  *(ci+i) = *(co+i);
	for (i=0; i<FS_N; ++i) {/* use same fs values for next step */
	  *(fs+i+FS_N) = *(fs+i);
	  printf("%5.2f ",*(fs+i)); }
	/* hidden and out layer update */
	hid += HiddenN;
	co += ContN;
	out += OutN;
	outTeach += OutN;
	para += FS_N;
	fs += FS_N;
  }
}



/* ---------------------------------------------------
   Multiple BP
   Fast Synapse Modulation.
   --------------------------------------------------- */
ClosedMultipleBP(net,seq,initStep,endStepW,startStepF,endStep)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStepW, startStepF, endStep;
{
  double *in, *ci, *hid,*out,*outTeach,*co,*inD,*ciD,*hidD,*outD,*coD,
    *inE,*ciE,*hidE,*outE,*coE,*tss,*tssAve,*actError,*dr,*gate,*para,*paraD,*paraE;
  int maxSteps, step, i, j, length;

  /* initialize */
  maxSteps = seq -> steps;
  in = seq -> Input + (endStep-1)*InN;
  ci = seq -> ContIn + (endStep-1)*ContN;
  hid = seq -> Hidden + (endStep-1)*HiddenN;
  out = seq -> Output + (endStep-1)*OutN;
  outTeach = seq -> OutputTeach + (endStep-1)*OutN;
  co = seq -> ContOut + (endStep-1)*ContN;
  inD = seq -> InDel + (endStep-1)*InN;
  ciD = seq -> ContInDel + (endStep-1)*ContN;
  hidD = seq -> HiddenDel + (endStep-1)*HiddenN;
  outD = seq -> OutDel + (endStep-1)*OutN;
  coD = seq -> ContOutDel + (endStep-1)*ContN;
  inE = seq -> InEr + (endStep-1)*InN;
  ciE = seq -> ContInEr + (endStep-1)*ContN;
  hidE = seq -> HiddenEr + (endStep-1)*HiddenN;
  outE = seq -> OutEr + (endStep-1)*OutN;
  coE = seq -> ContOutEr + (endStep-1)*ContN;
  tss = seq -> Tss + endStep - 1;
  tssAve = seq -> TssAve + endStep - 1;
  actError = seq -> ActError + endStep - 1;
  dr = seq -> DelayReward + endStep - 1;
  gate = seq -> Gate + (endStep-1);
  para = seq -> Para + (endStep-1)*FS_N;
  paraD = seq -> ParaDel + (endStep-1)*FS_N;
  paraE = seq -> ParaEr + (endStep-1)*FS_N;
    
  /* The delta of context units at the distal step is set as 0.0. */
  for (i=0; i<ContN; ++i)
	*(coD+i) = 0.0;
  /* multiple steps bptt from the distal step of the seq. */
  for (step = endStep-1; step >= initStep; --step)
	{
	  int wFlag, fsFlag;
	  if (step < endStepW) wFlag = 1;
	  else wFlag = 0;
	  if (step>=startStepF) fsFlag = 1;
	  else fsFlag = 0;
	  /* compute */
	  *actError = 
	    SingleBp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,
				 outE,coE,outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)/OutN;
	  *tss = *actError;
	  /* sum of all units sq error for all steps of learning */
	  net->errorS += *actError;
	  if (step > initStep)
		{ 
		  /* context feedback loop with decay */
		  coD -= ContN; 
		  for (i=0; i<ContN; ++i)
			*(coD+i) = *(ciD+i) * decay;
		  /* pointer one cycle unrolled. */
		  in -= InN;
		  ci -= ContN;
		
		  hid -= HiddenN;
		  hidE -= HiddenN;
		  out -= OutN;
		  co  -= ContN;
		  inD -= InN;
		  ciD -= ContN;
		  hidD -= HiddenN;
		  outD -= OutN;
		  inE -= InN;
		  ciE -= ContN; 
		  outE -= OutN;
		  coE -= ContN;
		  outTeach -= OutN;
		  actError -= 1;
		  dr -= 1;
		  gate -= 1;
		  para -= FS_N;
		  paraD -= FS_N;
		  paraE -= FS_N;
		  tss -= 1;
		}
	}

  /* initial context update vector */
  for (i=0; i < ContN; ++i)
	*(seq -> dInitCont + ContN*initStep + i) = *(ciD + i);
}

ClosedMultiple3BP(net,seq,initStep,endStepW,startStepF,endStep)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStepW, startStepF, endStep;
{
  double *in, *ci, *hid,*out,*outTeach,*co,*inD,*ciD,*hidD,*outD,*coD,
    *inE,*ciE,*hidE,*outE,*coE,*tss,*tssAve,*actError,*dr,*gate,*para,*paraD,*paraE;
  int maxSteps, step, i, j, length;

  /* initialize */
  maxSteps = seq -> steps;
  in = seq -> Input + (endStep-1)*InN;
  ci = seq -> ContIn + (endStep-1)*ContN;
  hid = seq -> Hidden + (endStep-1)*HiddenN;
  out = seq -> Output + (endStep-1)*OutN;
  outTeach = seq -> OutputTeach + (endStep-1)*OutN;
  co = seq -> ContOut + (endStep-1)*ContN;
  inD = seq -> InDel + (endStep-1)*InN;
  ciD = seq -> ContInDel + (endStep-1)*ContN;
  hidD = seq -> HiddenDel + (endStep-1)*HiddenN;
  outD = seq -> OutDel + (endStep-1)*OutN;
  coD = seq -> ContOutDel + (endStep-1)*ContN;
  inE = seq -> InEr + (endStep-1)*InN;
  ciE = seq -> ContInEr + (endStep-1)*ContN;
  hidE = seq -> HiddenEr + (endStep-1)*HiddenN;
  outE = seq -> OutEr + (endStep-1)*OutN;
  coE = seq -> ContOutEr + (endStep-1)*ContN;
  tss = seq -> Tss + endStep - 1;
  tssAve = seq -> TssAve + endStep - 1;
  actError = seq -> ActError + endStep - 1;
  dr = seq -> DelayReward + endStep - 1;
  gate = seq -> Gate + (endStep-1);
  para = seq -> Para + (endStep-1)*FS_N;
  paraD = seq -> ParaDel + (endStep-1)*FS_N;
  paraE = seq -> ParaEr + (endStep-1)*FS_N;
    
  /* The delta of context units at the distal step is set as 0.0. */
  for (i=0; i<ContN; ++i)
	*(coD+i) = 0.0;
  /* multiple steps bptt from the distal step of the seq. */
  for (step = endStep-1; step >= initStep; --step)
	{
	  int wFlag, fsFlag;
	  if (step < endStepW) wFlag = 1;
	  else wFlag = 0;
	  if (step>=startStepF) fsFlag = 1;
	  else fsFlag = 0;
	  /* compute */
	  *actError = 
	    Single3Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,
				 outE,coE,outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)/OutN;
	  *tss = *actError;
	  /* sum of all units sq error for all steps of learning */
	  net->errorS += *actError;
	  if (step > initStep)
		{ 
		  /* context feedback loop with decay */
		  coD -= ContN; 
		  /* pointer one cycle unrolled. */
		  in -= InN;
		  ci -= ContN;
		
		  hid -= HiddenN;
		  hidE -= HiddenN;
		  out -= OutN;
		  co  -= ContN;
		  inD -= InN;
		  ciD -= ContN;
		  hidD -= HiddenN;
		  outD -= OutN;
		  inE -= InN;
		  ciE -= ContN; 
		  outE -= OutN;
		  coE -= ContN;
		  outTeach -= OutN;
		  actError -= 1;
		  dr -= 1;
		  gate -= 1;
		  para -= FS_N;
		  paraD -= FS_N;
		  paraE -= FS_N;
		  tss -= 1;
		}
	}
}

ClosedMultiple4BP(net,seq,initStep,endStepW,startStepF,endStep)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStepW, startStepF, endStep;
{
  double *in, *ci, *hid,*out,*outTeach,*co,*inD,*ciD,*hidD,*outD,*coD,
    *inE,*ciE,*hidE,*outE,*coE,*tss,*tssAve,*actError,*dr,*gate,*para,*paraD,*paraE;
  int maxSteps, step, i, j, length;

  /* initialize */
  maxSteps = seq -> steps;
  in = seq -> Input + (endStep-1)*InN;
  ci = seq -> ContIn + (endStep-1)*ContN;
  hid = seq -> Hidden + (endStep-1)*HiddenN;
  out = seq -> Output + (endStep-1)*OutN;
  outTeach = seq -> OutputTeach + (endStep-1)*OutN;
  co = seq -> ContOut + (endStep-1)*ContN;
  inD = seq -> InDel + (endStep-1)*InN;
  ciD = seq -> ContInDel + (endStep-1)*ContN;
  hidD = seq -> HiddenDel + (endStep-1)*HiddenN;
  outD = seq -> OutDel + (endStep-1)*OutN;
  coD = seq -> ContOutDel + (endStep-1)*ContN;
  inE = seq -> InEr + (endStep-1)*InN;
  ciE = seq -> ContInEr + (endStep-1)*ContN;
  hidE = seq -> HiddenEr + (endStep-1)*HiddenN;
  outE = seq -> OutEr + (endStep-1)*OutN;
  coE = seq -> ContOutEr + (endStep-1)*ContN;
  tss = seq -> Tss + endStep - 1;
  tssAve = seq -> TssAve + endStep - 1;
  actError = seq -> ActError + endStep - 1;
  dr = seq -> DelayReward + endStep - 1;
  gate = seq -> Gate + (endStep-1);
  para = seq -> Para + (endStep-1)*FS_N;
  paraD = seq -> ParaDel + (endStep-1)*FS_N;
  paraE = seq -> ParaEr + (endStep-1)*FS_N;
    
  /* The delta of context units at the distal step is set as 0.0. */
  for (i=0; i<ContN; ++i)
	*(coD+i) = 0.0;
  /* multiple steps bptt from the distal step of the seq. */
  for (step = endStep-1; step >= initStep; --step)
	{
	  int wFlag, fsFlag;
	  if (step < endStepW) wFlag = 1;
	  else wFlag = 0;
	  if (step>=startStepF) fsFlag = 1;
	  else fsFlag = 0;
	  /* compute */
	  Single4Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,
				 outE,coE,outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag);
	  *tss = *actError;
	  /* sum of all units sq error for all steps of learning */
	  net->errorS += *actError;
	  if (step > initStep)
		{ 
		  /* context feedback loop with decay */
		  coD -= ContN; 
		  for (i=0; i<ContN; ++i)
			*(coD+i) = *(ciD+i) * decay;
		  /* pointer one cycle unrolled. */
		  in -= InN;
		  ci -= ContN;
		
		  hid -= HiddenN;
		  hidE -= HiddenN;
		  out -= OutN;
		  co  -= ContN;
		  inD -= InN;
		  ciD -= ContN;
		  hidD -= HiddenN;
		  outD -= OutN;
		  inE -= InN;
		  ciE -= ContN; 
		  outE -= OutN;
		  coE -= ContN;
		  outTeach -= OutN;
		  actError -= 1;
		  dr -= 1;
		  gate -= 1;
		  para -= FS_N;
		  paraD -= FS_N;
		  paraE -= FS_N;
		  tss -= 1;
		}
	}

  /* initial context update vector */
  for (i=0; i < ContN; ++i)
	*(seq -> dInitCont + ContN*initStep + i) = *(ciD + i);
}



ClosedMultiple1BP(net,seq,initStep,endStepW,startStepF,endStep)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStepW, startStepF, endStep;
{
  double *in, *ci, *hid,*out,*outTeach,*co,*inD,*ciD,*hidD,*outD,*coD,
    *inE,*ciE,*hidE,*outE,*coE,*tss,*tssAve,*actError,*dr,*gate,*para,*paraD,*paraE;
  int maxSteps, step, i, j, length;

  /* initialize */
  maxSteps = seq -> steps;
  in = seq -> Input + (endStep-1)*InN;
  ci = seq -> ContIn + (endStep-1)*ContN;
  hid = seq -> Hidden + (endStep-1)*HiddenN;
  out = seq -> Output + (endStep-1)*OutN;
  outTeach = seq -> OutputTeach + (endStep-1)*OutN;
  co = seq -> ContOut + (endStep-1)*ContN;
  inD = seq -> InDel + (endStep-1)*InN;
  ciD = seq -> ContInDel + (endStep-1)*ContN;
  hidD = seq -> HiddenDel + (endStep-1)*HiddenN;
  outD = seq -> OutDel + (endStep-1)*OutN;
  coD = seq -> ContOutDel + (endStep-1)*ContN;
  inE = seq -> InEr + (endStep-1)*InN;
  ciE = seq -> ContInEr + (endStep-1)*ContN;
  hidE = seq -> HiddenEr + (endStep-1)*HiddenN;
  outE = seq -> OutEr + (endStep-1)*OutN;
  coE = seq -> ContOutEr + (endStep-1)*ContN;
  tss = seq -> Tss + endStep - 1;
  tssAve = seq -> TssAve + endStep - 1;
  actError = seq -> ActError + endStep - 1;
  dr = seq -> DelayReward + endStep - 1;
  gate = seq -> Gate + (endStep-1);
  para = seq -> Para + (endStep-1)*FS_N;
  paraD = seq -> ParaDel + (endStep-1)*FS_N;
  paraE = seq -> ParaEr + (endStep-1)*FS_N;
    
  /* The delta of context units at the distal step is set as 0.0. */
  for (i=0; i<ContN; ++i)
	*(coD+i) = 0.0;
  /* multiple steps bptt from the distal step of the seq. */
  for (step = endStep-1; step >= initStep; --step)
	{
	  int wFlag, fsFlag;
	  if (step < endStepW) wFlag = 1;
	  else wFlag = 0;
	  if (step>=startStepF) fsFlag = 1;
	  else fsFlag = 0;
	  /* compute */
	  *actError = 
	    Single1Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,
				 outE,coE,outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag)/OutN;
	  *tss = *actError;
	  /* sum of all units sq error for all steps of learning */
	  net->errorS += *actError;
	  if (step > initStep)
		{ 
		  /* context feedback loop with decay */
		  coD -= ContN; 
		  for (i=0; i<ContN; ++i)
			*(coD+i) = *(ciD+i) * decay;
		  /* pointer one cycle unrolled. */
		  in -= InN;
		  ci -= ContN;
		
		  hid -= HiddenN;
		  hidE -= HiddenN;
		  out -= OutN;
		  co  -= ContN;
		  inD -= InN;
		  ciD -= ContN;
		  hidD -= HiddenN;
		  outD -= OutN;
		  inE -= InN;
		  ciE -= ContN; 
		  outE -= OutN;
		  coE -= ContN;
		  outTeach -= OutN;
		  actError -= 1;
		  dr -= 1;
		  gate -= 1;
		  para -= FS_N;
		  paraD -= FS_N;
		  paraE -= FS_N;
		  tss -= 1;
		}
	}

  /* initial context update vector */
  for (i=0; i < ContN; ++i)
	*(seq -> dInitCont + ContN*initStep + i) = *(ciD + i);
}

ClosedMultiple2BP(net,seq,initStep,endStepW,startStepF,endStep)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStepW, startStepF, endStep;
{
  double *in, *ci, *hid,*out,*outTeach,*co,*inD,*ciD,*hidD,*outD,*coD,
    *inE,*ciE,*hidE,*outE,*coE,*tss,*tssAve,*actError,*dr,*gate,*para,*paraD,*paraE;
  int maxSteps, step, i, j, length;

  /* initialize */
  maxSteps = seq -> steps;
  in = seq -> Input + (endStep-1)*InN;
  ci = seq -> ContIn + (endStep-1)*ContN;
  hid = seq -> Hidden + (endStep-1)*HiddenN;
  out = seq -> Output + (endStep-1)*OutN;
  outTeach = seq -> OutputTeach + (endStep-1)*OutN;
  co = seq -> ContOut + (endStep-1)*ContN;
  inD = seq -> InDel + (endStep-1)*InN;
  ciD = seq -> ContInDel + (endStep-1)*ContN;
  hidD = seq -> HiddenDel + (endStep-1)*HiddenN;
  outD = seq -> OutDel + (endStep-1)*OutN;
  coD = seq -> ContOutDel + (endStep-1)*ContN;
  inE = seq -> InEr + (endStep-1)*InN;
  ciE = seq -> ContInEr + (endStep-1)*ContN;
  hidE = seq -> HiddenEr + (endStep-1)*HiddenN;
  outE = seq -> OutEr + (endStep-1)*OutN;
  coE = seq -> ContOutEr + (endStep-1)*ContN;
  tss = seq -> Tss + endStep - 1;
  tssAve = seq -> TssAve + endStep - 1;
  actError = seq -> ActError + endStep - 1;
  dr = seq -> DelayReward + endStep - 1;
  gate = seq -> Gate + (endStep-1);
  para = seq -> Para + (endStep-1)*FS_N;
  paraD = seq -> ParaDel + (endStep-1)*FS_N;
  paraE = seq -> ParaEr + (endStep-1)*FS_N;
    
  /* multiple steps bptt from the distal step of the seq. */
  for (step = endStep-1; step >= initStep; --step)
	{
	  int wFlag, fsFlag;
	  if (step < endStepW) wFlag = 1;
	  else wFlag = 0;
	  if (step>=startStepF) fsFlag = 1;
	  else fsFlag = 0;
	  /* compute only db and dw */
	  Single2Bp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,
				outE,coE,outTeach,step,gate,dr,para,paraD,paraE,wFlag,fsFlag);
	  if (step > initStep)
		{ 
		  /* context feedback loop with decay */
		  coD -= ContN; 
		  /* pointer one cycle unrolled. */
		  in -= InN;
		  ci -= ContN;
		
		  hid -= HiddenN;
		  hidE -= HiddenN;
		  out -= OutN;
		  co  -= ContN;
		  inD -= InN;
		  ciD -= ContN;
		  hidD -= HiddenN;
		  outD -= OutN;
		  inE -= InN;
		  ciE -= ContN; 
		  outE -= OutN;
		  coE -= ContN;
		  outTeach -= OutN;
		  actError -= 1;
		  dr -= 1;
		  gate -= 1;
		  para -= FS_N;
		  paraD -= FS_N;
		  paraE -= FS_N;
		  tss -= 1;
		}
	}

  /* initial context update vector */
  for (i=0; i < ContN; ++i)
	*(seq -> dInitCont + ContN*initStep + i) = *(ciD + i);
}

smoothDelta(net,seq,initStep,endStep,winL)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStep,winL;
{
  double *inD,*ciD,*hidD,*outD,*coD;

  inD = seq -> InDel;
  ciD = seq -> ContInDel;
  hidD = seq -> HiddenDel;
  outD = seq -> OutDel;
  coD = seq -> ContOutDel;

  smoothSequence(inD,InN,initStep,endStep,winL);
  smoothSequence(ciD,ContN,initStep,endStep,winL);
  smoothSequence(hidD,HiddenN,initStep,endStep,winL);
  smoothSequence(outD,OutN,initStep,endStep,winL);
  smoothSequence(coD,ContN,initStep,endStep,winL);

  smoothSequence(inD,InN,initStep,endStep,winL);
  smoothSequence(ciD,ContN,initStep,endStep,winL);
  smoothSequence(hidD,HiddenN,initStep,endStep,winL);
  smoothSequence(outD,OutN,initStep,endStep,winL);
  smoothSequence(coD,ContN,initStep,endStep,winL);

}

smoothOutError(net,seq,initStep,endStep,winL)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStep,winL;
{
  double *outE;

  outE = seq -> OutEr;
  smoothSequence(outE,OutN,initStep,endStep,winL);

}

	  
/* ----------------------------------
   UpdateWeight
   weight, bias;
   ---------------------------------- */
UpdateWeightBias(range)
	 double range;
{
  Chbw(w21,dw21,dlw21,w21+(HiddenN*(InN+ContN)),-1.0*range,range);
  Chbw(w32,dw32,dlw32,w32+(HiddenN*(OutN+ContN)),-1.0*range,range);
  Chbw(b2,db2,dlb2,b2+HiddenN,-1.0*range,range);
  Chbw(b3,db3,dlb3,b3+OutN+ContN,-1.0*range,range);
}   

InitDeltaWeight()
{
  double *iw, *ib;
  for (iw=dw21; iw<dw21+HiddenN*(InN+FS_N+ContN); ++iw)
	*(iw) = 0.0;
  for (iw=dw32; iw<dw32+HiddenN*(OutN+ContN); ++iw)
	*(iw) = 0.0;
  for (ib=db2; ib<db2+HiddenN; ++ib)
	*ib = 0.0;
  for (ib=db3; ib<db3+OutN+ContN; ++ib)
	*ib = 0.0;
}

/* ------------------------------------------------
   update *bw and *dlbw, and initialize *dbw as 0.0.
   ------------------------------------------------ */
Chbw(bw, dbw, dlbw, bw_end, low, high)
	 double *bw, *dbw, *dlbw, *bw_end, low, high;
{
  double *bw_sub, *dbw_sub, *dlbw_sub;
  for(bw_sub = bw, dbw_sub = dbw, dlbw_sub = dlbw; bw_sub < bw_end;
	  bw_sub ++, dbw_sub ++, dlbw_sub ++)
	Modifbw(bw_sub, dbw_sub, dlbw_sub, low, high);
}

Modifbw(bw, dbw, dlbw, low, high) 
	 double *bw, *dbw, *dlbw, low, high;
{
  *dlbw = epsi * (*dbw) + momentum * (*dlbw);
  *bw += *dlbw;
  *dbw = 0.0; /* initialize delta as 0.0 */

  if (*bw < low)
	*bw = low;
  else if (*bw > high)
	*bw = high;
  else;

}


/* --
   AllocRnn()/
   -- */
AllocRnn(net)
	 struct NET *net;
{
  int i;
  setNetGlobal(net);

  /* alloc of weight bias */
  fprintf(stderr,"\n InN %d ContN %d OutN %d HiddenN %d ",InN,ContN,OutN,HiddenN);
  w21 = (double *)calloc((InN+FS_N+ContN)*HiddenN, sizeof(double));
  w32 = (double *)calloc((OutN+ContN)*HiddenN, sizeof(double));
  dw21 = (double *)calloc((InN+FS_N+ContN)*HiddenN, sizeof(double));
  dw32 = (double *)calloc((OutN+ContN)*HiddenN, sizeof(double));
  dlw21 = (double *)calloc((InN+FS_N+ContN)*HiddenN, sizeof(double));
  dlw32 = (double *)calloc((OutN+ContN)*HiddenN, sizeof(double));
  b2 = (double *)calloc(HiddenN, sizeof(double));
  b3 = (double *)calloc(OutN+ContN, sizeof(double));
  db2 = (double *)calloc(HiddenN, sizeof(double));
  db3 = (double *)calloc(OutN+ContN, sizeof(double)); 
  dlb2 = (double *)calloc(HiddenN, sizeof(double));
  dlb3 = (double *)calloc(OutN+ContN, sizeof(double));
  InType = (int *)calloc(InN,sizeof(int));
  setNetLocal(net);
}

/* --------------------------------------
   Alloc Train Sequence
   struct SequenceRecord sequence[seqnum] is allocated.
   -------------------------------------- */
AllocSequence(sequence,seqLength,seqNum,net)
	 struct SequenceRecord *sequence; int seqLength, seqNum;
	 struct NET *net;
{
  setNetGlobal(net);
  sequence[seqNum].steps = seqLength;
  sequence[seqNum].TssExpSum = 1.0;
  sequence[seqNum].PredictError = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].PredictErrorInteg = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].Input = (double *)calloc(InN*seqLength,sizeof(double));
  sequence[seqNum].InputTeach = (double *)calloc(InN*seqLength,sizeof(double)
												 );
  fprintf(stderr,"AllocTch%d ",sequence[seqNum].InputTeach);
  sequence[seqNum].Motor = (double *)calloc(ActN*seqLength,sizeof(double));
  sequence[seqNum].MotorU = (double *)calloc(ActN*seqLength,sizeof(double));
  sequence[seqNum].MotorDL = (double *)calloc(ActN*seqLength,sizeof(double));
  sequence[seqNum].MotorMix = (double *)calloc(ActN*seqLength,sizeof(double));
  sequence[seqNum].PlanEnergy = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].ContIn = (double *)calloc(ContN*seqLength,sizeof(double));
  sequence[seqNum].ContInU = (double *)calloc(ContN*seqLength,sizeof(double));
  sequence[seqNum].Hidden = (double *)calloc(HiddenN*seqLength,sizeof(double));
  sequence[seqNum].Output = (double *)calloc(OutN*seqLength,sizeof(double));
  sequence[seqNum].OutputU = (double *)calloc(OutN*seqLength,sizeof(double));
  sequence[seqNum].OutputTeach = (double *)calloc(OutN*seqLength,sizeof(double));
  sequence[seqNum].ContOut = (double *)calloc(ContN*seqLength,sizeof(double));
  sequence[seqNum].InDel = (double *)calloc(InN*seqLength,sizeof(double));
  sequence[seqNum].ContInDel = (double *)calloc(ContN*seqLength,sizeof(double));   
  sequence[seqNum].HiddenDel = (double *)calloc(HiddenN*seqLength,sizeof(double));
  sequence[seqNum].OutDel = (double *)calloc(OutN*seqLength,sizeof(double));   
  sequence[seqNum].ContOutDel = (double *)calloc(ContN*seqLength,sizeof(double));	  
  sequence[seqNum].InEr = (double *)calloc(InN*seqLength,sizeof(double));    
  sequence[seqNum].ContInEr = (double *)calloc(ContN*seqLength,sizeof(double));	      		
  sequence[seqNum].HiddenEr = (double *)calloc(HiddenN*seqLength,sizeof(double));	  
  sequence[seqNum].OutEr = (double *)calloc(OutN*seqLength,sizeof(double));   	  
  sequence[seqNum].ContOutEr = (double *)calloc(ContN*seqLength,sizeof(double));
  sequence[seqNum].dInitCont = (double *)calloc(ContN*seqLength,sizeof(double)); 
  sequence[seqNum].dlInitCont = (double *)calloc(ContN*seqLength,sizeof(double));
  sequence[seqNum].Tss = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].TssAve = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].TssExp = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].ActError = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].DelayReward = (double
								  *)calloc(seqLength,sizeof(double));

  sequence[seqNum].InputAve = (double *)calloc(InN*seqLength,sizeof(double));
  sequence[seqNum].ContInAve = (double *)calloc(ContN*seqLength,sizeof(double));

  sequence[seqNum].Para = (double *)calloc(FS_N*seqLength,sizeof(double));
  sequence[seqNum].ParaEr = (double *)calloc(FS_N*seqLength,sizeof(double));
  sequence[seqNum].ParaDel = (double *)calloc(FS_N*seqLength,sizeof(double));
  sequence[seqNum].FS = (double
						 *)calloc(seqLength*FS_N,sizeof(double));
  sequence[seqNum].dFS = (double
						  *)calloc(seqLength*FS_N,sizeof(double));
  sequence[seqNum].dlFS = (double *)calloc(seqLength*FS_N,sizeof(double));
  sequence[seqNum].dFSr = (double *)calloc(seqLength*FS_N,sizeof(double));

  sequence[seqNum].GPost = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].Gate = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].Sgate = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].DSgate = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].Sigma = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].GatePred = (double *)calloc(seqLength,sizeof(double));
  sequence[seqNum].OutputMix = (double *)calloc(OutN*seqLength,sizeof(double));
}

/* --
   free all trainSeq of net
   -- */
FreeTrainSeq(net)
	 struct NET *net;
{
  int seq_i;
  setNetGlobal(net);
  for (seq_i=0; seq_i<net->MaxTrainSeqS; ++seq_i) {
	FreeSequence(net->trainSeqS, seq_i, net);
  }
}

FreeSequence(sequence,seqNum,net)
	 struct SequenceRecord *sequence; 
	 int seqNum;
	 struct NET *net;
{
  setNetGlobal(net);
  free(sequence[seqNum].PredictError);
  free(sequence[seqNum].PredictErrorInteg);
  free(sequence[seqNum].Input);
  free(sequence[seqNum].InputTeach);
  free(sequence[seqNum].Motor);
  free(sequence[seqNum].MotorU);
  free(sequence[seqNum].MotorDL);
  free(sequence[seqNum].MotorMix);
  free(sequence[seqNum].PlanEnergy);
  free(sequence[seqNum].ContIn);
  free(sequence[seqNum].ContInU);
  free(sequence[seqNum].Hidden);
  free(sequence[seqNum].Output);
  free(sequence[seqNum].OutputU);
  free(sequence[seqNum].OutputTeach);
  free(sequence[seqNum].ContOut);
  free(sequence[seqNum].InDel);
  free(sequence[seqNum].ContInDel);   
  free(sequence[seqNum].HiddenDel);
  free(sequence[seqNum].OutDel);   
  free(sequence[seqNum].ContOutDel);	  
  free(sequence[seqNum].InEr);    
  free(sequence[seqNum].ContInEr);	      		
  free(sequence[seqNum].HiddenEr);	  
  free(sequence[seqNum].OutEr);   	  
  free(sequence[seqNum].ContOutEr);
  free(sequence[seqNum].dInitCont); 
  free(sequence[seqNum].dlInitCont);
  free(sequence[seqNum].Tss);
  free(sequence[seqNum].TssAve);
  free(sequence[seqNum].TssExp);
  free(sequence[seqNum].ActError);
  free(sequence[seqNum].DelayReward);

  free(sequence[seqNum].InputAve);
  free(sequence[seqNum].ContInAve);

  free(sequence[seqNum].Para);
  free(sequence[seqNum].ParaEr);
  free(sequence[seqNum].ParaDel);
  free(sequence[seqNum].FS);
  free(sequence[seqNum].dFS);
  free(sequence[seqNum].dlFS);
  free(sequence[seqNum].dFSr);
}


CopyActTeach(net,seq,maxSteps)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int maxSteps;
{
  int step, i;
  setNetGlobal(net);
  for (step=0;step<maxSteps; ++step) {
	for (i=0;i<InN;++i) {
	  *(seq->InputTeach+InN*step+i)= *(seq->Input+InN*step+i); }
	for (i=0;i<OutN;++i) {
	  *(seq->OutputTeach+OutN*step+i)= *(seq->Output+OutN*step+i);
	} }
}

CopySeq(seqA,seqB,net)
	 struct SequenceRecord *seqA, *seqB;
	 struct NET *net;
{
  int maxSteps, step, i, j;

  setNetGlobal(net);
  seqB->steps = seqA->steps;
  maxSteps = seqB->steps;
  seqB->TssExpSum = seqA->TssExpSum;    
  for (step=0;step<maxSteps; ++step) {
	*(seqB->PredictError+step) = *(seqA->PredictError+step);
	*(seqB->PredictErrorInteg+step) = *(seqA->PredictErrorInteg+step);
	*(seqB->PlanEnergy+step) = *(seqA->PlanEnergy+step);
	*(seqB->Tss+step) = *(seqA->Tss+step);
	*(seqB->TssAve+step) = *(seqA->TssAve+step);
	*(seqB->TssExp+step) = *(seqA->TssExp+step);
	*(seqB->ActError+step) = *(seqA->ActError+step);
	*(seqB->DelayReward+step) = *(seqA->DelayReward+step);
	*(seqB->GPost+step) = *(seqA->GPost+step);
	*(seqB->Gate+step) = *(seqA->Gate+step);
	*(seqB->Sgate+step) = *(seqA->Sgate+step);
	*(seqB->DSgate+step) = *(seqA->DSgate+step);
	*(seqB->Sigma+step) = *(seqA->Sigma+step);
	*(seqB->GatePred+step) = *(seqA->GatePred+step);
  }

  for (step=0;step<maxSteps; ++step) {
	for (i=0;i<InN;++i) {
	  *(seqB->Input+InN*step+i)= *(seqA->Input+InN*step+i);
	  *(seqB->InputAve+InN*step+i)= *(seqA->InputAve+InN*step+i);
	  *(seqB->InputTeach+InN*step+i)= *(seqA->InputTeach+InN*step+i);
	  *(seqB->InDel+InN*step+i)= *(seqA->InDel+InN*step+i);
	}
	for (i=0;i<ActN;++i) {
	  *(seqB->Motor+ActN*step+i)= *(seqA->Motor+ActN*step+i);
	  *(seqB->MotorU+ActN*step+i)= *(seqA->MotorU+ActN*step+i);
	  *(seqB->MotorDL+ActN*step+i)= *(seqA->MotorDL+ActN*step+i);
	  *(seqB->MotorMix+ActN*step+i)= *(seqA->MotorMix+ActN*step+i);
	} 
	for (i=0;i<ContN;++i) {
	  *(seqB->ContIn+ContN*step+i)= *(seqA->ContIn+ContN*step+i);
	  *(seqB->ContInAve+ContN*step+i)= *(seqA->ContInAve+ContN*step+i);
	  *(seqB->ContInU+ContN*step+i)= *(seqA->ContInU+ContN*step+i);
	  *(seqB->ContInDel+ContN*step+i)= *(seqA->ContInDel+ContN*step+i);
	  *(seqB->ContOut+ContN*step+i)= *(seqA->ContOut+ContN*step+i);
	  *(seqB->ContOutDel+ContN*step+i)= *(seqA->ContOutDel+ContN*step+i);
	  *(seqB->dInitCont+ContN*step+i)= *(seqA->dInitCont+ContN*step+i);
	  *(seqB->dlInitCont+ContN*step+i)= *(seqA->dlInitCont+ContN*step+i);
	}
	for (i=0;i<HiddenN;++i) {
	  *(seqB->Hidden+HiddenN*step+i)= *(seqA->Hidden+HiddenN*step+i);
	  *(seqB->HiddenDel+HiddenN*step+i)= *(seqA->HiddenDel+HiddenN*step+i);
	}
	for (i=0;i<OutN;++i) {
	  *(seqB->Output+OutN*step+i)= *(seqA->Output+OutN*step+i);
	  *(seqB->OutputU+OutN*step+i)= *(seqA->OutputU+OutN*step+i);
	  *(seqB->OutDel+OutN*step+i)= *(seqA->OutDel+OutN*step+i);
	  *(seqB->OutputTeach+OutN*step+i)= *(seqA->OutputTeach+OutN*step+i);
	  *(seqB->OutputMix+OutN*step+i)= *(seqA->OutputMix+OutN*step+i);
	}
	for (i=0;i<FS_N;++i) {
	  *(seqB->FS+FS_N*step+1) = *(seqB->FS+FS_N*step+1);
	  *(seqB->dFS+FS_N*step+1) = *(seqB->dFS+FS_N*step+1);
	  *(seqB->dlFS+FS_N*step+1) = *(seqB->dlFS+FS_N*step+1);
	  *(seqB->dFSr+FS_N*step+1) = *(seqB->dFSr+FS_N*step+1);
	  *(seqB->Para+FS_N*step+1) = *(seqB->Para+FS_N*step+1);
	  *(seqB->ParaEr+FS_N*step+1) = *(seqB->ParaEr+FS_N*step+1);
	  *(seqB->ParaDel+FS_N*step+1) = *(seqB->ParaDel+FS_N*step+1);
	}
  }
}

ModifFS(bw, dbw, dlbw, low, high) 
	 double *bw, *dbw, *dlbw, low, high;
{
  *dlbw = epsi_fs * (*dbw) + momentum_fs  * (*dlbw);
  *bw += *dlbw;
  /*
   *dbw = 0.0;  # have been initialized in putInOutTch #
   */
  if (*bw < low)
	*bw = low;
  else if (*bw > high)
	*bw = high;
  else;
}


/* --
   take difference between outTch and inch and put into outTch
   -- */
difOutTch(seq,dscale)
     struct SequenceRecord *seq;
     double dscale;
{
  int step, i;    
  for (step=0;step<seq->steps;++step) {
	double *inTch, *outTch;
	inTch = seq->InputTeach+InN*step;
	outTch = seq->OutputTeach+OutN*step;
	for (i=0;i<InN;++i) {
	  *(outTch+i) = deltaScale(*(outTch+i),*(inTch+i),dscale);	    
	  //fprintf(stderr,"%f ",*(outTch+i)); 
	}
  }
}

/* ----------------------------------------------
   Read training pattern from files and put into seq for 
   a specified net. (if there exists maxNets, ReadPattern() is repeated 
   for maxNets times.)
   seq array is allocated for patterns.
   DelayReward is computed for each step.

   Format of file is as follows...
   num_in, num_out
   No. patterns
   No. patterns
   -1 (end of a seq)
   No. patterns
   No. patterns
   -1 
   ReadPattern()/
   ---------------------------------------------- */

ReadPattern(filestr,net)
	 FILE *filestr;
	 struct NET *net;
{
  int i,j,k,hoge;
  double value, hogeD;
  int seqStep = 0;
  int seqNum = 0, ct;
  int inN, outN; /* this is only used for reading file */

  setNetGlobal(net); /* global as like pointer w21 are set to each net */
  fscanf(filestr, "%d", &inN); /* inN and outN only used for reading file */
  fscanf(filestr, "%d", &outN);
  fprintf(stderr,"\nReadPattern inN %d outN %d ",inN,outN);
  AllTrainSteps = 0;

  /* read file once to allocate for MaxTrainSeq */
  while (fscanf(filestr, "%d", &ct) != EOF)
	{
	  if (ct > -1) /* end of a seq */
		{
		  for (i=0; i<inN; ++i)
			fscanf(filestr,"%lf",&value);
		  for (i=0; i<outN; ++i)
			fscanf(filestr,"%lf",&value);
		  seqStep += 1;
		}
	  else
		{
		  /* allocate memory for training for each seq */
		  seqStep = 0;
		  ++ seqNum;
		}
	}
  MaxTrainSeq = seqNum;
  net->MaxTrainSeqS = MaxTrainSeq;

  net->trainSeqS = (struct SequenceRecord *)calloc(MaxTrainSeq,
												   sizeof(struct SequenceRecord));
  fprintf(stderr,"MaxTrainSeq%d ",MaxTrainSeq);
  fprintf(stderr,"net->trainSeqS %d ",net->trainSeqS);
  /* allocate each sequence */
  rewind(filestr);    
  fscanf(filestr, "%d", &hoge);
  fscanf(filestr, "%d", &hoge);
  seqStep = 0;
  seqNum = 0;
  while (fscanf(filestr, "%d", &ct) != EOF)
	{
	  if (ct > -1) /* end of a seq */
		{
		  for (i=0; i<inN; ++i)
			fscanf(filestr,"%lf",&value);
		  for (i=0; i<outN; ++i)
			fscanf(filestr,"%lf",&value);
		  seqStep += 1;
		}
	  else
		{
		  /* allocate memory for training for each seq */
		  AllocSequence(net->trainSeqS,seqStep,seqNum,net);
		  fprintf(stderr,"\nseq_i%d steps%d ",seqNum,seqStep);
		  AllTrainSteps += seqStep;
		  seqStep = 0;
		  ++ seqNum;
		}
	}
	
  /* read in/out data */
  rewind(filestr);    
  fscanf(filestr, "%d", &hoge);
  fscanf(filestr, "%d", &hoge);
  seqStep = 0;
  seqNum = 0;
  fprintf(stderr,"net->trainSeqS->Tch%d ",(net->trainSeqS+seqNum)->InputTeach);
  fprintf(stderr,"TrainSeq.Tch%d ",TrainSeq[seqNum].InputTeach);
  while (fscanf(filestr, "%d", &ct) != EOF)
	{

	  if (ct > -1) /* read a seq */
		{
		  for (i=0; i<inN; ++i) {
			fscanf(filestr,"%lf",
			       TrainSeq[seqNum].InputTeach+InN*seqStep+i);
			*(TrainSeq[seqNum].InputTeach+InN*seqStep+i) = pscale * (*(TrainSeq[seqNum].InputTeach+InN*seqStep+i)-0.5)+0.5;}
		  for (i=0; i<outN; ++i) {
			fscanf(filestr,"%lf",
			       TrainSeq[seqNum].OutputTeach+OutN*seqStep+i);
			*(TrainSeq[seqNum].OutputTeach+OutN*seqStep+i) = pscale * (*(TrainSeq[seqNum].OutputTeach+OutN*seqStep+i)-0.5)+0.5;}
		  seqStep += 1;
		}
	  else /* delimiter of one seq: seqStep in initialized and seqNum is increment */
		{
		  seqStep = 0;
		  ++ seqNum;
		}
	}
  fprintf(stderr,"\n=>MaxTrainSeq %d\n",MaxTrainSeq);
}

/* --
   compt delayed rewards for each step of specified seq of net.
   During the robot run, the reawrd is stored in the last of Sense output teach
   as from 0.0 to 1.0.
   DelayReward is set from -1.0 to 1.0 as limited range.
   dr from 0 to maxStep-2 is computed based on received reward.
   dr[maxStep-1] is set as 0.
   -- */
ComptDelayReward(seq,net)
	 struct SequenceRecord *seq;
	 struct Net *net;
{
  int istep, iistep, maxSteps;
  double *dr;
  setNetGlobal(net);
  maxSteps = seq->steps;
  dr = seq->DelayReward;

  for (istep=maxSteps-1; istep>=0; --istep) 
	dr[istep] = 0.0;

  for (istep=maxSteps-1; istep>=0; --istep) {
	double rw0, rw;
	rw0 = *(seq->OutputTeach+(istep)*OutN+SenseN-1); /* rewards are 0.0 - 1.0 in the last 
														of Sense input vector */
	rw = (rw0-0.5)*2;
	if (rw != 0.0) /* if rewards */ {
	  for (iistep=istep; iistep>=0; --iistep) {
		dr[iistep] += rw; /* decayed sum */
		rw = rw*decayR;
	  }
	}
  }
  /* limitter */
  printf("ComptDelay\n"); 
  for (istep=maxSteps-1; istep>=0; --istep) {
	if (dr[istep]>1.0) dr[istep]=1.0;
	else if (dr[istep]<-1.0) dr[istep] = -1.0;
	else;
  }
  /*
    fprintf(stderr,"\n");
    for (istep=0; istep<=maxSteps; ++istep)
	fprintf(stderr,"#%d rw%f dr%f, ",istep,*(seq->OutputTeach+istep*OutN+SenseN-1),dr[istep]);
  */
}

/* --
   rehearse from init_seq before end_seq.
     Closed plan for motor seqence
     Disctize motor action of branching
     compt delay reward from predicted reward in forward prediction
     -- */
RehearseNet(net,aseq,init_seq,end_seq)
	 struct NET *net;
	 struct SequenceRecord *aseq;
	 int init_seq, end_seq;
{
  struct SequenceRecord *seq;
  int seq_i, step, termStep, hoge;
  for (seq_i=init_seq; seq_i<end_seq; ++seq_i) {
	fprintf(stderr,"\nseq_i=%d ",seq_i);
	for (step=0; step<250; ++step) { /* usual noise control */
	  ClosedPlan(net,aseq+seq_i,0,maxPlanSteps,&termStep,HIGH,seq_i,-1.0);
	  SetInitMotorZero(aseq+seq_i); }
	for (step=0; step<50; ++step) {  /* noise zero to converge */
	  ClosedPlan(net,aseq+seq_i,0,maxPlanSteps,&termStep,HIGH,seq_i,0.0);
	  SetInitMotorZero(aseq+seq_i); }
	for (step=0; step<1; ++step) {  /* disctize motor plan */
	  DisctizeMotor(net,aseq+seq_i,0,maxPlanSteps,&termStep,HIGH,seq_i);
	  SetInitMotorZero(aseq+seq_i); 
	  ClosedMultiplePlanBP(net,aseq+seq_i,0,termStep+1);
	  InitDeltaWeight(); /* init dw and db */
	}
	(aseq+seq_i)->steps = termStep+1;
	fprintf(stderr,"termStep=%d ",termStep);
	PrintInOut(aseq+seq_i,0,(aseq+seq_i)->steps);
	CopyActTeach(net,aseq+seq_i,maxPlanSteps); 
	ComptDelayReward(aseq+seq_i, net); /* reward computation using 
										  rehearsed out put of reward 
										  prediction */
  }
}

/* --
   print into ref.dat.
   cSeq_i, maxReh, bitID[0], PlanEnergy[0], .... bitID[maxReh-1], PlanEnergy[maxReh-1]
   -- */
StatusRehearseSeq(net,aseq,maxReh,cSeq_i,fileptr)
	 struct NET *net;
	 struct SequenceRecord *aseq;
	 int maxReh, cSeq_i;
	 FILE *fileptr;
{
  int seq_i, step, i, j;
  int pbits[20],bitID;
  fprintf(fileptr,"%d %d\t",cSeq_i,maxReh);
  for (seq_i=0; seq_i<maxReh; ++seq_i) {
	/* compt plan bits */
	for (step=0; step<maxPlanBits; ++step)
	  pbits[step] = 0;
	for (step=1; step<(aseq+seq_i)->steps; ++step)
	  pbits[step-1] = (int) *((aseq+seq_i)->Motor+step*ActN);
	bitID = transBitsInv(pbits,maxPlanBits);
	fprintf(fileptr,"%d %f ",bitID,*((aseq+seq_i)->PlanEnergy+0));
  }
  fprintf(fileptr,"\n");
}

/* --
   cSeq_i,bitID,aveReward
   -- */
StatusActSeq(net,tseq,cSeq_i,fileptr)
	 struct NET *net;
	 struct SequenceRecord *tseq;
	 int cSeq_i;
	 FILE *fileptr;
{
  int pbits[20],bitID;
  int step;
  double sumReward=0.0;
  fprintf(stderr,"steps %d ",tseq->steps);
  for (step=0; step<tseq->steps; ++step) {
	sumReward += *(tseq->OutputTeach+step*OutN+SenseN-1);
	fprintf(stderr,"sum %f ",sumReward);}
  for (step=0; step<maxPlanBits; ++step)
	pbits[step] = 0;
  for (step=1; step<tseq->steps; ++step) {
	pbits[step-1] = (int) *(tseq->Motor+step*ActN);
	fprintf(stderr,"%d ",pbits[step-1]); }
  bitID = transBitsInv(pbits,maxPlanBits);
  fprintf(stderr,"bitID %d ",bitID);
  fprintf(fileptr,"%d %d %f\n",cSeq_i,bitID,sumReward/(tseq->steps));
}
	
int transBitsInv(bit,num)
	 int *bit, num;
{
  int i, j, ans=0;
  for (i=0; i<num; ++i) {
	ans += ((int) pow(2.0,(double)(num-i-1))) * bit[i];
  }
  return (ans);
}
    

SetInitMotorZero(seq)
	 struct SequenceRecord *seq;
{
  int i, j;
  for (i=0;i<ActN;++i) {
	*(seq->Motor+i)= 0.0;
	*(seq->Input+SenseN+i) = 0.0;
  }
}

/* -------------------------------------
   Mental Plan: initStep to termStep
   predict output from initStep to endStep-1
   update motor from initStep to termStep
   if cSeq_i == 0 then random action selection.
   ------------------------------------- */
ClosedPlan(net,seq,initStep,endStep,termStep,level,cSeq_i,mnTmp)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep,*termStep;
	 int level, cSeq_i;
	 double mnTmp; /* positive value replace mn which has been obtained */
	 /* from noise control */
{    
  int i;
  ClosedMultiplePlanFact(net,seq,initStep,endStep);
  /* PrintInOut(seq,initStep,endStep); */
  ComptTerm(net,seq,initStep,endStep,termStep); /* look at reward[termStep] */
  ComptEnergy(net,seq,initStep,*termStep+1,HIGH); 
  PlanNoiseControl();
  if (mnTmp>=0.0) {
	mn = mnTmp; /* in rehearse, in order to converge dynamics */
  }
  ClosedMultiplePlanBP(net,seq,initStep,*termStep+1);
  InitDeltaWeight(); /* init dw and db */
  UpdateMotorPlan(net,seq,initStep,*termStep+1,level,cSeq_i);
}

DisctizeMotor(net,seq,initStep,endStep,termStep,level,cSeq_i)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep,*termStep;
	 int level, cSeq_i;
{    
  int i, step;
  ClosedMultiplePlanFact(net,seq,initStep,endStep);
  ComptTerm(net,seq,initStep,endStep,termStep); /* look at reward[termStep] */
  ComptEnergy(net,seq,initStep,*termStep+1,HIGH); 
  ClosedMultiplePlanBP(net,seq,initStep,*termStep+1);
  InitDeltaWeight(); /* init dw and db */
  UpdateMotorPlan(net,seq,initStep,*termStep+1,level,cSeq_i);
  for (step=1; step<endStep; ++step) {
	for (i=0; i<ActN; ++i) {
	  /* disctize motor seq */
	  if (*(seq->Motor+ActN*step+i)>0.5) {
		*(seq->Motor+ActN*step+i)=1.0;}
	  else {
		*(seq->Motor+ActN*step+i)=0.0; }
	  /* copy motor seq to motor pred output */
	  *(seq->Output+OutN*(step-1)+SenseN+i)= *(seq->Motor+ActN*step+i);
	  *(seq->OutputTeach+OutN*(step-1)+SenseN+i)= *(seq->Motor+ActN*step+i);
	}}
}

/* --
   compt energy only by reward
   Motor: from initStep to endStep-1
   Reward out: from initStep to endStep-1
   -- */
ComptEnergy(net,seq,initStep,endStep,level)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep, endStep;
	 int level;
{
  int step, istep, i, minStep;
  double minEne=0.0;
  double *in,*motor,*out,*planEne;

  GlPlanEnergy = 0.0;
  minStep = initStep;
  for (step=initStep; step<endStep; ++step) {
	double *act, *actPrev, *actPred, *reward;

	motor = seq ->Motor + step*ActN;
	out = seq -> Output + step*OutN;
	act = motor;
	actPrev = motor-ActN;
	actPred = out+SenseN; /* action predicted in the previous step */
	reward = out+SenseN-1;

	GlPlanEnergy += mr1 * (*reward - 0.5) * pow(decayR,(double)(step-initStep));

	/* increment forward adress */
	motor += ActN;
	out += OutN;
	
  }
  *(seq->PlanEnergy+initStep) = GlPlanEnergy;
  /* fprintf(stderr,"[%d %d %lf] ",initStep,endStep,GlPlanEnergy); */
}

ComptEnergyOld(net,seq,initStep,endStep,level)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep, endStep;
	 int level;
{
  int step, istep, i, minStep;
  double minEne=0.0;
  double *in,*motor,*out,*planEne;

  GlPlanEnergy = 0.0;
  minStep = initStep;
  for (step=initStep; step<endStep; ++step) {
	double *act, *actPrev, *actPred, *reward;

	motor = seq ->Motor + step*ActN;
	out = seq -> Output + step*OutN;
	act = motor;
	actPrev = motor-ActN;
	actPred = out+SenseN; /* action predicted in the previous step */
	reward = out+SenseN-1;
	for (i=0; i<ActN; ++i) {
	  /*
		ene += -ms*(act[i]-0.5)*(act[i]-0.5)*0.5+
		mp*(actPred[i]-act[i])*(actPred[i]-act[i])*mPerturb*0.5;		
	  */
	  GlPlanEnergy += ms1*(1.0-act[i])*act[i];
	} 
	GlPlanEnergy += -mr1*((*reward)*(*reward)-0.5*0.5);

	/* increment forward adress */
	motor += ActN;
	out += OutN;
	
  }

  /* fprintf(stderr,"[%d %d %lf] ",initStep,endStep,GlPlanEnergy); */
}

PlanNoiseControl()
{
  mn = mn0 - GlPlanEnergy * mnk;
  if (mn < 0.0) mn = 0.0;
}

/* --
   looking at prediction of terminal as out[0->OutN-3].
   Motor: from initStep+1 to endStep-1
   -- */
ComptTerm(net,seq,initStep,endStep,termStep,level)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep,*termStep;
	 int level;
{
  int step, istep, i, minStep;
  double glEnergy=0.0, minEne=0.0;
  double *in,*motor,*out,*planEne;

  for (step=initStep-1; step<endStep-1; ++step) {
	double *act, *actPrev, *actPred, *reward, ene=0.0;
	int termFlag=1;
	
	out = seq -> Output + step*OutN;
	/* check if all sense pred except reward is positive */
	for (i=0; i<OutN-2; ++i) { 
	  if (*(out+i) < 0.5)
	    termFlag = 0;
	}
	if (termFlag == 1) { /* if termination is predicted */
	  *termStep=step;
	  step = endStep-1; }
	else {
	  *termStep = step;
	}
	out += OutN;
  } /* end step iteration */
}

/* --
   looking at reward[termStep] as less than 02 or more than 0.8
   Motor: from initStep+1 to endStep-1
   -- */
ComptTermOld(net,seq,initStep,endStep,termStep,level)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep,*termStep;
	 int level;
{
  int step, istep, i, minStep, termflag=0;
  double glEnergy=0.0, minEne=0.0;
  double *in,*motor,*out,*planEne;

  minStep = initStep;
  for (step=initStep; step<endStep-1; ++step) {
	double *act, *actPrev, *actPred, *reward, ene=0.0;

	motor = seq ->Motor + (step+1)*ActN;
	out = seq -> Output + step*OutN;
	planEne = seq->PlanEnergy+step;
	act = motor;
	actPrev = motor-ActN;
	actPred = out+SenseN; /* action predicted in the previous step */
	reward = out+SenseN-1;
	if (*reward > 0.66) {
	  termflag=1;
	  *termStep=step;
	  step = endStep-1; }
	else if (*reward < 0.33) {
	  termflag= (-1);
	  *termStep=step;
	  step = endStep-1; }
	else {
	  *termStep = step;
	}

	motor += ActN;
	out += OutN;
	planEne += 1;
  } /* end step iteration */
}

/* --
   UpdateMotorPlan: update motor from initStep to endStep-1
   -- */
updateMotor(net,seq,initStep,endStep)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep;
{
  int step,i,j,maxSteps;
  double *motor,*motorU,*motorDL,*inD,*in, *inTch;    

  motor = seq ->Motor + (initStep)*ActN;
  motorU = seq ->MotorU + (initStep)*ActN;
  motorDL = seq ->MotorDL + (initStep)*ActN;
  inD = seq -> InDel + (initStep)*InN; 
  in  = seq -> Input + (initStep)*InN; 
  inTch  = seq -> InputTeach + (initStep)*InN; 

  for (step=initStep; step<endStep; ++step) {
	for (i=0;i<ActN;++i) {
	  double uDelta;
	  if (step>0) {
		uDelta = *(motorU+i-ActN)-*(motorU+i); }
	  else {uDelta=0.0; }
	  /*
	    if (EFlag0 && EFlag1 && i==0) {
		fprintf(stderr,"\n%d m%f u%f inD%f DL%f inTch%f in%f uD%f ",
		step,*motor,*motorU,*(inD+SenseN),*motorDL,*inTch,*in,uDelta); }
	  */
	  *(motorDL+i) = epsi_plan * (*(inD+SenseN+i)+epsi_u*uDelta) 
		+ momentum_plan * (*(motorDL+i));
	  *(motorU+i) += *(motorDL+i);	    	
	  *(inD+SenseN+i)=0.0;
	  *(motor+i) = logistic(*(motorU+i));	    
	  *(in+SenseN+i)= *(motor+i);
	  *(inTch+SenseN+i)= *(motor+i);
	}
	motor += ActN;
	motorU += ActN;
	motorDL += ActN;
	inD += InN;
	in += InN;
	inTch += InN;
  }
}

/* --
   initialize motor and motorU according to inputTeach set in sequence
   -- */
setInputToMotor(net)
	 struct NET *net;
{
  int step,i,j,maxSteps,iseq;
  struct SequenceRecord *seq;
  int initStep,endStep;
  double *motor,*motorU,*motorDL,*inD,*in, *inTch, hoge;

  setNetGlobal(net);    
  for (iseq=0; iseq<net->MaxTrainSeqS; ++iseq) {
	seq = net->trainSeqS+iseq;
	endStep = seq->steps;
	initStep=0;
	for (step=initStep; step<endStep; ++step) {
	  for (i=0;i<ActN;++i) {
		double val;

		*(seq ->Motor+step*ActN+i) = 
		  *(seq->InputTeach+step*InN+SenseN+i);
		val = *(seq ->Motor+step*ActN+i);
		*(seq ->MotorU+step*ActN+i) = log(val/(1.0-val));		  
	  } } }
}
      
/* --
   UpdateMotorPlan: update motor from initStep to endStep-1
   -- */
UpdateMotorPlan(net,seq,initStep,endStep,level,cSeq_i)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep;
	 int level, cSeq_i;
{
  int step,i,j,maxSteps;
  double *in,*motor,*motorU,*motorDL,*inD,*out;

  motor = seq ->Motor + (initStep)*ActN;
  motorU = seq ->MotorU + (initStep)*ActN;
  motorDL = seq ->MotorDL + (initStep)*ActN;
  inD = seq -> InDel + (initStep)*InN; 
  out = seq -> Output + (initStep-1)*OutN;

  for (step=initStep; step<endStep; ++step) {
	double *act, *actU, *actPrev, *actPred, *actD, *actDelta;
	/* fprintf(stderr,"\n%d ",step); */
	if (level==LOW) {
	  act = motor;
	  actU = motorU;
	  actPrev = motor-ActN;
	  actPred = out+SenseN; /* action predicted in the previous step */
	  actD = inD+SenseN; /* bp pressure for predicted reward */
	  actDelta = motorDL; /* delta change of motor input */
	  for (i=0; i<ActN; ++i) {
		double force;

		/* perturbation on predicted action */
		force = ms*(actPrev[i]-act[i])+mp*(actPred[i]-act[i])+mr*actD[i];
		actDelta[i] = epsiM*force + momentumM*actDelta[i];
		act[i] += actDelta[i]; 
	  } 
	}
	else {/* higher level: this is used in rmServe2 actually. */
	  act = motor;
	  actU = motorU;
	  actPrev = motor-ActN;
	  actPred = out+SenseN; /* action predicted in the previous step */
	  actD = inD+SenseN; /* bp pressure for predicted reward */
	  actDelta = motorDL; /* delta change of motor input */
	  for (i=0; i<ActN; ++i) {
		double force, noise, predF, vectorS, vectorP;
		noise = gasdec();
		/* parameters 
		   ms: make 0.0 or 1.0 
		   mp: action preference by RL
		   mn: noise
		   mr: delta by inverse dynamics by Model
		*/
		vectorP = actPred[i]-0.5;
		force = mp*(actPred[i]-0.5)+mr*actD[i]-ms*actU[i]+mn*noise;
		actDelta[i] = epsiM*force + momentumM*actDelta[i];
		actU[i] += actDelta[i]; 
		/*
		  fprintf(stderr,"\n#%d u%5.2f ap%5.2f del%f fr%f s%f p%f r%f n%f",step,actU[i],actPred[i],actDelta[i],force,-ms*actU[i],mp*(actPred[i]-0.5),mr*actD[i],mn*noise);
		*/
		act[i] = logistic(actU[i]);

	  } 
	}
	/* increment forward adress */
	motor += ActN;
	motorU += ActN;
	motorDL += ActN;
	inD += InN;
	out += OutN;
  }
}

UpdateMotorPlanOld(net,seq,initStep,endStep,level,cSeq_i)
	 struct NET *net;
	 struct SequenceRecord *seq;
	 int initStep,endStep;
	 int level, cSeq_i;
{
  int step,i,j,maxSteps;
  double *in,*motor,*motorU,*motorDL,*inD,*out;

  motor = seq ->Motor + (initStep)*ActN;
  motorU = seq ->MotorU + (initStep)*ActN;
  motorDL = seq ->MotorDL + (initStep)*ActN;
  inD = seq -> InDel + (initStep)*InN; 
  out = seq -> Output + (initStep-1)*OutN;

  for (step=initStep; step<endStep; ++step) {
	double *act, *actU, *actPrev, *actPred, *actD, *actDelta;
	/* fprintf(stderr,"\n%d ",step); */
	if (level==LOW) {
	  act = motor;
	  actU = motorU;
	  actPrev = motor-ActN;
	  actPred = out+SenseN; /* action predicted in the previous step */
	  actD = inD+SenseN; /* bp pressure for predicted reward */
	  actDelta = motorDL; /* delta change of motor input */
	  for (i=0; i<ActN; ++i) {
		double force;

		/* perturbation on predicted action */
		force = ms*(actPrev[i]-act[i])+mp*(actPred[i]-act[i])+mr*actD[i];
		actDelta[i] = epsiM*force + momentumM*actDelta[i];
		act[i] += actDelta[i]; 
	  } 
	}
	else {/* higher level: this is used actually. */
	  act = motor;
	  actU = motorU;
	  actPrev = motor-ActN;
	  actPred = out+SenseN; /* action predicted in the previous step */
	  actD = inD+SenseN; /* bp pressure for predicted reward */
	  actDelta = motorDL; /* delta change of motor input */
	  for (i=0; i<ActN; ++i) {
		double force, noise, predF, vectorS, vectorP;
		noise = gasdec();
		/* parameters 
		   ms: make 0.0 or 1.0 
		   mp: action preference by RL
		   mn: noise
		   mr: delta by inverse dynamics by Model
		*/
		
		if (actU[i] > 0.0 && actU[i] < 1.0)
		  vectorS = actU[i]-0.5;
		else if (actU[i] > 1.0)
		  vectorS = 1.0-actU[i];
		else if (actU[i] < 0.0)
		  vectorS = 0.0-actU[i];
		else;

		if (actU[i] > 0.0 && actU[i] < 1.0)
		  vectorP = actPred[i]-0.5;
		else vectorP = 0.0;

		force = ms*vectorS+mp*vectorP+mr*actD[i]+mn*noise;
		actDelta[i] = epsiM*force + momentumM*actDelta[i];
		actU[i] += actDelta[i]; 
		fprintf(stderr,"\n#%d a%5.2f ap%5.2f del%f fr%f s%f p%f r%f n%f",step,actU[i],actPred[i],actDelta[i],force,ms*vectorS,mp*vectorP,mr*actD[i],mn*noise);
		if (actU[i]>1.0) act[i] = 1.0;
		else if (actU[i]<0.0) act[i] = 0.0;
		else act[i] = actU[i];
	  } 
	}
	/* increment forward adress */
	motor += ActN;
	motorU += ActN;
	motorDL += ActN;
	inD += InN;
	out += OutN;
  }
  fprintf(stderr,"\n -- Ene%f mn%f ",GlPlanEnergy,mn);
  /*
    PrintInOut(seq,initStep,endStep);
  */
}

double SigSeki(x,T)
	 double x, T;
{
  double X, y1, y0;
  X = (x-0.5)/T;
  y1 = T*((1-logistic(X))*log(1-logistic(X))+(logistic(X)*log(logistic(X))));
  X = -0.5/T;
  y0 = T*((1-logistic(X))*log(1-logistic(X))+(logistic(X)*log(logistic(X))));
  return(y1-y0-(x*x)/2.0);
}


/* --
   forward plan: use motor program stored in InputTeach
   initStep->endStep-1
   -- */
ClosedMultiplePlanFact(net,seq,initStep,endStep)
     struct NET *net;
     struct SequenceRecord *seq;
     int initStep,endStep;
{
  int step,i,j,maxSteps;
  double *in,*inTeach,*ci,*hid,*out,*co,*outTeach,*motor;

  in = seq -> Input + initStep*InN;
  inTeach = seq ->InputTeach + initStep*InN;
  motor = seq ->Motor + initStep*ActN;
  ci = seq -> ContIn + initStep*ContN;
  hid = seq -> Hidden + initStep*HiddenN;
  out = seq -> Output + initStep*OutN;
  outTeach = seq -> OutputTeach + initStep*OutN;
  co = seq-> ContOut + initStep*ContN;
  for (i=SenseN; i<InN; ++i)
	*(in+i) = *(motor+i-SenseN); /* input motor command */

  /* multiple steps of Fact */
  for (step=initStep; step < endStep; ++step) {
	SingleForwardAct(in,ci,hid,out,co);

	/* input layer update */
	in += InN;
	inTeach += InN;
	motor += ActN;
	ci += ContN;

	/* input */
	for (i=0; i<SenseN; ++i) 
	  *(in+i) = *(out+i); /* feedback sensory prediction */ 
	for (i=SenseN; i<InN; ++i)
	  *(in+i) = *(motor+i-SenseN); /* input motor command */

	for (i=0; i<ContN; ++i)    /* context loop */
	  *(ci+i) = *(co+i);

	/* hidden and out layer update */
	hid += HiddenN;
	co += ContN;
	out += OutN;
	outTeach += OutN;
  }
}

/* ----------------------------------------
   Multiple Plan BP
   Back prop error of outTeach from endStep-1 to initStep
   plan Motor from initStep to endStep-1
   ---------------------------------------- */
ClosedMultiplePlanBP(net,seq,initStep,endStep)
     struct NET *net;
     struct SequenceRecord *seq; 
     int initStep, endStep;
{
  double *in, *ci, *hid,*out,*outTeach,*co,*inD,*ciD,*hidD,*outD,*coD,
	*inE,*ciE,*hidE,*outE,*coE,*tss,*tssAve,*dr,*para,*paraD,*paraE;
  int maxSteps, step, i, j;
    
  /* initialize */
  maxSteps = seq -> steps;
  in = seq -> Input + (endStep-1)*InN;
  ci = seq -> ContIn + (endStep-1)*ContN;
  hid = seq -> Hidden + (endStep-1)*HiddenN;
  out = seq -> Output + (endStep-1)*OutN;
  outTeach = seq -> OutputTeach + (endStep-1)*OutN;
  co = seq -> ContOut + (endStep-1)*ContN;
  inD = seq -> InDel + (endStep-1)*InN;
  ciD = seq -> ContInDel + (endStep-1)*ContN;
  hidD = seq -> HiddenDel + (endStep-1)*HiddenN;
  outD = seq -> OutDel + (endStep-1)*OutN;
  coD = seq -> ContOutDel + (endStep-1)*ContN;
  inE = seq -> InEr + (endStep-1)*InN;
  ciE = seq -> ContInEr + (endStep-1)*ContN;
  hidE = seq -> HiddenEr + (endStep-1)*HiddenN;
  outE = seq -> OutEr + (endStep-1)*OutN;
  coE = seq -> ContOutEr + (endStep-1)*ContN;
  tss = seq -> Tss + endStep - 1;
  tssAve = seq -> TssAve + endStep - 1;

  para = seq -> Para + (endStep-1)*FS_N;
  paraD = seq -> ParaDel + (endStep-1)*FS_N;
  paraE = seq -> ParaEr + (endStep-1)*FS_N;

  /* The delta of context units at the distal step is set as 0.0. */
  for (i=0; i<ContN; ++i)
	*(coD+i) = 0.0;

  /* multiple steps bptt from the distal step of the seq. */
  for (step = endStep-1; step >= initStep; --step)
	{
	  SinglePlanBp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,
				   inE,ciE,hidE,outE,coE,outTeach,step,
				   pow(decayR,(double)(step-initStep)),para,paraD,paraE);
	  net->errorS += *tss;

	  if (step > initStep)
		{ 
		  /* context feedback loop with decay */
		  coD -= ContN; 
		  for (i=0; i<ContN; ++i)
			*(coD+i) = *(ciD+i) * decay;
		  /* pointer one cycle unrolled. */
		  in -= InN;
		  ci -= ContN;
		
		  hid -= HiddenN;
		  hidE -= HiddenN;
		  out -= OutN;
		  co  -= ContN;
		  inD -= InN;
		  ciD -= ContN;
		  hidD -= HiddenN;
		  outD -= OutN;
		  inE -= InN;
		  ciE -= ContN; 
		  outE -= OutN;
		  coE -= ContN;
		  outTeach -= OutN;
		  tss -= 1;
		  tssAve -= 1;
		  dr -= 1;
		  para -= FS_N;
		  paraD -= FS_N;
		  paraE -= FS_N;
		}
	}
  /* initial context update vector */
  for (i=0; i < ContN; ++i)
	*(seq -> dInitCont + ContN*initStep + i) = *(ciD + i);
}

/* --
   Bp with reward in out[SenseN-1] to be maximized as 1.0.
   inD was computed for motor planning.
   -- */
double SinglePlanBp(in,ci,hid,out,co,inD,ciD,hidD,outD,coD,inE,ciE,hidE,outE,coE,
					outTeach,step,decay_r,para,paraD,paraE)
	 double *in,*ci,*hid,*out,*co,*inD,*ciD,*hidD,*outD,*coD,*inE,*ciE,*hidE,*outE,*coE,*outTeach;
	 int step;
	 double decay_r, *para, *paraD, *paraE;
{
  int i,j;
  double *weight, *dw, *db, hid_sum=0.0;
 

  /* Intialize error as 0.0 for each node */   

  for (i=0; i<InN; ++i)
	*(inE+i) = 0.0;
  for (i=0; i<FS_N; ++i)
	*(paraE+i) = 0.0;
  for (i=0; i<ContN; ++i)
	{
	  *(ciE+i) = 0.0;
	  *(coE+i) = 0.0;      }

  for (i=0; i<HiddenN; ++i)
	*(hidE+i) = 0.0;

  for (i=0; i<OutN; ++i)
	*(outE+i) = 0.0;
    
  /* Back prop context out to hidden layer */
  weight = w32 + HiddenN*(ContN+OutN); /* point the end of w32 */    
  dw = dw32 + HiddenN*(ContN+OutN);
  db = db3 + OutN + ContN;
    
  /*E printf("--   BP     --\n");*/
  /* delta for context out has been computed in coD */
  for (i=ContN-1; i>=0; --i)
	{
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(hidE+j) += *(coD+i) * (*weight);
		  *dw += *(coD+i) * (*(hid+j));
		  /*E printf("%lf ",*(coD+i) * (*(hid+j))); */
	    }
	  --db;	  
	  *db += *(coD+i);	  
	  /*E printf("%lf\n",*(coD+i));*/
	}
    
  /* Back prop from output to hidden layer */
  for (i=OutN-1; i>=0; --i)
	{
	  /* reward to be max */ 
	  if (i==SenseN-1) {
		*(outE+i) = (1.0 - *(out+i))*decay_r; 
		/*
	      fprintf(stderr,"outE %f out %f decay_r %f, ",*(outE+i),*(out+i),decay_r); 
		*/
	  }
	  else *(outE+i) = 0.0;
	  *(outD+i) = *(outE+i) * (*(out+i)) * (1.0 - *(out+i));
	  for (j=HiddenN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(hidE+j) += *(outD+i) * (*weight);
		  *dw += *(outD+i) * (*(hid+j));
		  /*E printf("%lf ",*(outD+i) * (*(hid+j)));*/
	    }
	  --db;	  
	  *db += *(outD+i);	  
	  /*E printf("%lf\n",*(outD+i));*/
	}
  /*E printf("\n"); */
  /* Back prop from hidden to input layer */
  weight = w21 + HiddenN*(ContN+FS_N+InN); /* point the end of w32 */    
  dw = dw21 + HiddenN*(ContN+FS_N+InN);
  db = db2 + HiddenN;

  for (i=HiddenN-1; i>=0; --i)
	{
	  *(hidD+i) = *(hidE+i) * (*(hid+i)) * (1.0 - *(hid+i));
	  for (j=ContN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(ciE+j) += *(hidD+i) * (*weight);
		  *dw += *(hidD+i) * (*(ci+j));
		  /*E printf("%lf ",*(hidD+i) * (*(ci+j)));*/
	    }
	  for (j=FS_N-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(paraE+j) += *(hidD+i) * (*weight);
		  *dw += *(hidD+i) * (*(para+j));
	    }
	  for (j=InN-1; j>=0; --j)
	    {
		  --weight;
		  --dw;		
		  *(inE+j) += *(hidD+i) * (*weight);
		  *dw += *(hidD+i) * (*(in+j));
		  /*E printf("%lf ",*(hidD+i) * (*(in+j)));*/
	    }
	  --db;	  
	  *db += *(hidD+i);	  
	  /*E printf("%lf\n",*(hidD+i)); */
	}
    
  /* delta computation for input layer */
  for (i=ContN-1; i>=0; --i)
	*(ciD+i) = *(ciE+i) * (*(ci+i)) * (1.0 - *(ci+i));  
  for (i=FS_N-1; i>=0; --i)
	*(paraD+i) = *(paraE+i) * (*(para+i)) * (1.0 - *(para+i));  
  for (i=InN-1; i>=0; --i) {
	*(inD+i) = *(inE+i) * (*(in+i)) * (1.0 - *(in+i));  
  }
  return(0.0);
}

RandMotor(seq,initStep)
	 struct SequenceRecord *seq;
	 int initStep;
{
  int step, i;
  double *motor, *motorU;
  motor = seq->Motor;
  motorU = seq->MotorU;
  fprintf(stderr,"initStep=%d ",initStep);
  for (step=initStep; step<MaxStepsInSeq; ++step) {
	for (i=0; i<ActN; ++i) {
	  *(motorU+ActN*step+i) = SetRandom(1.0);
	  *(motor+ActN*step+i) = logistic(*(motorU+ActN*step+i));
	  fprintf(stderr,"%5.2f ",*(motor+ActN*step+i)); }
  }
}

PrintInOut(tseq,initStep,endStep)
	 struct SequenceRecord *tseq;
	 int initStep, endStep;
{
  int step, i;

  for (step=0 /* initStep */; step<endStep; ++step) {
	fprintf(stderr,"\nstep %d\nIn  ",step);
	for (i=0; i<InN; ++i) {
	  fprintf(stderr,"%5.2f ",*(tseq->Input+InN*step+i)); }
	fprintf(stderr,"ci ");
	for (i=0; i<ContN; ++i) {
	  fprintf(stderr,"%5.2f ",*(tseq->ContIn+ContN*step+i)); }
	fprintf(stderr,"\nOut ");
	for (i=0; i<OutN; ++i) {
	  fprintf(stderr,"%5.2f ",*(tseq->Output+OutN*step+i)); }
	fprintf(stderr,"\nMo  ");
	for (i=0; i<ActN; ++i) {
	  fprintf(stderr,"%5.2f ",*(tseq->Motor+ActN*step+i)); }
  }
  fprintf(stderr,"\nGlPlanEnergy %5.2f ",GlPlanEnergy);
}
/* --
   print in file about current plan status when GetSensoryMotor in rmServePvm.
   input, output, ContIn, motor
   -- */
PrintInOutFile(tseq,initStep,cStep,endStep,seq_i,fileptr)
	 struct SequenceRecord *tseq;
	 int initStep, cStep, endStep, seq_i;
	 FILE *fileptr;
{
  int step, i;

  fprintf(fileptr,"\n\n%d %d %d %5.2f ",seq_i,cStep,endStep,GlPlanEnergy);
  for (step=initStep; step<endStep; ++step) {
	fprintf(fileptr,"\n%d\n",step);
	for (i=0; i<InN; ++i) {
	  fprintf(fileptr,"%5.2f ",*(tseq->Input+InN*step+i)); }
	fprintf(fileptr,"\n");
	for (i=0; i<OutN; ++i) {
	  fprintf(fileptr,"%5.2f ",*(tseq->Output+OutN*step+i)); }
	fprintf(fileptr,"\n");
	for (i=0; i<ContN; ++i) {
	  fprintf(fileptr,"%5.2f ",*(tseq->ContIn+ContN*step+i)); }
	fprintf(fileptr,"\n");
	for (i=0; i<ActN; ++i) {
	  fprintf(fileptr,"%5.2f ",*(tseq->Motor+ActN*step+i)); }
  }

}

/* --------------------------------------
   save activation sequence
   -------------------------------------- */
SaveTrainSequences(fileptr,net)
	 FILE *fileptr;
	 struct NET *net;
{
  int step, seq, i, j;
  setNetGlobal(net);
  for (seq=0; seq < MaxTrainSeq; ++seq)
	{
	  int MaxSteps;
	  MaxSteps = TrainSeq[seq].steps;
	  for (step=0; step<MaxSteps; ++step)
		{
		  fprintf(fileptr,"%d in ",step);
		  for (i=0; i<InN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].Input+step*InN+i));
		  fprintf(fileptr," ");
		  for (i=0; i<InN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].InputTeach+step*InN+i));
		  fprintf(fileptr," ci ");
		  for (i=0; i<ContN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].ContIn+step*ContN+i));
		  fprintf(fileptr," hid ");
		  for (i=0; i<HiddenN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].Hidden+step*HiddenN+i));
		  fprintf(fileptr," out ");
		  for (i=0; i<OutN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].Output+step*OutN+i));
		  fprintf(fileptr," ");
		  for (i=0; i<OutN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].OutputTeach+step*OutN+i));
		  fprintf(fileptr," co ");
		  for (i=0; i<ContN; ++i)
			fprintf(fileptr,"%6.3f ",*(TrainSeq[seq].ContOut+step*ContN+i));
		  fprintf(fileptr," ");
		  fprintf(fileptr,"\n");
		}
	  fprintf(fileptr,"-1\n");
	}
}

SaveSequences(fileptr,seqRec,maxSeq,net)
	 FILE *fileptr;
	 struct SequenceRecord *seqRec;
	 int maxSeq;
	 struct NET *net;
{
  int step, seq, i, j;

  setNetGlobal(net);
  for (seq=0; seq < maxSeq; ++seq)
	{
	  int MaxSteps;
	  MaxSteps = seqRec[seq].steps;
	  for (step=0; step<MaxSteps; ++step)
		{
		  fprintf(fileptr,"%d in ",step);
		  for (i=0; i<InN; ++i)
			fprintf(fileptr,"%6.3f ",*(seqRec[seq].Input+step*InN+i));
		  fprintf(fileptr," ");

		  fprintf(fileptr," out ");
		  for (i=0; i<OutN; ++i)
			fprintf(fileptr,"%6.3f ",*(seqRec[seq].Output+step*OutN+i));
		  fprintf(fileptr," ");
		  fprintf(fileptr,"\n");
		}
	  fprintf(fileptr,"-1\n");
	}
}


/* -------------------------------------
   Read weight file
   read structure, context of MaxTrainSeq, w21 b2, w32 b3

   ------------------------------------- */
ReadContWeight(weightstr,net)
	 FILE *weightstr;
	 struct NET *net;
{
  double *w_sub, *b_sub;
  int i, j, MaxSeq;

  setNetGlobal(net);

  fscanf(weightstr, "%d", &InN);
  fscanf(weightstr, "%d", &HiddenN);
  fscanf(weightstr, "%d", &OutN);
  fscanf(weightstr, "%d", &ContN);
  fscanf(weightstr, "%d", &MaxSeq);

  /* read context values for all seq */
  for(i = 0; i < MaxSeq; i ++){
	for(j = 0; j < ContN; j ++)
	  fscanf(weightstr, "%lf", TrainSeq[i].ContIn+j);
  }
  for(i = MaxSeq; i < MaxTrainSeq; i ++){
	for(j = 0; j < ContN; j ++)
	  *(TrainSeq[i].ContIn+j)=(SetRandom(1.0)+1.0)*0.5;
  }

  /* read weight and bias */
  w_sub = w21;
  b_sub = b2;
  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+ContN); j ++)
		fscanf(weightstr, "%lf", w_sub ++);
	  fscanf(weightstr, "%lf", b_sub ++);
	}

  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++)
		fscanf(weightstr, "%lf", w_sub ++);
	  fscanf(weightstr, "%lf", b_sub ++);
	}
}

ReadWeight(weightstr,net)
	 FILE *weightstr;
	 struct NET *net;
{
  double *w_sub, *b_sub, dHoge;
    
  int i, j, MaxSeq;

  setNetGlobal(net);

  fscanf(weightstr, "%d", &InN);
  fscanf(weightstr, "%d", &FS_N);
  fscanf(weightstr, "%d", &HiddenN);
  fscanf(weightstr, "%d", &OutN);
  fscanf(weightstr, "%d", &ContN);

  /* read weight and bias */
  w_sub = w21;
  b_sub = b2;
  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+FS_N+ContN); j ++)
		fscanf(weightstr, "%lf", w_sub ++);
	  fscanf(weightstr, "%lf", b_sub ++);
	}

  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++)
		fscanf(weightstr, "%lf", w_sub ++);
	  fscanf(weightstr, "%lf", b_sub ++);
	}
  /* read mse for each net */
  fscanf(weightstr,"%lf",&dHoge);
      
}

ReadWeightHirata(weightstr,net,w21,w32,b2,b3)
	 FILE *weightstr;
	 struct NET *net;
	 double *w21, *w32, *b2, *b3;
{
  double *w_sub, *b_sub, dHoge;
    
  int i, j, MaxSeq;

  setNetGlobal(net);

  fscanf(weightstr, "%d", &InN);
  fscanf(weightstr, "%d", &FS_N);
  fscanf(weightstr, "%d", &HiddenN);
  fscanf(weightstr, "%d", &OutN);
  fscanf(weightstr, "%d", &ContN);


  /* read weight and bias */
  w_sub = w21;
  b_sub = b2;
  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+FS_N+ContN); j ++)
		fscanf(weightstr, "%lf", w_sub ++);
	  fscanf(weightstr, "%lf", b_sub ++);
	}

  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++)
		fscanf(weightstr, "%lf", w_sub ++);
	  fscanf(weightstr, "%lf", b_sub ++);
	}
  /* read mse for each net */
  fscanf(weightstr,"%lf",&dHoge);
      
}


/* --------------------------------------
   save generated teach pattern
   -------------------------------------- */
SaveTeachPattern(teachSeq,seqNum,fileptr,net)
	 struct SequenceRecord *teachSeq;
	 int seqNum;
	 FILE *fileptr;
	 struct NET *net;
{
  int step, seq, i, j;

  setNetGlobal(net);
  printf("\nseqNum%d ",seqNum);
  fprintf(fileptr,"%d %d\n",InN,OutN);

  for (seq=0; seq < seqNum; ++seq) {
	int MaxSteps;
	MaxSteps = teachSeq[seq].steps;
	printf("\nMaxSteps %d ",MaxSteps);
	for (step=0; step<MaxSteps; ++step){
	  fprintf(fileptr,"%d\t",step);
	  for (j=0; j<InN; ++j)
		fprintf(fileptr,"%5.2f ",*(teachSeq[seq].InputTeach+step*InN+j));
	  fprintf(fileptr,"  ");
	  for (j=0; j<OutN; ++j)
		fprintf(fileptr,"%5.2f ",*(teachSeq[seq].OutputTeach+step*OutN+j));
	  fprintf(fileptr,"\n"); }
	fprintf(fileptr,"-1\n");
  }
}

/* --
   -- */
InputOutputReadPlot(tseq)
	 struct SequenceRecord *tseq;
{
  FILE *fileptr;
  char filename[128];
  int x0=10, y0=10, flag=1, cStep, seq_i;

  fprintf(stderr,"\nfilename: ");
  scanf("%s",filename);

  while(flag!=0) {
	printf("seq_i cStep ");
	scanf("%d%d",&seq_i,&cStep);
	fileptr = fopen(filename,"r");
	ReadInOutFilePlot(tseq,cStep,seq_i,fileptr,x0,y0);
	fclose(fileptr);
	y0 += 200;
	printf("0:stop 1:cont ");
	scanf("%d",&flag);
  }
}

/* --
   continues to read until find cStep and seq_i specified as arguments.
   And plot activation vector by step.
   -- */
ReadInOutFilePlot(tseq,cStep,seq_i,fileptr,x0,y0)
	 struct SequenceRecord *tseq;
	 int cStep, seq_i;
	 FILE *fileptr;
	 int x0, y0;
{
  int step, i, endStep, initStep=0;
  double GlPlanEnergy;
  int cStepF= -10, seq_iF= -10;

  while (cStepF!=cStep || seq_iF!=seq_i) {

	fscanf(fileptr,"%d%d%d%lf",&seq_iF,&cStepF,&endStep,&GlPlanEnergy);
	fprintf(stderr,"\n%d %d ",seq_iF,cStepF);
	for (step=initStep; step<endStep; ++step) {
	  fscanf(fileptr,"%d",&step);
	  for (i=0; i<InN; ++i) {
		fscanf(fileptr,"%lf",(tseq->Input+InN*step+i)); }	    
	  for (i=0; i<OutN; ++i) {
		fscanf(fileptr,"%lf",(tseq->Output+OutN*step+i)); }
	  for (i=0; i<ContN; ++i) {
		fscanf(fileptr,"%lf",(tseq->ContIn+ContN*step+i)); }
	  for (i=0; i<ActN; ++i) {
		fscanf(fileptr,"%lf",(tseq->Motor+ActN*step+i)); }
	}
  }
  fprintf(stderr,"\nplot ");

}

/* --
   -- */
InputOutputRead(tseq,cStep,seq_i)
	 struct SequenceRecord *tseq;
	 int cStep, seq_i;
{
  FILE *fileptr;
  char filename[128];
  int x0=10, y0=10, flag=1;

  fprintf(stderr,"\nfilename: ");
  scanf("%s",filename);
  fileptr = fopen(filename,"r");
  ReadInOutFile(tseq,cStep,seq_i,fileptr,x0,y0);
  fclose(fileptr);
}

ReadInOutFile(tseq,cStep,seq_i,fileptr,x0,y0)
	 struct SequenceRecord *tseq;
	 int cStep, seq_i;
	 FILE *fileptr;
	 int x0, y0;
{
  int step, i, endStep, initStep=0;
  double GlPlanEnergy;
  int cStepF= -10, seq_iF= -10;

  while (cStepF!=cStep || seq_iF!=seq_i) {

	fscanf(fileptr,"%d%d%d%lf",&seq_iF,&cStepF,&endStep,&GlPlanEnergy);
	fprintf(stderr,"\n%d %d ",seq_iF,cStepF);
	for (step=initStep; step<endStep; ++step) {
	  fscanf(fileptr,"%d",&step);
	  for (i=0; i<InN; ++i) {
		fscanf(fileptr,"%lf",(tseq->Input+InN*step+i)); }	    
	  for (i=0; i<OutN; ++i) {
		fscanf(fileptr,"%lf",(tseq->Output+OutN*step+i)); }
	  for (i=0; i<ContN; ++i) {
		fscanf(fileptr,"%lf",(tseq->ContIn+ContN*step+i)); }
	  for (i=0; i<ActN; ++i) {
		fscanf(fileptr,"%lf",(tseq->Motor+ActN*step+i)); }
	}
  }
}

/* ---------------------------------------
   Save structure context weight
   --------------------------------------- */
SaveContWeight(filestr,net)
	 FILE *filestr;
	 struct NET *net;
{
  int nos, noa, nob, noc, i, j;
  double *y_sub, *w_sub, *b_sub;

  setNetGlobal(net);
  fprintf(filestr, "%d\t%d\t%d\t%d\t%d\n",InN,HiddenN,OutN,ContN,MaxTrainSeq);
  for(i = 0; i < MaxTrainSeq; i ++){
	for(j = 0; j < ContN; j ++)
	  fprintf(filestr, "%lf ", *(TrainSeq[i].ContIn+j));
  }
  fprintf(filestr, "\n\n");

  w_sub = w21;
  b_sub = b2;
  for(i = 0; i < HiddenN; i++){
	for(j = 0; j < (InN+ContN); j++)
	  fprintf(filestr, "%lf ", *(w_sub ++));
	fprintf(filestr, "%lf\n", *(b_sub ++));
  }
  fprintf(filestr, "\n");
  w_sub = w32;
  b_sub = b3;
  for (i = 0; i < (OutN+ContN); i++){
	for(j = 0; j < HiddenN; j++)
	  fprintf(filestr, "%lf\t", *(w_sub ++));
	fprintf(filestr, "%lf\n", *(b_sub ++));
  }
}


/* ---------------------------------------
   Save structure context weight
   print mean square error in the end
   --------------------------------------- */
SaveWeight(filestr,net)
	 FILE *filestr;
	 struct NET *net;
{
  int nos, noa, nob, noc, i, j;
  double *y_sub, *w_sub, *b_sub;

  setNetGlobal(net);
  fprintf(filestr, "%d\t%d\t%d\t%d\t%d\n",InN,FS_N,HiddenN,OutN,ContN);

  fprintf(filestr, "\n\n");

  w_sub = w21;
  b_sub = b2;
  for(i = 0; i < HiddenN; i++){
	for(j = 0; j < (InN+FS_N+ContN); j++)
	  fprintf(filestr, "%lf ", *(w_sub ++));
	fprintf(filestr, "%lf\n", *(b_sub ++));
  }
  fprintf(filestr, "\n");
  w_sub = w32;
  b_sub = b3;
  for (i = 0; i < (OutN+ContN); i++){
	for(j = 0; j < HiddenN; j++)
	  fprintf(filestr, "%lf\t", *(w_sub ++));
	fprintf(filestr, "%lf\n", *(b_sub ++));
  }
  fprintf(filestr,"%lf\n",net->mseS); /* print mean square error */
}

/* ---------------------------------------
   Show context weight
   --------------------------------------- */
ShowContWeight(net)
	 struct NET *net;
{
  int nos, noa, nob, noc, i, j;
  double *y_sub, *w_sub, *b_sub;

  setNetGlobal(net);
  for(i = 0; i < MaxTrainSeq; i ++){
	for(j = 0; j < ContN; j ++)
	  printf("%lf ", *(TrainSeq[i].ContIn+j));
  }
  printf("\n\n");

  w_sub = w21;
  b_sub = b2;
  for (i = 0; i < HiddenN; i++){
	for(j = 0; j < (InN+ContN); j++)
	  printf("%lf ", *(w_sub ++));
	printf("%lf\n", *(b_sub ++));
  }
  printf("\n");
  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i++){
	for(j = 0; j < HiddenN; j++)
	  printf("%lf\t", *(w_sub ++));
	printf("%lf\n", *(b_sub ++));
  }
  printf("\n---------------------------------------\n");
}

ShowBias(net)
	 struct NET *net;
{
  int nos, noa, nob, noc, i, j;
  double *y_sub, *w_sub, *b_sub;

  setNetGlobal(net);
  w_sub = w21;
  b_sub = b2;
  printf("b2\n");
  for (i = 0; i < HiddenN; i++){
	printf("%lf ", *(b_sub ++));
  }
  printf("\n");
  w_sub = w32;
  b_sub = b3;
  printf("b3\n");
  for(i = 0; i < (OutN+ContN); i++){
	printf("%lf ", *(b_sub ++));
  }
  printf("\n---------------------------------------\n");
}

aveWeight(ave21,ave32)
	 double *ave21, *ave32;
{
  int i, j;
  double *w_sub, *b_sub;

  /* weight and bias */
  *ave21 = 0.0;
  w_sub = w21;
  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+FS_N+ContN); j ++) {
		*ave21 += *w_sub;
		++w_sub; }
	}
  *ave21 = *ave21/((InN+FS_N+ContN)*HiddenN);

  *ave32 = 0.0;
  w_sub = w32;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++) {
		*ave32 += *w_sub;
		++w_sub; }
	}
  *ave32 = *ave32/((OutN+ContN)*HiddenN);
}

/* --------------------------------------
   Random context weight bias
   -------------------------------------- */
RandomContWeight(range,net)
	 double range;
	 struct NET *net;
{
  int i,j;
  double *w_sub, *b_sub;
  setNetGlobal(net);

  /* context values for all seq */
  for(i = 0; i < MaxTrainSeq; i ++){
	for(j = 0; j < ContN; j ++)
	  *(TrainSeq[i].ContIn+j) = (SetRandom(range) + 1.0)/2.0;
  }

  /* weight and bias */
  w_sub = w21;
  b_sub = b2;
  fprintf(stderr,"w21%d b2%d ",w_sub,b_sub);

  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+ContN+FS_N); j ++)
	    *w_sub ++ = SetRandom(range);
	  *b_sub ++ = SetRandom(range);
	}

  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++)
	    *w_sub ++ = SetRandom(range);
	  *b_sub ++ = SetRandom(range);
	}

}

InitCont(net)
	 struct NET *net;
{
  int i,j;
  double *w_sub, *b_sub;
  setNetGlobal(net);

  /* context values for all seq */
  for(i = 0; i < MaxTrainSeq; i ++){
	for(j = 0; j < ContN; j ++) {
	  *(TrainSeq[i].ContIn+j) = 0.5;
	  *(TrainSeq[i].ContInU+j) = 0.0;
	}	
  }
}

RandomWeight(range,net)
	 double range;
	 struct NET *net;
{
  int i,j;
  double *w_sub, *b_sub;
  setNetGlobal(net);
  fprintf(stderr,"\nrange %f ",range);
  /* weight and bias */
  w_sub = w21;
  b_sub = b2;
  fprintf(stderr,"w21%d b2%d ",w_sub,b_sub);

  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+ContN+FS_N); j ++) {
	    *w_sub ++ = SetRandom(range);
	    fprintf(stderr,"%f ",*(w_sub-1));
	  }
	  *b_sub ++ = SetRandom(range);
	}

  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++)
	    *w_sub ++ = SetRandom(range);
	  *b_sub ++ = SetRandom(range);
	}

}

RandomWeight2(range1,range2,net)
	 double range1,range2;
	 struct NET *net;
{
  int i,j;
  double *w_sub, *b_sub;
  setNetGlobal(net);
  /* weight and bias */
  w_sub = w21;
  b_sub = b2;
  fprintf(stderr,"w21%d b2%d ",w_sub,b_sub);

  for(i = 0; i < HiddenN; i ++)
	{
	  for(j = 0; j < (InN+ContN+FS_N); j ++) {
		if (j<InN+FS_N)
		  *w_sub ++ = SetRandom(range1);
		else *w_sub ++ = SetRandom(range2);
	  }
	  *b_sub ++ = SetRandom(range1);
	}

  w_sub = w32;
  b_sub = b3;
  for(i = 0; i < (OutN+ContN); i ++)
	{
	  for(j = 0; j < HiddenN; j ++) {
		if (i<OutN)
		  *w_sub ++ = SetRandom(range1);
		else *w_sub ++ = SetRandom(range2); }
	  *b_sub ++ = SetRandom(range1);
	}
}
