/* ---------------------------
   left/right nets common FS control
   July 12, 1999
   Global variable def.
   --------------------------- */
#define RID 1
#define PAI 3.1415
#define MAXRAND 2147483648.0
#define SelfFeedBack 1
#define GateFeedBack 2
#define NoFeedBack 0
#define TRAIN 0
#define TestGene 5
#define RoboGene 10
#define MIMIC 1
#define ON 1
#define OFF 0
#define LOW 0
#define HIGH 1
#define LEFT 0
#define RIGHT 1
#define NoBP 0
#define DoBP 1
#define BOTH 2
#define MAP 0
#define DIFF 1
#define MaxStepsInSeq 50
#define ABS(x) ((x) < (0) ? -(x):(x))

#define Normal 0
#define NoOutBp 1

/* plot # */
#define MIX_X 0
#define GATE_X 1
#define FS_X 2
#define NET_X 3
#define PLSQ_X 4
#define SQ_X 5
#define TG 6
#define OUT_X 7
#define TCH_X 8
#define GENE_X 9


/* net structure */
#define SenseNG 0 
#define ActNG 2 /* in[2] = in[0]*in[1] */
#define ContNG 2 /*8*/
#define HiddenNG 10 /*10*/
#define FS_NG 2
#define DSCALE 0.30 /*0.24*/

#define WindowSteps 60
#define ClosedL 5 /*20*/
#define SmoothLength 20 /*20*/
#define SmoothN 3 /* # of hidden receiving time averaged in and ci */


struct SequenceRecord
{
    int steps;
    double TssSum;    /* sum of Tss averaged over maxSteps/OutN */
    double TssExpSum; /* sum of exp(-Tss/tss0) over steps */
    double *PredictError;   /* prediction error of robot */
    double *PredictErrorInteg;  /* prediction error integration */
    double *Input;        /* internal use for the activation in seq. */
    double *InputTeach;
    double *Motor;
    double *MotorU; /* internal value of motor nodes for planning*/
    double *MotorDL; /* delta change of motor for planning */
    double *MotorMix; /* mixed out of motor for all modules */
    double *PlanEnergy;
    double *ContIn;
    double *ContInU;
    double *Hidden;
    double *Output;       /* internal use for the activation in seq. */
    double *OutputU;       /* internal use for the activation in seq. */
    double *OutputTeach;
    double *ContOut;
    double *InDel; 
    double *ContInDel;
    double *HiddenDel;
    double *OutDel;
    double *ContOutDel;
    double *InEr;
    double *ContInEr;
    double *HiddenEr;
    double *OutEr;
    double *ContOutEr;
    double *dInitCont;
    double *dlInitCont;

  double *InputAve; /* time averaged */
  double *ContInAve; /* time averaged */

    double *Para;       /* parameter node in input layer */
    double *ParaDel;
    double *ParaEr;

    double *Tss; /* whole sum of sq error for units and maxSteps */
    double *TssAve; /* sq error per unit per step */
    double *TssExp; /* exp(-Tss/tss0) */
    double *ActError; /* activation error sum at each step */
    double *DelayReward; /* calculated delayed reawrd (-1.0, 1.0) */

    double *GPost; /* gate posterior */
    double *Gate;
    double *Sgate; /* s value */
    double *DSgate; /* delta s */
    double *Sigma; /* sigma of gate */
    double *GatePred; /* Gate value prediction from the H-level */
    double *OutputMix; /* gated sum of output for MixExperts.
			  This is put in the seq of the first module net.
			  */
    
    /* First Synaptic Modulation */
    double *FS;
    double *dFS;
    double *dlFS;
    double *dFSr; /* record of dFS */
};

struct NET
{
    int *InTypeS;
    int InNS;
    int ContNS;
    int HiddenNS;
    int OutNS;
    int FS_NS; /* # of fast synapses */
    int *FSptrS; /* id pointer of FS in w32 */

    double *w21S;
    double *w32S;
    double *b3S;
    double *b2S;
    double *dw21S;
    double *dw32S;
    double *db3S;
    double *db2S;
    double *dlw21S;
    double *dlw32S;
    double *dlb3S;
    double *dlb2S;
    int *fs32S; /* if fast synapse, then 1. Else 0. */
    double errorS; /* current whole sum of sq error for units and maxSteps */

    int MaxTrainSeqS; /* num of sequence which are trained in parallel. */    
    struct SequenceRecord *trainSeqS; /* training data of multiple seqs */
    struct SequenceRecord *actSeqS;  /* activation data of single seq during travel */

    int SenseNS;
    int ActNS;
    double mseS; /* current mean square error per unit per step in learning */
};

int AllTrainSteps;
double *InputDefort; /* value should be put manually */
FILE *histFile; 
int MaxTrainSeq, MaxSeqsL, MaxSeqsR, Pheight;
int *InType;	/* 0 =>just input, 1 => recursive from output */
int InN,ContN,HiddenN,OutN, SenseN, ActN, FS_N, *FSptr;
int ContX, ContY, HiddenX, HiddenY, HiddenID;
double *w21, *w32, *b3, *b2;
int *fs32; /* point fs id */
double *dw21, *dw32, *db3, *db2;
double *dlw21, *dlw32, *dlb3, *dlb2;
double Error;
double *Ap, *Up, *Plast, *epsiNet;
int xLarge[10],yLarge[10];
struct SequenceRecord *TrainSeq, *ActSeq; /* for learning */

int TimeL, TestMaxSteps; /* learning step */
/* param */
double pscale, decay, momentum, epsi, epsi0,epsiCont,RandRange, hid_k, errorDecayRate, errorDecay[100], wRange,inputRatio,inputRatioK,fs_R,para_R,MaxFSdelta;
double epsi_fs, momentum_fs, p_fs, d_fs, disc_fs, dumpFS, aEr0, epsiW, 
wEr0, wErBase, wtaTemp,epsi_plan,momentum_plan, epsi_u, epsi_fs_u;
double k_sigma, k_sigmaS, k_sigmaE, epsiG, epsiLR, noiseRate;
double decayR,ms,ms1,mp,mPerturb,mPerturbD,mr,mr1,mn,mn0,mnk,epsiM,momentumM,Tplan; /* for plan dynamics */
double GlPlanEnergy;
int cycles[100];
long now;
int nepochs, showtime, epoch;
int maxPlanSteps, maxPlanBits, planTimes;
int dumpSteps;
double *DumpFS;
double *IN_ER;

/* Hirata Linear Sum */
double *w21_0, *w32_0, *b3_0, *b2_0;
double *w21_1, *w32_1, *b3_1, *b2_1;
double linearK;

/* mode flag */
int TrainMode, EFlag0, EFlag1;
double logistic(), SetRandom(), SingleBp(), SinglePlanBp(), SnnBp(), SigSeki();
double gasdec();
double ReadFT_sub();

