#include<stdio.h>
#include<math.h>
#include<string.h>
#include <stdlib.h>
#include <time.h>

#include "RNN.h"
#include "Kohonen.h"

#define PLOT_REALTIME
#ifdef PLOT_REALTIME
#define PLOT_WEIGHT
#include "PlotRealtime.h"
#include<eggx.h>
#endif

//# define INITIALSTATE_SELFORGANIZATION


//print errors during learning
void PrintError(struct NET *netP,int it)
{
    int iseq;
    for(iseq=0;iseq<netP->MaxSeq;iseq++){
        printf("MSE[%d][%d]=%f\t",it,iseq,netP->Error[iseq]);
        printf("MSEClosed[%d][%d]=%f\t",it,iseq,netP->ErrorC[iseq]);
        printf("KL-divA[%d][%d]=%f\t",it,iseq,netP->KLdivA[iseq]);
        printf("KL-divV[%d][%d]=%f\t",it,iseq,netP->KLdivV[iseq]);
        printf("KL-divAClosed[%d][%d]=%f\t",it,iseq,netP->KLdivAC[iseq]);
        printf("KL-divVClosed[%d][%d]=%f\n",it,iseq,netP->KLdivVC[iseq]);
    }
    printf("MSEAve[%d]=%f**\t",it,netP->ErrorAve[it]);
    printf("MSEAveClosed[%d]=%f**\t",it,netP->ErrorAveC[it]);
    printf("KL-divAve[%d]=%f**\t",it,netP->KLdivAve[it]);
    printf("KL-divAveClosed[%d]=%f**\t",it,netP->KLdivAveC[it]);
    printf("CloseRML=%f\t",netP->closeRML);
    printf("CloseRSL=%f\t",netP->closeRSL);
    printf("ClosedMotorK=%f\t",netP->closedMotorK);
    printf("ClosedSenseK=%f\n",netP->closedSenseK);
}


void preSaveData(char *TmpDir,char *DataDir)
{
    char str[BUFSIZ];
    //name directory for data saving
    //copy parameter, training seqs and Kohonen-net weight at ./data/name_you_determin
    //Please make sure that you make ./data directory before run the simulator!!

  fprintf(stderr,"\nSave results directory ? => ");
  scanf("%s",DataDir);
  sprintf(str,"mkdir data/%s",DataDir);
  system(str);
  sprintf(str,"cp %s/train.ft data/%s/%s.ft",TmpDir,DataDir,DataDir);
  system(str);
  sprintf(str,"cp %s/tmp.train.pat data/%s/%s.pat",TmpDir,DataDir,DataDir);
  system(str);
  sprintf(str,"cp %s/tmp.koh.wt data/%s/%s.koh.wt",TmpDir,DataDir,DataDir);
  system(str);
}

//Learning mode
int Learning(struct NET *netP,char *DataDir,char *TmpDir){
    int i,count,countw;
    double CurrentError;
    count=0;countw=0;
    char filename[BUFSIZ];

#ifdef PLOT_REALTIME 
    int w1;//prepare window for sequence plot
    w1 = gopen(WIDTH,HIGHT);
    window(w1,0.0,HIGHT,WIDTH,0.0);
    layer(w1,0,1);gclr(w1);
#ifdef PLOT_WEIGHT
    int w2;//plot weight matrix
    w2 = gopen(WIDTHW,WIDTHW);
    window(w2,0.0,WIDTHW,WIDTHW,0.0);
    layer(w2,0,1);gclr(w2);
    draw_WeightMatrix(netP,netP->weight,netP->bias,w2);
//    msleep(1000);
#endif
#endif

    //prepare file for recording errors during learning
    FILE *fp_error;
    sprintf(filename,"data/%s/%s_error.csv",DataDir,DataDir);
    if(!(fp_error = fopen(filename,"w"))){
        printf("file open error!!\n");
    }
    fprintf(fp_error,"step\tcloseRML\tcloseRSL\tMSEAve\tKl-divAve\tclosedMotorK\tclosedSenseK\tMSEAveClose\tKl-divAveClose\n");
    fclose(fp_error);


    //learning iterations
    int cStep,iseq;
    for(i=0,CurrentError=10;CurrentError>netP->ErrorEv && i<netP->MaxLstep;i++){
        count=i%10;

        //Forward propagation & Back-propagation for all seqs based on closed rates "closedRML" and "closedRSL"
        for(iseq=0;iseq<netP->MaxSeq;iseq++){
            SetInitialActivation_Seq(netP,netP->SeqL,iseq);
            for(cStep=0;cStep<netP->SeqL[iseq].steps-netP->delay+1;cStep++){
                ForwardActivation(netP,netP->SeqL[iseq].knArm,netP->SeqL[iseq].knVision,netP->closeRML,netP->closeRSL,iseq,cStep);
            }
            Backpropagation(netP,netP->SeqL+iseq);
        }
        CurrentError=Error_com(netP,netP->SeqL,netP->Error);//calculate MSE
        netP->ErrorAve[i]=CurrentError;
        netP->KLdivAve[i]=KLdiv_com(netP,netP->SeqL,netP->KLdivA,netP->KLdivV);//calculate KL-div

#ifdef INITIALSTATE_SELFORGANIZATION
        for(iseq=0;iseq<netP->MaxSeq;iseq++){
            Updata_InitState(netP,iseq);
        }
#endif
        Update_wb(netP);

        //TEST closed generation during learning process 
        if(count==0){
            for(iseq=0;iseq<netP->MaxSeq;iseq++){
                SetInitialActivation_Seq(netP,netP->SeqL,iseq);
//                printf("forward propagation L-Test seq %d\n",iseq);
                for(cStep=0;cStep<netP->SeqL[iseq].steps-netP->delay+1;cStep++){
                    ForwardActivation(netP,netP->SeqL[iseq].knArm,netP->SeqL[iseq].knVision,netP->closedMotorK,netP->closedSenseK,iseq,cStep);
                }
            }
            netP->ErrorAveC[i]=Error_com(netP,netP->SeqL,netP->ErrorC);
            netP->KLdivAveC[i]=KLdiv_com(netP,netP->SeqL,netP->KLdivAC,netP->KLdivVC);
            PrintError(netP,i);
            sprintf(filename,"data/%s/%s_error.csv",DataDir,DataDir);
            if(!(fp_error = fopen(filename,"a"))){
                printf("file open error!!\n");
            }
            fprintf(fp_error,"%d\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\n",i,netP->closeRML,netP->closeRSL,netP->ErrorAve[i],netP->KLdivAve[i],netP->closedMotorK,netP->closedSenseK,netP->ErrorAveC[i],netP->KLdivAveC[i]);
            fclose(fp_error);

#ifdef PLOT_REALTIME
             RealtimePlotT(netP,netP->SeqL,w1,0,netP->MaxSeq);
#endif
        }
    }
    return 0;
}

//Test mode
int Test(struct NET *netP,char *DataDir,char *TmpDir){
    int i;

#ifdef PLOT_REALTIME
    int w1;//prepare window for sequence plot
    w1 = gopen(WIDTH,HIGHT);
    window(w1,0.0,HIGHT,WIDTH,0.0);
    layer(w1,0,1);gclr(w1);
#ifdef PLOT_WEIGHT
    int w2;//plot weight matrix
    w2 = gopen(WIDTHW,WIDTHW);
    window(w2,0.0,WIDTHW,WIDTHW,0.0);
    layer(w2,0,1);gclr(w2);
    draw_WeightMatrix(netP,netP->weight,netP->bias,w2);
//    msleep(1000);
#endif
#endif
    //Forward propagation for all seqs based on closed rates "closedMotorK" and "closedSenseK"
    int cStep,iseq;
    for(iseq=0;iseq<netP->MaxSeq;iseq++){
        SetInitialActivation_Seq(netP,netP->SeqL,iseq);
//        printf("forward propagation TEST seq %d\n",iseq);
        for(cStep=0;cStep<netP->SeqL[iseq].steps-netP->delay+1;cStep++){
                ForwardActivation(netP,netP->SeqL[iseq].knArm,netP->SeqL[iseq].knVision,netP->closedMotorK,netP->closedSenseK,iseq,cStep);
        }
    }
    i=0;
    netP->ErrorAveC[i]=Error_com(netP,netP->SeqL,netP->Error);//calculate mean square error (MSE)
    netP->KLdivAveC[i]=KLdiv_com(netP,netP->SeqL,netP->KLdivA,netP->KLdivV);//calculate KL-divergence
    PrintError(netP,i);
#ifdef PLOT_REALTIME
        int ShowSeq,StatSeq,EndSeq;
        while (1){
            printf("Which sequence do you want to see (all '0' or part '1'?\n");
            printf("(If you want to quit the program, please enter '999'.)\n");
            scanf("%d",&ShowSeq);
            if(ShowSeq==0){
                StatSeq=0;
                EndSeq=netP->MaxSeq;
                RealtimePlotT(netP,netP->SeqL,w1,StatSeq,EndSeq);
            }
            if(ShowSeq==1){
                printf("Start sequence?\n");
                scanf("%d",&StatSeq);
                printf("End sequence?\n");
                scanf("%d",&EndSeq);
                RealtimePlotT(netP,netP->SeqL,w1,StatSeq,EndSeq);
            }
            if(ShowSeq==999){
                break;
            }
        }
#endif
    return 0;
}




void offline(char *TmpDir,char *DataDir,struct NET *netP)
{
    int i;
    char word[BUFSIZ],filename[BUFSIZ];
    FILE *fileptr;

    //read target sequences from ./TmpDir/tmp.train.pat
    sprintf(filename,"%s/tmp.train.pat",TmpDir);
    fileptr = fopen(filename,"r");
    ReadPattern(fileptr,netP);
    fclose(fileptr);
    printf("MaxSeq=%d\n",netP->MaxSeq);
    printf("Target Sensori-motor pattern is read\n");

    //Kohonen net initialization
    for(i=0;i<netP->MaxSeq;i++){
        netP->SeqL[i].knArm=get_alloc_knet(ARM);
        netP->SeqL[i].knVision=get_alloc_knet(VISION);

        Init_knet(netP->SeqL[i].knArm);
        Init_knet(netP->SeqL[i].knVision);

        sprintf(filename,"%s/tmp.koh.wt",TmpDir);
        if(!(fileptr = fopen(filename,"r"))){
            printf("file open error!!\n");
        }
        read_weightK(fileptr,netP->SeqL[i].knArm);
        read_weightK(fileptr,netP->SeqL[i].knVision);
        fclose(fileptr);
    }
    printf("alloc Kohonen net, initialization, set kohonen weights ok!!\n");

    printf("\n*****************************************************************\n");
    printf("\n      Multiple Timescale Reccurent Neural Network (MTRNN)          \n");
    printf("\n*****************************************************************\n");

    while (strncmp(word,"quit",BUFSIZ) != 0){
        printf("\n Learning('l') , Test('t') or Generate L.G.initA ('g')?\n");
        printf("(If you want to quit the program, please enter 'quit'.)\n");
        scanf("%s",word);

        // alloc memory for members of struxt NET
        InitNet(netP);
        printf("InitNet\n");

        //Initialize sequences
        InitializeSequence(netP,word,TmpDir);
        printf("Sequece Initialized\n");

        if(strncmp(word,"l",BUFSIZ) == 0){
            printf("Learning mode!!\n");
            Learning(netP,DataDir,TmpDir);

            //save weight values
            sprintf(filename,"data/%s/%s_Weight.csv",DataDir,DataDir);
            if(!(fileptr = fopen(filename,"w"))){
                printf("file open error!!\n");
            }
            Save_weight(fileptr,netP->weight,netP->bias,netP->NetSizeN);
            fclose(fileptr);
            printf("save Weight file!!\n");

            //save initial sates values
            sprintf(filename,"data/%s/%s_L.G.initA",DataDir,DataDir);
            if(!(fileptr = fopen(filename,"w"))){
            printf("file open error!!\n");
            }
            SaveInitState(fileptr,netP,netP->SeqL);
            fclose(fileptr);

            break;
        }
        if(strncmp(word,"t",BUFSIZ) == 0){
            printf("Test mode!!\n");
            Test(netP,DataDir,TmpDir);
            break;
        }

        //generate initial states file (L.G.initA)
        //You have to generate L.G.initA file when you train a network for the first time.
        if(strncmp(word,"g",BUFSIZ) == 0){
            printf("generate L.G.initA file!!\n");
            Generate_InitFile(netP,DataDir);
            break;
        }
    }
}



int main(int argc,char *argv[])
{
    double rseed;
    char filename[BUFSIZ],TmpDir[BUFSIZ],DataDir[BUFSIZ];
    FILE *fp;

    // seed for rand()
    rseed=(double)time(NULL);
    srand(rseed); 

    //select directory for reading training data, parameter, Kohonen-net weight and initial states files
    int machineID;
    fprintf(stderr,"\nParameter file directory? tmp0,1,2,3,4,,, => ");
    scanf("%d",&machineID);
    sprintf(TmpDir,"tmp%d",machineID);

    //allocate memory for MTRNN
    struct NET *NetP;
    NetP=NULL;
    NetP = (struct NET*)calloc(1, sizeof(struct NET));
    printf("struct NET alloc\n");

    //read parameter from file tmp"machineID"/train.ft
    sprintf(filename,"%s/train.ft",TmpDir);
    ReadFT(filename,NetP);
    fprintf(stderr,"parameter file %s is loaded\n",filename);

    preSaveData(TmpDir,DataDir);
    offline(TmpDir,DataDir,NetP);

    //save seed of random
    sprintf(filename,"data/%s/%s_rseed.rs",DataDir,DataDir);
    fp = fopen(filename, "w");
    fprintf(fp,"%f\n",rseed);
    fclose(fp);

    return 0;
}
