#ifndef _RNN_H_
#define _RNN_H_

#include "Kohonen.h"


#define Rlow -0.025
#define Rhigh 0.025

//for computation of KL divergence when seq[p].out[j][k]=0.0
#define ypsilon 0.000001

//Sequence data
typedef struct SEQUENCE{
    int steps;

    double **act;//net act
    double **net;//membrane potential
    double **out;//net out (sigmoidal or softmax out)
    double **teach;//net teach

    double *init_net;//initial state

    double *MSE_step;//MSE step
    double *KLdiv_stepA;//KL-div step Arm
    double *KLdiv_stepV;//KL-div step Vision

 
    double **inRealK;//sensori-motor input (robot original dimensions)
    double **inPredK;//sensori-motor prediction
    double **inK;//input to Kohonen-map (mix of inRealK and inPredK)

    struct KNET *knArm;//Kohonen-map Arm
    struct KNET *knVision;//Kohonen-map Vision

    double *d_init_net;//delta error for initial states
    double *d_net;//delta error for each unit
    double *prev_d_net;//delta error of previous step

    double **d_weight;//delta error for weight update
    double *d_bias;//delta error for bias update

    }SEQUENCE;


//MTRNN net
typedef struct NET{
    int MaxSeq;//total nmuber of seuqences in training data
    int TotalSteps;//total time steps of training data
    int delay;//delay of network predicion (t->t+1? t+2?...)

    int InN;
    int ContN;
    int ContN2;
    int NetSizeN;
    int inKN;

    double **weight;
    double **dl_weight;
    double *bias;
    double *dl_bias;

    struct SEQUENCE *SeqL;

    double epsilon;
    double eta;
    double rhoX;
    double rhoCF;
    double rhoCS;

    double tauX;
    double tauCF;
    double tauCS;

    double *phi;    // 1/tau

    int MaxLstep;
    double ErrorEv;
    double *Error;
    double *ErrorAve;
    double *ErrorC;
    double *ErrorAveC;
    double *ErrorP;
    double *ErrorAveP;
    double *KLdivA;
    double *KLdivV;
    double *KLdivAve;
    double *KLdivAC;
    double *KLdivVC;
    double *KLdivAveC;

    double closeRML;
    double closeRSL;
    double closedMotorK;
    double closedSenseK;

    int TPMNeighborA;
    int TPMNeighborV;
    }NET;

double unif_rand(double left, double right);
int ReadFT(char *filename,struct NET *netP);
void ReadPattern(FILE *filestr,struct NET *netP);
void Generate_InitFile(struct NET *netP,char *DataDir);
void SaveInitState(FILE *filestr,struct NET *netP,struct SEQUENCE *seq);
void InitNet(struct NET *netP);
void InitializeSequence(struct NET *netP,char *word,char *TmpDir);
void SetInitialActivation_Seq(struct NET *netP,struct SEQUENCE *seq,int iseq);
void ForwardActivation(struct NET *netP,struct KNET *knA,struct KNET *knV,double clRKM,double clRKS,int iseq,int cStep);
double Error_com(struct NET *netP,struct SEQUENCE *seq,double *Error);
double KLdiv_com(struct NET *netP,struct SEQUENCE *seq,double *KLdivA,double *KLdivV);
void Update_wb(struct NET *netP);
void Save_weight(FILE *fp,double **weight,double *bias,int NetSizeN);
void Updata_InitState(struct NET *netP,int p);
void Backpropagation(struct NET *netP,struct SEQUENCE *seq);

#endif

