#include<stdio.h>
#include<math.h>
#include<string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

#include "RNN.h"
#include "Kohonen.h"

//generate random value between left and right
double unif_rand(double left, double right)
{
    return left + (right - left)*rand()/RAND_MAX;
}

//sigmoid function
double sigmoid(double x)
{
    double y;
    y=(double)1/(1+exp(-(x)*1.0));
    return y;
}


//inverse of sigmoid function
double logisticInv(double y)
{

    if (y>0.999) {y=0.999;}
//fprintf(stderr,"WARNING: logisticInv%f ",y);
    if (y<0.001) {y=0.001;}
//fprintf(stderr,"WARNING: logisticInv%f ",y);
    return (log(y/(1.0-y)));
}

//Kronecker's delta
double Krdelta(int i,int j)
{
    double res;
    res=0.0;
    if(i==j){
        res=1.0;
    }
    else{
        res=0.0;
    }
    return res;
}


//used in ReadFT() below
static char char_buf[BUFSIZ];
static char*
read_line(FILE *fp) {
  char *ptr;

  while(fgets(char_buf, BUFSIZ-1, fp) != NULL) {
	ptr = char_buf;
	while(isspace(*ptr)) {
	  ptr++;
	}
	if ( (*ptr == '\0') || (*ptr == '#') ) {
	  continue;
	}
	return ptr;
  }
  return NULL;
}

//used in ReadFT() below
static char *
getkey(char *ptr, double *val) {
  char *p;
  char *val_tmp;
  char *key;

  p = ptr;

  key = strtok(p, " \t");
  //  printf("key %s\n", key);
  val_tmp = strtok(NULL, " \t");
  //  printf("val %s\n", val_tmp);
  *val = atof(val_tmp);

  return key;
}

//read parameters from file using read_line() and getkey()
int ReadFT(char *filename,struct NET *netP)
{
    FILE *param_file;
    char *ptr;
    char *key;
    double key_val;

    if ((param_file = fopen(filename, "r")) == NULL) {
	perror("cant open parameter file.\n");
	exit(-1);}

//    printf("read_line start\n");
    while((  ptr = read_line(param_file)) != NULL) {
	if (!strncmp(ptr, "%%", 2)) {
	  fclose(param_file);
	  return 0; // "%%" indicates the end of parameters
	}
	key = getkey(ptr, &key_val);
	if (!strcmp(key, "InN")) {
	  netP->InN = (int)key_val;}
	else if (!strcmp(key, "ContN")) {
	  netP->ContN = (int)key_val;}
	else if (!strcmp(key, "ContN2")) {
	  netP->ContN2 = (int)key_val;}
	else if (!strcmp(key, "inKN")) {
	  netP->inKN = (int)key_val;}
	else if (!strcmp(key, "epsilon")) {
	  netP->epsilon = key_val;}
	else if (!strcmp(key, "eta")) {
	  netP->eta = key_val;}
	else if (!strcmp(key, "rhoX")) {
	  netP->rhoX = key_val;}
	else if (!strcmp(key, "rhoCF")) {
	  netP->rhoCF = key_val;}
	else if (!strcmp(key, "rhoCS")) {
	  netP->rhoCS = key_val;}
	else if (!strcmp(key, "tauX")) {
	  netP->tauX = key_val;}
	else if (!strcmp(key, "tauCF")) {
	  netP->tauCF = key_val;}
	else if (!strcmp(key, "tauCS")) {
	  netP->tauCS = key_val;}
	else if (!strcmp(key, "MaxLstep")) {
	  netP->MaxLstep = (int)key_val;}
	else if (!strcmp(key, "delay")) {
	  netP->delay = (int)key_val;}
	else if (!strcmp(key, "ErrorEv")) {
	  netP->ErrorEv = key_val;}
	else if (!strcmp(key, "closeRML")) {
	  netP->closeRML = key_val;}
	else if (!strcmp(key, "closeRSL")) {
	  netP->closeRSL = key_val;}
	else if (!strcmp(key, "closedMotorK")) {
	  netP->closedMotorK = key_val;}
	else if (!strcmp(key, "closedSenseK")) {
	  netP->closedSenseK = key_val;}
	else if (!strcmp(key, "TPMNeighborA")) {
	  netP->TPMNeighborA = (int)key_val;}
	else if (!strcmp(key, "TPMNeighborV")) {
	  netP->TPMNeighborV = (int)key_val;}
    }

    netP->NetSizeN=netP->InN+netP->ContN;

    return 0;
}

//Allocate memory for struct sequence
void AllocSequence(struct NET *netP,struct SEQUENCE *seq,int seqLength,int seqNum)
{
    int i;

    seq[seqNum].steps = seqLength;
    seq[seqNum].act = (double **)calloc(seqLength,sizeof(double*));
    seq[seqNum].net = (double **)calloc(seqLength,sizeof(double*));
    seq[seqNum].out = (double **)calloc(seqLength,sizeof(double*));
    seq[seqNum].teach = (double **)calloc(seqLength,sizeof(double*));
    seq[seqNum].inRealK = (double **)calloc(seqLength,sizeof(double*));
    seq[seqNum].inPredK = (double **)calloc(seqLength,sizeof(double*));
    seq[seqNum].inK = (double **)calloc(seqLength,sizeof(double*));


    for(i=0;i<seqLength;i++){
        seq[seqNum].act[i]=(double *)calloc(netP->NetSizeN,sizeof(double));
        seq[seqNum].net[i]=(double *)calloc(netP->NetSizeN,sizeof(double));
        seq[seqNum].out[i]=(double *)calloc(netP->NetSizeN,sizeof(double));
        seq[seqNum].teach[i]=(double *)calloc(netP->InN,sizeof(double));
        seq[seqNum].inRealK[i] = (double *)calloc(netP->inKN,sizeof(double));
        seq[seqNum].inPredK[i] = (double *)calloc(netP->inKN,sizeof(double));
        seq[seqNum].inK[i] = (double *)calloc(netP->inKN,sizeof(double));
    }

    seq[seqNum].d_init_net = (double *)calloc(netP->NetSizeN,sizeof(double));
    seq[seqNum].d_net = (double *)calloc(netP->NetSizeN,sizeof(double));
    seq[seqNum].prev_d_net = (double *)calloc(netP->NetSizeN,sizeof(double));

    seq[seqNum].init_net = (double *)calloc(netP->NetSizeN,sizeof(double));
    seq[seqNum].MSE_step = (double *)calloc(seqLength,sizeof(double));
    seq[seqNum].KLdiv_stepA = (double *)calloc(seqLength,sizeof(double));
    seq[seqNum].KLdiv_stepV = (double *)calloc(seqLength,sizeof(double));

    seq[seqNum].d_weight = (double **)calloc(netP->NetSizeN, sizeof(double*));
        for(i=0;i<netP->NetSizeN;i++){
            seq[seqNum].d_weight[i] = (double *)calloc(netP->NetSizeN, sizeof(double));
    }
    seq[seqNum].d_bias = (double *)calloc(netP->NetSizeN, sizeof(double));
}


//read target sequences from ./TmpDir/tmp.train.pat
void ReadPattern(FILE *filestr,struct NET *netP)
{
    int i;
    double value;
    int seqStep = 0;int seqNum = 0; int ct;
    struct SEQUENCE *seq;

    while (fscanf(filestr, "%d", &ct) != EOF){
        if (ct >= 0){
            for (i=0; i<netP->inKN; ++i){
	        fscanf(filestr,"%lf",&value);
            }
            seqStep += 1;
        }else{
            seqStep = 0;
	    ++ seqNum;
        }
    }
    netP->MaxSeq = seqNum;
    seq = (struct SEQUENCE*)calloc(seqNum,sizeof(struct SEQUENCE));
    netP->SeqL = seq;

    rewind(filestr);
    seqStep = 0;seqNum = 0;
    while (fscanf(filestr, "%d", &ct) != EOF){
        if (ct >= 0){
	    for (i=0; i<netP->inKN; ++i){
                fscanf(filestr,"%lf",&value);
            }
            seqStep += 1;
        }else{
            AllocSequence(netP,seq,seqStep,seqNum);
	    seqStep = 0;
	    ++ seqNum;
        }
    }

    rewind(filestr);
    seqStep = 0;seqNum = 0;
    while (fscanf(filestr, "%d", &ct) != EOF){
        if (ct >= 0){
	    for (i=0; i<netP->inKN; ++i) {
		fscanf(filestr,"%lf",&seq[seqNum].inRealK[seqStep][i]);
            }
            seqStep += 1;
	}else{
	    seqStep = 0;
	    ++ seqNum;
        }
    }
}

//Read init file
void ReadInitState(FILE *fp,struct NET *netP,struct SEQUENCE *seq)
{
    int iseq,i,dm;
    fscanf(fp,"%d",&dm);
    for (iseq=0; iseq<netP->MaxSeq; ++iseq) {
        for(i=0;i<netP->NetSizeN;i++){
        fscanf(fp,"%lf",&seq[iseq].init_net[i]);
        }
    }
}


//save generated initial states in L.G.initA file
void SaveInitState(FILE *filestr,struct NET *netP,struct SEQUENCE *seq)
{
    int iseq,i;

    fprintf(filestr,"%d\n",netP->MaxSeq);
    for (iseq=0; iseq<netP->MaxSeq; ++iseq) {
        for (i=0; i<netP->NetSizeN; ++i){
            fprintf(filestr,"%.16lf\t",seq[iseq].init_net[i]);
        }
        fprintf(filestr,"\n");
    }
}

//generate L.G.initA file
void Generate_InitFile(struct NET *netP,char *DataDir)
{
    int p,k;
    char filename[BUFSIZ];
    FILE *fileptr;

#if 0
    double DisRange;
    DisRange=(double)0.5/(netP->ContN-netP->ContN2);
//    printf("DisRange=%f\n",DisRange);
#endif

    //set initial value of Input units for learning
    for(p=0;p<netP->MaxSeq;p++){
        for(k=0;k<netP->InN;k++){
            netP->SeqL[p].act[0][k]= netP->SeqL[p].teach[0][k];
            netP->SeqL[p].init_net[k]= log(netP->SeqL[p].teach[0][k]);
        }
    }
    //set initial value of context units for learning
    for(p=0;p<netP->MaxSeq;p++){
        for(k=netP->InN;k<netP->InN+netP->ContN2;k++){
            netP->SeqL[p].act[0][k]= 0.5;
            netP->SeqL[p].init_net[k]= logisticInv(netP->SeqL[p].act[0][k]);
        }
        for(k=netP->InN+netP->ContN2;k<netP->InN+netP->ContN;k++){
             netP->SeqL[p].act[0][k]= 0.5;
#if 0
            netP->SeqL[p].act[0][k]= unif_rand(0.25,0.75);
            printf("act[%d][%d]=%f\n",p,k,netP->SeqL[p].act[0][k]);
#endif
            netP->SeqL[p].init_net[k]= logisticInv(netP->SeqL[p].act[0][k]);
        }
    }

    sprintf(filename,"data/%s/L.G.initA",DataDir);
    if(!(fileptr = fopen(filename,"w"))){
        printf("file open error!!\n");}
    SaveInitState(fileptr,netP,netP->SeqL);
    fclose(fileptr);
}

//alloc memory for weight
void Alloc_weight(struct NET *netP)
{
    int i;
    netP->weight = (double **)calloc(netP->NetSizeN, sizeof(double*));
    netP->dl_weight = (double **)calloc(netP->NetSizeN, sizeof(double*));
        for(i=0;i<netP->NetSizeN;i++){
            netP->weight[i] = (double *)calloc(netP->NetSizeN, sizeof(double));
            netP->dl_weight[i] = (double *)calloc(netP->NetSizeN, sizeof(double));
        }
    netP->bias = (double *)calloc(netP->NetSizeN, sizeof(double));
    netP->dl_bias = (double *)calloc(netP->NetSizeN, sizeof(double));
}

//set random values in weights
void Init_weight(struct NET *netP)
{
    int i,j;
    for(i=0;i<netP->NetSizeN;i++){
        for(j=0;j<netP->NetSizeN;j++){
            netP->weight[i][j]=unif_rand(Rlow,Rhigh);
        }
        netP->bias[i]=0.0; //unif_rand(Rlow,Rhigh);
    }
}

//read weight values from file
void Read_weight(FILE *fp,struct NET *netP)
{
    int i,j;
    for(i=0;i<netP->NetSizeN;i++){
        for(j = 0;j < netP->NetSizeN;j++){
            fscanf(fp,"%lf",&netP->weight[i][j]);
        }
        fscanf(fp,"%lf",&netP->bias[i]);
    }
}

//save weight
void Save_weight(FILE *fp,double **weight,double *bias,int NetSizeN)
{
    int i,j;
    for(i=0;i<NetSizeN;i++){
        for(j=0;j<NetSizeN;j++){
            fprintf(fp,"%.16lf\t",weight[i][j]);
        }
        fprintf(fp,"%.16lf\t",bias[i]);
        fprintf(fp,"\n");
    }
    fprintf(fp,"\n");
}


//set sparse connection of Kohonen-net 
//If Jth unit is connecetd from Ith unit in the same kohonen net with n neighbor,
//   *ans=1
void conKohInTo(int I,int J,int xsize,int ysize,int n,int *ans)
{
  int Ix,Iy,Jx,Jy;

  Ix = I % xsize;
  Iy = I / ysize;

  Jx = J % xsize;
  Jy = J / ysize;

  if ((Ix >= Jx-n) && (Ix <= Jx+n) && (Iy >= Jy-n) && (Iy <= Jy+n))
	*ans = 1;
  else *ans = 0;
}


//Set connections between types of units based on your design of the network
#define ELMAN_TYPE_NET
void disConnectW(struct NET *netP,double **weight)
{
    int i,j;

//To IN
    for(i = 0;i < netP->InN;i++){
#ifdef ELMAN_TYPE_NET
        for(j= 0;j<netP->InN;j++){
            weight[i][j]=0.0;
        }
#endif
#ifndef ELMAN_TYPE_NET
        if(netP->TPMNeighborA==0 && netP->TPMNeighborV==0){
            weight[i][i]=0.0;
        }

        int ans=0;
        for(j= 0;j<netP->InN;j++){
            if (i>=SIZE_ARM && j<SIZE_ARM){
                weight[i][j]=0.0;
            }//i and j are in different kohonen nets
            else if (i<SIZE_ARM && j>=SIZE_ARM){
                weight[i][j]=0.0;
            }// i and j are in different kohonen nets
            else if (i<SIZE_ARM){ //i and j are in the ARM kohonen nets
                conKohInTo(j,i,SIDE_XA,SIDE_XA,netP->TPMNeighborA,&ans);
                if (ans==0) {
                    weight[i][j]=0.0;
                }
            }
            else if (i>=SIZE_ARM) {// i and j are in the Vision kohonen nets
                conKohInTo(j-SIZE_ARM,i-SIZE_ARM,SIDE_XV,SIDE_XV,netP->TPMNeighborV,&ans);
                if (ans==0){
                    weight[i][j]=0.0;
                }
            }
            else;
        }
#endif
        for(j=0;j<netP->ContN2;j++){
//            weight[i][netP->InN+j]=0.0; //disConnect from Fast context to In
        }
        for(j=netP->ContN2;j<netP->ContN;j++){
            weight[i][netP->InN+j]=0.0; //disConnect from Slow context to In
        }
    }

//To FAST CONT
    for(i = netP->InN;i <netP->InN+netP->ContN2;i++){
        for(j= 0;j<netP->InN;j++){
//            weight[i][j];//from In to ContFast
        }
        for(j=netP->InN;j < netP->InN+netP->ContN2;j++){
//            weight[i][j];//from ContFast to ContFast
        }
        for(j=netP->InN+netP->ContN2;j < netP->InN+netP->ContN;j++){
//            weight[i][InN+j];from ContSlow to ContFast
        }
    }


//To SLOW CONT
    for(i = netP->InN+netP->ContN2;i <netP->InN+netP->ContN;i++){
        for(j= 0;j<netP->InN;j++){
            weight[i][j]=0.0;//from In to ContSlow
        }
        for(j=netP->InN;j < netP->InN+netP->ContN2;j++){
//            weight[i][j];//from ContFast to ContSlow
        }
        for(j=netP->InN+netP->ContN2;j < netP->InN+netP->ContN;j++){
//            weight[i][InN+PBN+j];from ContSlow to ContSlow
        }
    }
}



//Initialize MTRNN net
void InitNet(struct NET *netP)
{
    netP->Error=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->ErrorC=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->ErrorP=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->ErrorAve=(double *)calloc(netP->MaxLstep, sizeof(double));
    netP->ErrorAveC=(double *)calloc(netP->MaxLstep, sizeof(double));
    netP->ErrorAveP=(double *)calloc(netP->MaxLstep, sizeof(double));
    netP->KLdivA=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->KLdivV=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->KLdivAve=(double *)calloc(netP->MaxLstep, sizeof(double));
    netP->KLdivAC=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->KLdivVC=(double *)calloc(netP->MaxSeq, sizeof(double));
    netP->KLdivAveC=(double *)calloc(netP->MaxLstep, sizeof(double));
    netP->phi=(double *)calloc(netP->NetSizeN, sizeof(double));

    Alloc_weight(netP);
    printf("weight alloc\n");
}

//set 1/tau
void Set_phi(struct NET *netP)
{
    int i;
    for(i=0;i<netP->InN;i++){
        netP->phi[i]=(double)1.0/netP->tauX;
//        printf("phi[%d]=%f\n",i,netP->phi[i]);
    }
    for(i=netP->InN;i<netP->InN+netP->ContN2;i++){
        netP->phi[i]=(double)1.0/netP->tauCF;
//        printf("phi[%d]=%f\n",i,netP->phi[i]);
    }
    for(i=netP->InN+netP->ContN2;i<netP->InN+netP->ContN;i++){
        netP->phi[i]=(double)1.0/netP->tauCS;
//        printf("phi[%d]=%f\n",i,netP->phi[i]);
    }
}

//Initialize sequences based on the choice of "Learning" or "Test"
void InitializeSequence(struct NET *netP,char *word,char *TmpDir)
{
    int p,j,k;
    int sum=0;
    char filename[BUFSIZ];
    FILE *fileptr;

    //set teach from sensori-motor sequence to seq.teach
    for(p=0;p<netP->MaxSeq;p++){
        sum+=netP->SeqL[p].steps;
        for(j=0;j<netP->SeqL[p].steps-netP->delay;j++){
            KohonenALL(netP->SeqL[p].inRealK[j+netP->delay],netP->SeqL[p].teach[j],netP->SeqL[p].knArm,netP->SeqL[p].knVision);
        }
        for(j=netP->SeqL[p].steps-netP->delay;j<netP->SeqL[p].steps;j++){
            KohonenALL(netP->SeqL[p].inRealK[netP->SeqL[p].steps-1],netP->SeqL[p].teach[j],netP->SeqL[p].knArm,netP->SeqL[p].knVision);
        }
    }
    netP->TotalSteps=sum;
    printf("TotalSteps=%d\n",netP->TotalSteps);

    //set inPredK
    for(p=0;p<netP->MaxSeq;p++){
        for(j=0;j<netP->delay;j++){
            for(k=0;k<netP->inKN;k++){
                netP->SeqL[p].inPredK[j][k]= netP->SeqL[p].inRealK[j][k];
            }
        }
    }

    //set phi=1/tau
    Set_phi(netP);
    printf("Set phi\n");


    if(strncmp(word,"l",BUFSIZ) == 0){

        sprintf(filename,"%s/L.G.initA",TmpDir);
        if(!(fileptr = fopen(filename,"r"))){
            printf("file open error!!\n");}
        ReadInitState(fileptr,netP,netP->SeqL);
        printf("Read Initial states\n");
        fclose(fileptr);

        Init_weight(netP);
        printf("Initialize  weight!!\n");
        disConnectW(netP,netP->weight);
        printf("disconnect weight!!\n");
    }

    if(strncmp(word,"t",BUFSIZ) == 0){

        sprintf(filename,"%s/L.G.initA",TmpDir);
        if(!(fileptr = fopen(filename,"r"))){
            printf("file open error!!\n");}
        ReadInitState(fileptr,netP,netP->SeqL);
        printf("Read Initial states\n");
        fclose(fileptr);

        sprintf(filename,"%s/tmpL.wtA",TmpDir);
        if(!(fileptr = fopen(filename,"r"))){
            printf("file open error!!\n");}
        Read_weight(fileptr,netP);
        printf("Read weight!!\n");
        fclose(fileptr);
    }
}

//set act[0] based on the initial states 
void SetInitialActivation_Seq(struct NET *netP,struct SEQUENCE *seq,int iseq)
{
    int k;

    //set initial activation of context
    for(k=netP->InN;k<netP->InN+netP->ContN;k++){
        seq[iseq].act[0][k]=sigmoid(seq[iseq].init_net[k]);
    }
}

//mix prediction of MTRNN and teach signal into inK (inK is sent to kohonen-net)
void SetinK(double *inK, double *inPredK, double *inRealK,double closeRKM,double closeRKS,int inKN)
{
    int i;

    for(i=0;i<DataDim_ARM;i++){
        inK[i]=inPredK[i]*closeRKM+inRealK[i]*(1.0-closeRKM);
    }
    for(i=DataDim_ARM;i<inKN;i++){
        inK[i]=inPredK[i]*closeRKS+inRealK[i]*(1.0-closeRKS);
    }
}

//calculate membrane potential based on connections of units
void SingleFowardAct(struct NET *netP,double *act,double *net,double **weight)
{
    int i,j;
    double sum;
    for(i=0;i<netP->NetSizeN;i++){
        sum=0.0;
        for(j=0;j<netP->NetSizeN;j++){
            if(weight[i][j]!=0.0){
                sum += weight[i][j]*act[j];
            }
        }
        net[i]=sum;
    }
}

//integrate previous membrane potentioal
void Integration(struct NET *netP,double *net,double *prev_net,double *phi,int cStep)
{
    int i;
    for(i=0;i<netP->InN+netP->ContN;i++){
        net[i]=(1-phi[i])*prev_net[i]+phi[i]*net[i];
    }
}

//calculate activation using soft-max activation function
void SoftMaxActivation(struct NET *netP,double *act,double *net,double *out,double *bias,int cStep)
{
    int i;
    double sum;
    double *val;
    val=(double *)calloc(netP->NetSizeN, sizeof(double));

//activation for motor
    sum=0.0;
    for(i=0;i<SIZE_ARM;i++){
        val[i]=exp(net[i]+bias[i]);
        sum +=val[i];
    }
    for(i=0;i<SIZE_ARM;i++){
        out[i]=val[i]/sum;
    }
//activation for vision
    sum=0.0;
    for(i=SIZE_ARM;i<SIZE_ARM+SIZE_VISION;i++){
        val[i]=exp(net[i]+bias[i]);
        sum +=val[i];
    }
    for(i=SIZE_ARM;i<SIZE_ARM+SIZE_VISION;i++){
        out[i]=val[i]/sum;
    }
//activation for context
    for(i=netP->InN;i<netP->InN+netP->ContN;i++){
        out[i]=sigmoid(net[i]+bias[i]);
//          printf("out[%d][%d]=%f\t",cStep,i,out[cStep][i]);
    }
    free(val);
}

//Forward one step
void ForwardActivation(struct NET *netP,struct KNET *knA,struct KNET *knV,double clRKM,double clRKS,int iseq,int cStep)
{

    int k;

    SetinK(netP->SeqL[iseq].inK[cStep],netP->SeqL[iseq].inPredK[cStep],netP->SeqL[iseq].inRealK[cStep],clRKM,clRKS,netP->inKN);
    KohonenALL(netP->SeqL[iseq].inK[cStep],netP->SeqL[iseq].act[cStep],knA,knV);
    SingleFowardAct(netP,netP->SeqL[iseq].act[cStep],netP->SeqL[iseq].net[cStep],netP->weight);
    if(cStep==0){
        Integration(netP,netP->SeqL[iseq].net[cStep],netP->SeqL[iseq].init_net,netP->phi,cStep);
    }else{
        Integration(netP,netP->SeqL[iseq].net[cStep],netP->SeqL[iseq].net[cStep-1],netP->phi,cStep);
    }
    SoftMaxActivation(netP,netP->SeqL[iseq].act[cStep],netP->SeqL[iseq].net[cStep],netP->SeqL[iseq].out[cStep],netP->bias,cStep);
    if(cStep<netP->SeqL[iseq].steps-netP->delay){
        for(k=netP->InN;k<netP->InN+netP->ContN;k++){
            netP->SeqL[iseq].act[cStep+1][k]=netP->SeqL[iseq].out[cStep][k];
            }
        invKohonenALL(netP->SeqL[iseq].out[cStep],netP->SeqL[iseq].inPredK[cStep+netP->delay],knA,knV);
    }
}

//calculate MSE
double Error_com(struct NET *netP,struct SEQUENCE *seq,double *Error)
{
    int p,j,k;
    double error,error_sum,error_all,error_ave,dummy;
    error_ave=0.0;
    error_all=0.0;

    for(p=0;p<netP->MaxSeq;p++){
        error_sum=0.0;
        for(j=0; j< seq[p].steps-netP->delay+1;j++){
            error=0;
            for(k=0; k<netP->InN;k++){
                dummy = seq[p].out[j][k]-seq[p].teach[j][k];
                dummy = pow(dummy,2.0);
                error += (double)dummy/netP->InN;
            }
            seq[p].MSE_step[j]=error;
            error_sum +=seq[p].MSE_step[j];
        }
        Error[p]=error_sum/(seq[p].steps-netP->delay+1);
        error_all += Error[p];
    }
    error_ave=(double)error_all/netP->MaxSeq;

    return error_ave;
}

//calculate KL-divergence
double KLdiv_com(struct NET *netP,struct SEQUENCE *seq,double *KLdivA,double *KLdivV)
{
    int p,j,k;
    double errorA,errorV,error_all,error_ave,dummy;
    error_ave=0.0;
    error_all=0.0;

    for(p=0;p<netP->MaxSeq;p++){
        KLdivA[p]=0.0;
        KLdivV[p]=0.0;
        for(j=0; j< seq[p].steps-netP->delay+1;j++){
            errorA=0.0;
            errorV=0.0;
            for(k=0; k<SIZE_ARM;k++){
                dummy=0.0;
                if(seq[p].teach[j][k]==0.0){
                    dummy=0.0;
                }
                else{
                    if(seq[p].out[j][k]==0.0){
//                    if(seq[p].out[j][k]<ypsilon){
                        dummy = seq[p].teach[j][k]*log(seq[p].teach[j][k]/ypsilon);
                    }else{
                        dummy = seq[p].teach[j][k]*log(seq[p].teach[j][k]/seq[p].out[j][k]);
                    }
                }
                errorA += dummy;
            }
            seq[p].KLdiv_stepA[j]=errorA;
            KLdivA[p] +=seq[p].KLdiv_stepA[j]/(seq[p].steps-netP->delay+1);

            for(k=SIZE_ARM; k<SIZE_ARM+SIZE_VISION;k++){
                dummy=0.0;
                if(seq[p].teach[j][k]==0.0){
                    dummy=0.0;
                }
                else{
                    if(seq[p].out[j][k]==0.0){
//                    if(seq[p].out[j][k]<ypsilon){
                        dummy = seq[p].teach[j][k]*log(seq[p].teach[j][k]/ypsilon);
                    }else{
                        dummy = seq[p].teach[j][k]*log(seq[p].teach[j][k]/seq[p].out[j][k]);
                    }
                }
                errorV += dummy;
            }
            seq[p].KLdiv_stepV[j]=errorV;
            KLdivV[p] +=seq[p].KLdiv_stepV[j]/(seq[p].steps-netP->delay+1);
        }
        error_all += KLdivA[p]+KLdivV[p];
    }
    error_ave=(double)error_all/(2*netP->MaxSeq);

    return error_ave;
}


//#define UPDATE_BIAS
void Update_wb(struct NET *netP)
{
    int i,j,iseq;
    double dum,sum;
//    double max,min;max=-100000;min=100000;

    for(i=0;i<netP->NetSizeN;i++){
        for(j=0;j<netP->NetSizeN;j++){
            sum=0.0;
            for(iseq=0;iseq<netP->MaxSeq;iseq++){
                sum+=netP->SeqL[iseq].d_weight[i][j];
                netP->SeqL[iseq].d_weight[i][j]=0.0;
            }
            dum=(double)sum/netP->TotalSteps;
            netP->dl_weight[i][j]=netP->epsilon*dum+netP->eta*netP->dl_weight[i][j];
            netP->weight[i][j]-=netP->dl_weight[i][j];
//if(netP->dl_weight[i][j]>max){max=netP->dl_weight[i][j];}if(netP->dl_weight[i][j]<min){min=netP->dl_weight[i][j];}
        }
#ifdef UPDATE_BIAS
        sum=0.0;
        for(iseq=0;iseq<netP->MaxSeq;iseq++){
            sum+=netP->SeqL[iseq].d_bias[i];
            netP->SeqL[iseq].d_bias[i]=0.0;
        }
        dum=(double)sum/netP->TotalSteps;
        netP->dl_bias[i]=netP->epsilon*dum+netP->eta*netP->dl_bias[i];
        netP->bias[i]-=netP->dl_bias[i];
#endif
    }
//printf("max_dw=%.16f\n",max);printf("min_dw=%.16f\n",min);
}

//update initial states
void Updata_InitState(struct NET *netP,int p)
{
    int i;
    double dum;
//    double max,min;max=-100000;min=100000;

    for(i=0;i<netP->InN;i++){
        dum=(double)netP->SeqL[p].d_init_net[i]/netP->SeqL[p].steps;
        netP->SeqL[p].init_net[i]-=netP->rhoX*dum;
    }
    for(i=netP->InN;i<netP->InN+netP->ContN2;i++){
        dum=(double)netP->SeqL[p].d_init_net[i]/netP->SeqL[p].steps;
        netP->SeqL[p].init_net[i]-=netP->rhoCF*dum;
    }
    for(i=netP->InN+netP->ContN2;i<netP->InN+netP->ContN;i++){
        dum=(double)netP->SeqL[p].d_init_net[i]/netP->SeqL[p].steps;
        netP->SeqL[p].init_net[i]-=netP->rhoCS*dum;
//if(dum>max){max=dum;}if(dum<min){min=dum;}
    }

//printf("max_dini=%.16f\n",max);printf("min_dini=%.16f\n",min);
}

//single step back-propagation
void SingleBP(double *act,double *out,double *teach,double *phi,double **weight,double **d_weight,double *d_bias,double *d_net,double *d_init_net,double *prev_d_net,int NetSizeN,int InN,int ContN,int cStep)
{
    int i,j,k;
    double sum;

    for(i=0;i<NetSizeN;i++){
        d_net[i]=0.0;
    }
    for(i=0;i<InN;i++){
        d_net[i]=out[i]-teach[i]+(1-phi[i])*prev_d_net[i];
//        printf("dnet_IN[%d]=%f\t",i,d_net[i]);
        for(j=0;j<NetSizeN;j++){
            if(weight[i][j]!=0){
                d_weight[i][j]+=d_net[i]*phi[i]*act[j];
            }
        }
        d_bias[i]+=out[i]-teach[i];
    }
    for(i=InN;i<InN+ContN;i++){
        sum=0.0;
        for(k=0;k<InN;k++){
            sum +=prev_d_net[k]*phi[k]*weight[k][i]*out[i]*(1-out[i]);
        }
        for(k=InN;k<InN+ContN;k++){
            sum +=prev_d_net[k]*(Krdelta(i,k)*(1-phi[i])+phi[k]*weight[k][i]*out[i]*(1-out[i]));
        }
        d_net[i]=tanh(sum);
//        printf("dnet_CONT[%d]=%f\t",i,d_net[i]);
        sum=0.0;
        for(j=0;j<NetSizeN;j++){
            if(weight[i][j]!=0){
                d_weight[i][j]+=d_net[i]*phi[i]*act[j];
//                printf("d_weight_CONT[%d]=%f\t",i,d_weight[i][j]);
            }
            sum +=prev_d_net[j]*phi[j]*weight[j][i]*out[i]*(1-out[i]);
        }
        d_bias[i]=tanh(sum);
    }

    //for initial states modification, one more backpropagation
    if(cStep==0){
        for(i=InN;i<InN+ContN;i++){
            sum=0.0;
            for(k=0;k<InN;k++){
                sum +=d_net[k]*phi[k]*weight[k][i]*act[i]*(1-act[i]);
            }
            for(k=InN;k<InN+ContN;k++){
                sum +=d_net[k]*(Krdelta(i,k)*(1-phi[i])+phi[k]*weight[k][i]*act[i]*(1-act[i]));
            }
            d_init_net[i]=tanh(sum);
        }
    }

    for(i=0;i<NetSizeN;i++){
        prev_d_net[i]=d_net[i];
    }
}

//back-propagation through time
void Backpropagation(struct NET *netP,struct SEQUENCE *seq)
{
    int i,cStep;

    for(cStep=seq->steps-netP->delay;cStep >=0;cStep--){
        if(cStep==seq->steps-netP->delay){
            for(i=0;i<netP->NetSizeN;i++){
                seq->prev_d_net[i]=0.0;
            }
        }
        SingleBP(seq->act[cStep],seq->out[cStep],seq->teach[cStep],netP->phi,netP->weight,seq->d_weight,seq->d_bias,seq->d_net,seq->d_init_net,seq->prev_d_net,netP->NetSizeN,netP->InN,netP->ContN,cStep);
    }
}





