#include <stdio.h>
#include <stdlib.h>
#include<math.h>

#include "RNN.h"
#include "PlotRealtime.h"
#include "Kohonen.h"


#include<eggx.h>
#include<eggx_color.h>



void RealtimePlotT(struct NET *netP,struct SEQUENCE *seqL, int window,int StatSeq,int EndSeq)
{
    int i,j,k,MODE;
    int r,g,b;
    double gw,gh,dx,dy;

    int InN,ContN,ContN2;
    int TotalSeq;
    InN=netP->InN;
    ContN=netP->ContN;
    ContN2=netP->ContN2;
    TotalSeq=EndSeq-StatSeq;

    layer(window,0,1);gclr(window);

    gw=(double)WIDTH/TotalSeq;
    gh=Graph_Hight;
    dx=0.0;dy=0.0;

    MODE=0; //plot teacher sequence
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        dy=(double)gh/InN;
        for(j=0;j<seqL[i].steps-netP->delay+1;j++){
            for(k=0;k<InN;k++){
                makecolor(IDL2_BLUE_RED,0.0,1.0,seqL[i].teach[j][k],&r,&g,&b);
                newrgbcolor(window,r,g,b);
                fillrect(window,gw*(i-StatSeq)+dx*j,gh*MODE+dy*k,dx,dy);
             }
        }
    }
    MODE=1; //plot net out
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        dy=(double)gh/InN;
        for(j=0;j<seqL[i].steps-netP->delay+1;j++){
            for(k=0;k<InN;k++){
                makecolor(IDL2_BLUE_RED,0.0,1.0,seqL[i].out[j][k],&r,&g,&b);
                newrgbcolor(window,r,g,b);
                fillrect(window,gw*(i-StatSeq)+dx*j,gh*MODE+dy*k,dx,dy);
            }
         }
    }
    MODE=3; //plot teacher Sensori-motor sequence L-arm
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
            newpen(window,2);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK1])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK1])*gh,PENDOWN);
            newpen(window,7);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK2])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK2])*gh,PENDOWN);
            newpen(window,3);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK3])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK3])*gh,PENDOWN);
            newpen(window,5);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK4])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK4])*gh,PENDOWN);
        }
    }
    MODE=4; //plot teacher Sensori-motor sequence R-arm
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
            newpen(window,4);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK5])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK5])*gh,PENDOWN);
            newpen(window,6);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK6])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK6])*gh,PENDOWN);
            newpen(window,1);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK7])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK7])*gh,PENDOWN);
            newpen(window,9);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK8])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK8])*gh,PENDOWN);
        }
    }

    MODE=5; //plot teacher Vision seq
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
            newpen(window,2);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK9])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK9])*gh,PENDOWN);
            newpen(window,7);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inRealK[j][PlotInK10])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inRealK[j+1][PlotInK10])*gh,PENDOWN);
        }
    }

    MODE=6; //plot closed Sensori-motor sequence L-arm
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
            newpen(window,2);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK1])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK1])*gh,PENDOWN);
            newpen(window,7);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK2])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK2])*gh,PENDOWN);
            newpen(window,3);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK3])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK3])*gh,PENDOWN);
            newpen(window,5);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK4])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK4])*gh,PENDOWN);
        } 
    }

    MODE=7; //plot closed Sensori-motor sequence R-arm
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
            newpen(window,4);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK5])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK5])*gh,PENDOWN);
            newpen(window,6);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK6])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK6])*gh,PENDOWN);
            newpen(window,1);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK7])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK7])*gh,PENDOWN);
            newpen(window,9);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK8])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK8])*gh,PENDOWN);
        }
    }

  MODE=8; //plot closed vision sequence Vison
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
            newpen(window,2);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK9])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK9])*gh,PENDOWN);
            newpen(window,7);
            line(window,gw*(i-StatSeq)+dx*j,gh*MODE-(seqL[i].inPredK[j][PlotInK10])*gh,PENUP);
            line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-(seqL[i].inPredK[j+1][PlotInK10])*gh,PENDOWN);
        }
    }

    MODE=8; //plot fast context
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        dy=(double)gh/ContN;
        for(j=0;j<seqL[i].steps-netP->delay+1;j++){
            for(k=0;k<ContN2;k++){
                makecolor(IDL2_BLUE_RED,0.0,1.0,seqL[i].out[j][InN+k],&r,&g,&b);
                newrgbcolor(window,r,g,b);
                fillrect(window,gw*(i-StatSeq)+dx*j,gh*MODE+dy*k,dx,dy);
             }
        }
    }

    MODE=9; //plot slow context
    for(i=StatSeq;i<EndSeq;i++){
        dx=(double)gw/(seqL[i].steps-netP->delay);
        dy=(double)gh/ContN;
        for(j=0;j<seqL[i].steps-netP->delay+1;j++){
            for(k=0;k<ContN-ContN2;k++){
                makecolor(IDL2_BLUE_RED,0.0,1.0,seqL[i].out[j][InN+ContN2+k],&r,&g,&b);
                newrgbcolor(window,r,g,b);
                fillrect(window,gw*(i-StatSeq)+dx*j,gh*MODE+dy*k,dx,dy);
             }
        }
    }

    MODE=11; //KL-arm adn vision
    double maxY=5.0;
    for(i=StatSeq;i<EndSeq;i++){
        dy=(double)gh/maxY;
        dx=(double)gw/(seqL[i].steps-netP->delay);
        for(j=0;j<seqL[i].steps-netP->delay;j++){
                newpen(window,7);
                line(window,gw*(i-StatSeq)+dx*j,gh*MODE-dy*(seqL[i].KLdiv_stepA[j]),PENUP);
                line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-dy*(seqL[i].KLdiv_stepA[j+1]),PENDOWN);
                newpen(window,2);
                line(window,gw*(i-StatSeq)+dx*j,gh*MODE-dy*(seqL[i].KLdiv_stepV[j]),PENUP);
                line(window,gw*(i-StatSeq)+dx*(j+1),gh*MODE-dy*(seqL[i].KLdiv_stepV[j+1]),PENDOWN);
        }
    }

    newpen(window,1);
    for(i=0;i<1;i++){
    drawstr(window,gw*i+10,15,15,0,"RNN teach");      //MODE=0
    drawstr(window,gw*i+10,15+gh*1,15,0,"RNN out");     //MODE=1
    drawstr(window,gw*i+10,15+gh*2,15,0,"teach Arm-L");    //MODE=2
    drawstr(window,gw*i+10,15+gh*3,15,0,"teach Arm-R");    //MODE=3
    drawstr(window,gw*i+10,15+gh*4,15,0,"teach Vision");    //MODE=4
    drawstr(window,gw*i+10,15+gh*5,15,0,"pred Arm-L");    //MODE=5
    drawstr(window,gw*i+10,15+gh*6,15,0,"pred Arm-R");    //MODE=6
    drawstr(window,gw*i+10,15+gh*7,15,0,"pred Vision");    //MODE=7
    drawstr(window,gw*i+10,-10+gh*9,15,0,"Fast Cx");
    drawstr(window,gw*i+10,-10+gh*10,15,0,"Slow Cx");
    drawstr(window,gw*i+10,15+gh*11,15,0,"KL-div");
    }

#if 1
// for color example 
    double s;
    for(i=0;i<100;i++){
        s=0.01*i;
        makecolor(IDL2_BLUE_RED,0.0,1.0,s,&r,&g,&b);
        newrgbcolor(window,r,g,b);
        fillrect(window,WIDTH-45,gh*12-s*gh,20,1);}
    newpen(window,1);
    drawstr(window,WIDTH-25,gh*11+10,15,0,"1.0");
    drawstr(window,WIDTH-25,gh*11+0.5*gh,15,0,"0.5");
    drawstr(window,WIDTH-25,gh*11+gh-3,15,0,"0.0");
#endif

#if 1
    newpen(window,8);
    for(i=1;i<seqL[0].steps;i++){
        if(i%25==0){
            newpen(window,8);
            line(window,dx*i,0.0,PENUP);
            line(window,dx*i,HIGHT,PENDOWN);
            drawstr(window,dx*i,-10+gh*12,15,0,"%d",i);
        }
    }
#endif

    newpen(window,8);
    for(i=1;i<TotalSeq;i++){
        line(window,gw*i,0.0,PENUP);
        line(window,gw*i,HIGHT,PENDOWN);
    }
    for(i=2;i<PLOT_PARA;i++){
        line(window,0.0,gh*i,PENUP);
        line(window,WIDTH,gh*i,PENDOWN);
    }

    copylayer(window,1,0);
}



//#define CHECK_CONNECTION
void draw_WeightMatrix(struct NET *netP,double **w,double *bias,int window)
{
    int i,j;
    int r,g,b;
    double cell,gw;

    layer(window,0,1);gclr(window);

    gw=WIDTHW-100;
    cell=(double)gw/(netP->InN+netP->ContN);

    for(i=0;i<netP->NetSizeN;i++){
        for(j = 0;j < netP->NetSizeN;j++){
#ifdef CHECK_CONNECTION
            makecolor(IDL2_BLUE_RED,-0.01,0.01,w[i][j],&r,&g,&b);
#else
            makecolor(IDL2_BLUE_RED,-2.0,2.0,w[i][j],&r,&g,&b);
#endif
            newrgbcolor(window,r,g,b);
            fillrect(window,cell*i,cell*j,cell,cell);
        }
#ifdef CHECK_CONNECTION
        makecolor(IDL2_BLUE_RED,-0.01,0.01,bias[i],&r,&g,&b);
#else
        makecolor(IDL2_BLUE_RED,-2.0,2.0,bias[i],&r,&g,&b);
#endif
        newrgbcolor(window,r,g,b);
        fillrect(window,gw+cell*3,cell*i,cell*3,cell);
    }

    newpen(window,8);
    line(window,cell*SIZE_ARM,-0.001,PENUP);
    line(window,cell*SIZE_ARM,cell*(netP->InN+netP->ContN)+0.001,PENDOWN);
    line(window,cell*netP->InN,-0.001,PENUP);
    line(window,cell*netP->InN,cell*(netP->InN+netP->ContN)+0.001,PENDOWN);
    line(window,cell*(netP->InN+netP->ContN2),-0.001,PENUP);
    line(window,cell*(netP->InN+netP->ContN2),cell*(netP->InN+netP->ContN)+0.001,PENDOWN);
    line(window,cell*(netP->InN+netP->ContN),-0.001,PENUP);
    line(window,cell*(netP->InN+netP->ContN),cell*(netP->InN+netP->ContN)+0.001,PENDOWN);

    line(window,-0.001,cell*SIZE_ARM,PENUP);
    line(window,cell*(netP->InN+netP->ContN)+0.001,cell*SIZE_ARM,PENDOWN);
    line(window,-0.001,cell*netP->InN,PENUP);
    line(window,cell*(netP->InN+netP->ContN)+0.001,cell*netP->InN,PENDOWN);
    line(window,-0.001,cell*(netP->InN+netP->ContN2),PENUP);
    line(window,cell*(netP->InN+netP->ContN)+0.001,cell*(netP->InN+netP->ContN2),PENDOWN);
    line(window,-0.001,cell*(netP->InN+netP->ContN),PENUP);
    line(window,cell*(netP->InN+netP->ContN)+0.001,cell*(netP->InN+netP->ContN),PENDOWN);
    newpen(window,1);
    drawstr(window,35,WIDTHW-40,15,0,"X-axis:to");
    drawstr(window,35,WIDTHW-25,15,0,"Y-axis:from");

/* for color example */
    double s;
    for(i=0;i<100;i++){
        s=0.01*i;
        makecolor(IDL2_BLUE_RED,0.0,1.0,s,&r,&g,&b);
        newrgbcolor(window,r,g,b);
        fillrect(window,WIDTHW-45,WIDTHW-80*s,20,1);}
    newpen(window,1);
    drawstr(window,WIDTHW-35,WIDTHW-80,15,0,"2.0");
    drawstr(window,WIDTHW-35,WIDTHW-40,15,0,"0.0");
    drawstr(window,WIDTHW-35,WIDTHW-2,15,0,"-2.0");

    copylayer(window,1,0);
}

