#ifndef _KOHONEN_H_
#define _KOHONEN_H_


typedef struct KNET{
    int size;
    int sizeX;
    int sizeY;
    int DimIn;
//    double sigF;
    double sigG;

    double **data; //[maxSeq*steps][DimIn]
    double **activ; //[maxSeq*steps][SIZE]
    struct KNEURON *kneuron;//[SIZE]
    }KNET;

typedef struct KNEURON{
    int X;
    int Y;
    double *D;//[DimIn] dif between data&W: data[]-W[]
    double k_dis;
    double *W;//[DimIn] reference vector
    double disF;
    double *disNeuron;//[SIZE]
    }KNEURON;


#define SIZE_ARM 64 /* # of units in Kohonen net for arm motor */
#define SIZE_VISION 36 /* # of units in Kohonen net for arm motor */

#define	SIDE_XA 8    /* neuron num of 1 dimension (6) */
#define	SIDE_XV 6    /* neuron num of 1 dimension (6) */

#define DataDim_ARM 8
#define DataDim_VISION 2

#define Flag_VISION 8 /*index for the begining of vision data*/

#define ARM 0
#define VISION 1

#define SIGGA 0.01 //sigma for Arm
#define SIGGV 0.01 //sigma for Vision

void read_weightK(FILE *fp,struct KNET *knet);
void Init_knet(struct KNET *knet);
struct KNET* get_alloc_knet(int DataSource);

void KohonenALL(double *dat,double *resK,struct KNET *knA,struct KNET *knV);
void invKohonenALL(double *dat,double *resIvK,struct KNET *knA,struct KNET *knV);


#endif
