#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>


#include "Kohonen.h"
#include "RNN.h"


void init_w(struct KNET *knet)
{
    int i,j;
    for(i=0;i<knet->size;i++){
        for(j=0;j<knet->DimIn;j++){
            knet->kneuron[i].W[j]=unif_rand(-0.01,0.01);
        }
    }
}

void read_weightK(FILE *fp,struct KNET *knet)
{
    int i,j,sz;

    fscanf(fp,"%d",&sz);

    for(i=0;i<knet->size;i++){
        for(j=0;j<knet->DimIn;j++){
            fscanf(fp,"%lf",&knet->kneuron[i].W[j]);
        }
    }
}


void set_XY(struct KNET *knet)
{
    int i,j,k;
    i=0;
    for(j=0;j<knet->sizeX;j++){
        for(k=0;k<knet->sizeY;k++){
            knet->kneuron[i].X=j;
            knet->kneuron[i].Y=k;
            i++;
        }
    }
}


void set_disNeur(struct KNET *knet)
{
    int i,j;double X,Y;

    for(i=0;i<knet->size;i++){
        for(j=0;j<knet->size;j++){
            X=(double)(knet->kneuron[i].X-knet->kneuron[j].X)*(knet->kneuron[i].X-knet->kneuron[j].X);
            Y=(double)(knet->kneuron[i].Y-knet->kneuron[j].Y)*(knet->kneuron[i].Y-knet->kneuron[j].Y);
            knet->kneuron[i].disNeuron[j]=X+Y;
        }
    }
}



void alloc_kneuron(struct KNET *knet)
{
    int i;
    knet->kneuron=(struct KNEURON *)calloc(knet->size, sizeof(struct KNEURON));
    for(i=0;i<knet->size;i++){
        knet->kneuron[i].W=(double *)calloc(knet->DimIn, sizeof(double));
        knet->kneuron[i].D=(double *)calloc(knet->DimIn, sizeof(double));
        knet->kneuron[i].disNeuron=(double *)calloc(knet->size, sizeof(double));
    }
}


void Init_knet(struct KNET *knet)
{
    alloc_kneuron(knet);
    init_w(knet);
    set_XY(knet);
    set_disNeur(knet);
}


void set_paramKNET(struct KNET *knet,int DataSource)
{
    if(DataSource==ARM){
        knet->DimIn=DataDim_ARM;
        knet->size=SIZE_ARM;
        knet->sizeX=SIDE_XA;
        knet->sizeY=SIDE_XA;
//        knet->sigF=SIGFA;
        knet->sigG=SIGGA;
    }

    else if(DataSource==VISION){
        knet->DimIn=DataDim_VISION;
        knet->size=SIZE_VISION;
        knet->sizeX=SIDE_XV;
        knet->sizeY=SIDE_XV;
//        knet->sigF=SIGFV;
        knet->sigG=SIGGV;
    }
}


struct KNET* get_alloc_knet(int DataSource)
{
    struct KNET *knet;
    knet=(struct KNET *)calloc(1, sizeof(struct KNET));
    set_paramKNET(knet,DataSource);
    return knet;
}


void compute_kdistance(double *dat,struct KNET *knet)
{
    int i,j;
    double sum;

    for(i=0;i<knet->size;i++){
        for(sum=0.0,j=0;j<knet->DimIn;j++){
            knet->kneuron[i].D[j]=dat[j]-knet->kneuron[i].W[j];
//            printf("knet-kneuron[%d].D[%d]=%f\t",i,j,knet->kneuron[i].D[j]);
            sum += pow(knet->kneuron[i].D[j],2.0);
        }
//        printf("\n");
        knet->kneuron[i].k_dis =sum;
    }
}


void set_outputK(struct KNET *knet,double *resK,double sig)
{
    int i;
    double denomi;
    double *numera;
    numera=(double*)calloc(knet->size,sizeof(double));

    denomi=0.0;
    for(i=0;i<knet->size;i++){
        numera[i]=exp(-(knet->kneuron[i].k_dis)/sig);
        denomi+=numera[i];
    }
    for(i=0;i<knet->size;i++){
        resK[i]=numera[i]/denomi;
    }
    free(numera);
}


void Kohonen(double *dat,double *resK,struct KNET *knet)
{
    double sigmaK;

    compute_kdistance(dat,knet);
    sigmaK = knet->sigG;
    set_outputK(knet,resK,sigmaK);
}


void invKohonen(double *dat,double *resIvK,struct KNET *knet)
{
    int i,j;
    for(i=0;i<knet->DimIn;i++){
        resIvK[i]=0.0;
        for(j=0;j<knet->size;j++){
           resIvK[i]+=dat[j]*(knet->kneuron[j].W[i]);
        }
    }
}

void KohonenALL(double *dat,double *resK,struct KNET *knA,struct KNET *knV)
{
    Kohonen(dat,resK,knA);
    Kohonen(dat+Flag_VISION,resK+SIZE_ARM,knV);
}


void invKohonenALL(double *dat,double *resIvK,struct KNET *knA,struct KNET *knV)
{
    invKohonen(dat,resIvK,knA);
    invKohonen(dat+SIZE_ARM,resIvK+Flag_VISION,knV);
}



